/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.TailType;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;

public class EqTailType
extends TailType {
    public static final TailType INSTANCE = new EqTailType();

    protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
        CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)editor.getProject());
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor);
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)tailOffset);
        return codeStyleFacade.useSpaceAroundAssignmentOperators(psiFile, language);
    }

    public int processTail(Editor editor, int tailOffset) {
        Document document = editor.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
            return EqTailType.moveCaret((Editor)editor, (int)tailOffset, (int)2);
        }
        if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
            return EqTailType.moveCaret((Editor)editor, (int)tailOffset, (int)1);
        }
        if (this.isSpaceAroundAssignmentOperators(editor, tailOffset)) {
            document.insertString(tailOffset, (CharSequence)" =");
            tailOffset = EqTailType.moveCaret((Editor)editor, (int)tailOffset, (int)2);
            tailOffset = EqTailType.insertChar((Editor)editor, (int)tailOffset, (char)' ');
        } else {
            document.insertString(tailOffset, (CharSequence)"=");
            tailOffset = EqTailType.moveCaret((Editor)editor, (int)tailOffset, (int)1);
        }
        return tailOffset;
    }
}

