/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006*"}, d2={"Lcom/intellij/codeInsight/hints/presentation/SequencePresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "presentations", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Ljava/util/List;)V", "<set-?>", "", "height", "getHeight", "()I", "presentationUnderCursor", "getPresentations", "()Ljava/util/List;", "width", "getWidth", "calcDimensions", "", "changePresentationUnderCursor", "presentation", "handleMouse", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "updateState", "", "previousPresentation", "InternalListener", "intellij.platform.lang.impl"})
public final class SequencePresentation
extends BasePresentation {
    private int width;
    private int height;
    private InlayPresentation presentationUnderCursor;
    @NotNull
    private final List<InlayPresentation> presentations;

    /*
     * WARNING - void declaration
     */
    public final void calcDimensions() {
        Object var10_14;
        Object v0;
        void $this$maxBy$iv;
        int n;
        Iterable $this$sumBy$iv;
        Iterable iterable = this.presentations;
        SequencePresentation sequencePresentation = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            InlayPresentation inlayPresentation = (InlayPresentation)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n2 = it.getWidth();
            sum$iv = n + n2;
        }
        sequencePresentation.width = n = sum$iv;
        $this$sumBy$iv = this.presentations;
        sequencePresentation = this;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                InlayPresentation it = (InlayPresentation)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getHeight();
                do {
                    Object e$iv = iterator$iv.next();
                    InlayPresentation it2 = (InlayPresentation)e$iv;
                    $i$a$-maxBy-SequencePresentation$calcDimensions$2 = false;
                    int v$iv = it2.getHeight();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Object v1 = var10_14 = v0;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        sequencePresentation.height = ((InlayPresentation)v1).getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        int xOffset = 0;
        try {
            for (InlayPresentation presentation : this.presentations) {
                presentation.paint(g, attributes);
                xOffset += presentation.getWidth();
                g.translate(presentation.getWidth(), 0);
            }
        }
        finally {
            g.translate(-xOffset, 0);
        }
    }

    private final void handleMouse(Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        int x = original.x;
        int y = original.y;
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        int xOffset = 0;
        for (InlayPresentation presentation : this.presentations) {
            int presentationWidth = presentation.getWidth();
            if (x < xOffset + presentationWidth) {
                if (y > presentation.getHeight()) {
                    this.changePresentationUnderCursor(null);
                    return;
                }
                this.changePresentationUnderCursor(presentation);
                Point translated = PresentationUtilKt.translateNew(original, -xOffset, 0);
                action2.invoke((Object)presentation, (Object)translated);
                return;
            }
            xOffset += presentationWidth;
        }
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                presentation.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation, @NotNull Point point) {
                Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                Intrinsics.checkParameterIsNotNull((Object)point, (String)"point");
                presentation.mouseMoved(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseExited() {
        this.changePresentationUnderCursor(null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean updateState(@NotNull InlayPresentation previousPresentation) {
        Intrinsics.checkParameterIsNotNull((Object)previousPresentation, (String)"previousPresentation");
        if (!(previousPresentation instanceof SequencePresentation)) {
            return true;
        }
        if (((SequencePresentation)previousPresentation).presentations.size() != this.presentations.size()) {
            return true;
        }
        List<InlayPresentation> previousPresentations = ((SequencePresentation)previousPresentation).presentations;
        boolean changed2 = false;
        boolean bl = false;
        for (InlayPresentation presentation : (Iterable)this.presentations) {
            void index;
            if (presentation.updateState(previousPresentations.get((int)index))) {
                changed2 = true;
            }
            ++index;
        }
        return changed2;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.presentations, (CharSequence)" ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    private final void changePresentationUnderCursor(InlayPresentation presentation) {
        if (Intrinsics.areEqual((Object)this.presentationUnderCursor, (Object)presentation) ^ true) {
            InlayPresentation inlayPresentation = this.presentationUnderCursor;
            if (inlayPresentation != null) {
                inlayPresentation.mouseExited();
            }
            this.presentationUnderCursor = presentation;
        }
    }

    @NotNull
    public final List<InlayPresentation> getPresentations() {
        return this.presentations;
    }

    public SequencePresentation(@NotNull List<? extends InlayPresentation> presentations) {
        Intrinsics.checkParameterIsNotNull(presentations, (String)"presentations");
        this.presentations = presentations;
        if (this.presentations.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (InlayPresentation presentation : this.presentations) {
            presentation.addListener((PresentationListener)new InternalListener(presentation));
        }
        this.calcDimensions();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/SequencePresentation$InternalListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "currentPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Lcom/intellij/codeInsight/hints/presentation/SequencePresentation;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "shiftOfCurrent", "", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang.impl"})
    private final class InternalListener
    implements PresentationListener {
        private final InlayPresentation currentPresentation;

        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkParameterIsNotNull((Object)area, (String)"area");
            area.add(this.shiftOfCurrent(), 0);
            SequencePresentation.this.fireContentChanged(area);
        }

        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current2) {
            Intrinsics.checkParameterIsNotNull((Object)previous, (String)"previous");
            Intrinsics.checkParameterIsNotNull((Object)current2, (String)"current");
            Dimension old = InlayHintsUtilsKt.dimension((InlayPresentation)SequencePresentation.this);
            SequencePresentation.this.calcDimensions();
            Dimension dimension = InlayHintsUtilsKt.dimension((InlayPresentation)SequencePresentation.this);
            SequencePresentation.this.fireSizeChanged(old, dimension);
        }

        private final int shiftOfCurrent() {
            int shift = 0;
            for (InlayPresentation presentation : SequencePresentation.this.getPresentations()) {
                if (presentation == this.currentPresentation) {
                    return shift;
                }
                shift += presentation.getWidth();
            }
            throw (Throwable)new IllegalStateException();
        }

        public InternalListener(InlayPresentation currentPresentation) {
            Intrinsics.checkParameterIsNotNull((Object)currentPresentation, (String)"currentPresentation");
            this.currentPresentation = currentPresentation;
        }
    }
}

