/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.lang.Language;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> myHints;
    private final TIntObjectHashMap<String> myShowOnlyIfExistedBeforeHints;
    private final PsiElement myRootElement;
    private final HintInfoFilter myHintInfoFilter;
    private final boolean myForceImmediateUpdate;

    public static void syncUpdate(@NotNull PsiElement element2, @NotNull Editor editor) {
        if (element2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ParameterHintsPass.$$$reportNull$$$0(1);
        }
        MethodInfoBlacklistFilter filter2 = MethodInfoBlacklistFilter.forLanguage(element2.getLanguage());
        ParameterHintsPass pass = new ParameterHintsPass(element2, editor, filter2, true);
        try {
            pass.doCollectInformation(new ProgressIndicatorBase());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        pass.applyInformationToEditor();
    }

    public ParameterHintsPass(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull HintInfoFilter hintsFilter, boolean forceImmediateUpdate) {
        if (element2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ParameterHintsPass.$$$reportNull$$$0(3);
        }
        if (hintsFilter == null) {
            ParameterHintsPass.$$$reportNull$$$0(4);
        }
        super(editor, element2.getContainingFile(), true);
        this.myHints = new TIntObjectHashMap();
        this.myShowOnlyIfExistedBeforeHints = new TIntObjectHashMap();
        this.myRootElement = element2;
        this.myHintInfoFilter = hintsFilter;
        this.myForceImmediateUpdate = forceImmediateUpdate;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(5);
        }
        assert (this.myDocument != null);
        this.myHints.clear();
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null || !provider.canShowHintsWhenDisabled() && !ParameterHintsPass.isEnabled(language) || DiffUtil.isDiffEditor(this.myEditor)) {
            return;
        }
        if (!HighlightingLevelManager.getInstance(this.myFile.getProject()).shouldHighlight((PsiElement)this.myFile)) {
            return;
        }
        provider.createTraversal(this.myRootElement).forEach(element2 -> this.process((PsiElement)element2, provider));
    }

    private static boolean isEnabled(Language language) {
        return HintUtilsKt.isParameterHintsEnabledForLanguage(language);
    }

    private void process(@NotNull PsiElement element2, @NotNull InlayParameterHintsProvider provider) {
        List hints;
        if (element2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            ParameterHintsPass.$$$reportNull$$$0(7);
        }
        if ((hints = provider.getParameterHints(element2, this.myFile)).isEmpty()) {
            return;
        }
        HintInfo info = provider.getHintInfo(element2, this.myFile);
        boolean showHints = info == null || info instanceof HintInfo.OptionInfo || this.myHintInfoFilter.showHint(info);
        Stream<Object> inlays = hints.stream();
        if (!showHints) {
            inlays = inlays.filter(inlayInfo -> !inlayInfo.isFilterByBlacklist());
        }
        inlays.forEach(hint -> {
            int offset = hint.getOffset();
            if (!this.canShowHintsAtOffset(offset)) {
                return;
            }
            String presentation = provider.getInlayPresentation(hint.getText());
            if (hint.isShowOnlyIfExistedBefore()) {
                this.myShowOnlyIfExistedBeforeHints.put(offset, (Object)presentation);
            } else {
                ArrayList<HintData> hintList = (ArrayList<HintData>)this.myHints.get(offset);
                if (hintList == null) {
                    hintList = new ArrayList<HintData>();
                    this.myHints.put(offset, hintList);
                }
                HintWidthAdjustment widthAdjustment = ParameterHintsPass.convertHintPresentation(hint.getWidthAdjustment(), provider);
                hintList.add(new HintData(presentation, hint.getRelatesToPrecedingText(), widthAdjustment));
            }
        });
    }

    private static HintWidthAdjustment convertHintPresentation(HintWidthAdjustment widthAdjustment, InlayParameterHintsProvider provider) {
        String adjusterHintPresentation;
        String hintText;
        if (widthAdjustment != null && (hintText = widthAdjustment.getHintTextToMatch()) != null && !hintText.equals(adjusterHintPresentation = provider.getInlayPresentation(hintText))) {
            widthAdjustment = new HintWidthAdjustment(widthAdjustment.getEditorTextToMatch(), adjusterHintPresentation, widthAdjustment.getAdjustmentPosition());
        }
        return widthAdjustment;
    }

    @Override
    public void doApplyInformationToEditor() {
        EditorScrollingPositionKeeper.perform(this.myEditor, false, () -> {
            ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
            List<Inlay> hints = this.hintsInRootElementArea(manager);
            ParameterHintsUpdater updater2 = new ParameterHintsUpdater(this.myEditor, hints, this.myHints, this.myShowOnlyIfExistedBeforeHints, this.myForceImmediateUpdate);
            updater2.update();
        });
        if (ParameterHintsUpdater.hintRemovalDelayed(this.myEditor)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
        } else if (this.myRootElement == this.myFile) {
            ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
        }
    }

    @NotNull
    private List<Inlay> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        assert (this.myDocument != null);
        TextRange range2 = this.myRootElement.getTextRange();
        int elementStart = range2.getStartOffset();
        int elementEnd = range2.getEndOffset();
        if (this.myDocument.getTextLength() != range2.getLength()) {
            ++elementStart;
            --elementEnd;
        }
        List<Inlay> list2 = manager.getParameterHintsInRange(this.myEditor, elementStart, elementEnd);
        if (list2 == null) {
            ParameterHintsPass.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private boolean canShowHintsAtOffset(int offset) {
        TextRange rootRange = this.myRootElement.getTextRange();
        if (!rootRange.containsOffset(offset)) {
            return false;
        }
        if (offset > rootRange.getStartOffset() && offset < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument != null && this.myDocument.getTextLength() == rootRange.getLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintsFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsPass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "hintsInRootElementArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "syncUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HintData {
        public final String presentationText;
        public final boolean relatesToPrecedingText;
        public final HintWidthAdjustment widthAdjustment;

        public HintData(String text2, boolean relatesToPrecedingText, HintWidthAdjustment widthAdjustment) {
            this.presentationText = text2;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.widthAdjustment = widthAdjustment;
        }
    }
}

