/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;

public class FoldingTransferableData
implements TextBlockTransferableData,
Serializable {
    private final FoldingData[] myFoldingDatas;

    public FoldingTransferableData(FoldingData[] foldingDatas) {
        this.myFoldingDatas = foldingDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return FoldingData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myFoldingDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets2, int index) {
        for (FoldingData data2 : this.myFoldingDatas) {
            offsets2[index++] = data2.startOffset;
            offsets2[index++] = data2.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets2, int index) {
        for (FoldingData data2 : this.myFoldingDatas) {
            data2.startOffset = offsets2[index++];
            data2.endOffset = offsets2[index++];
        }
        return index;
    }

    protected FoldingTransferableData clone() {
        FoldingData[] newFoldingData = new FoldingData[this.myFoldingDatas.length];
        for (int i = 0; i < this.myFoldingDatas.length; ++i) {
            newFoldingData[i] = (FoldingData)this.myFoldingDatas[i].clone();
        }
        return new FoldingTransferableData(newFoldingData);
    }

    public FoldingData[] getData() {
        return this.myFoldingDatas;
    }
}

