/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;
import org.fest.util.Lists;

final class JDesktopPaneChildrenFinder
implements ChildrenFinderStrategy {
    JDesktopPaneChildrenFinder() {
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        if (!(c instanceof JDesktopPane)) {
            return Lists.emptyList();
        }
        return this.internalFramesFromIcons(c);
    }

    @Nonnull
    @RunsInCurrentThread
    private Collection<Component> internalFramesFromIcons(@Nonnull Container c) {
        ArrayList frames = Lists.newArrayList();
        for (Component child : c.getComponents()) {
            if (child instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame frame = ((JInternalFrame.JDesktopIcon)child).getInternalFrame();
                if (frame == null) continue;
                frames.add(frame);
                continue;
            }
            if (!(child instanceof Container)) continue;
            frames.addAll(this.internalFramesFromIcons((Container)child));
        }
        return frames;
    }
}

