/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class WindowDriver
extends ContainerDriver {
    public WindowDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void resizeWidthTo(@Nonnull Window w, int width) {
        this.doResizeWidth(w, width);
    }

    @RunsInEDT
    public void resizeHeightTo(@Nonnull Window w, int height) {
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull Window w, @Nonnull Dimension size) {
        this.resize(w, size.width, size.height);
    }

    public void moveTo(@Nonnull Window w, @Nonnull Point where) {
        this.move(w, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull Window w) {
        this.moveMouseIgnoringAnyError(w, WindowDriver.closeInfo(w));
        this.robot.close(w);
    }

    @Nonnull
    @RunsInEDT
    private static Point closeInfo(final @Nonnull Window w) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(w);
                return WindowLikeContainers.closeButtonLocation(w);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void show(@Nonnull Window w) {
        this.robot.showWindow(w);
    }

    @RunsInEDT
    public void show(@Nonnull Window w, @Nonnull Dimension size) {
        this.robot.showWindow(w, size);
    }

    @RunsInEDT
    public void moveToFront(@Nonnull Window w) {
        WindowDriver.doMoveToFront(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToFront(final @Nonnull Window w) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                w.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(@Nonnull Window w) {
        WindowDriver.doMoveToBack(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToBack(final @Nonnull Window w) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                w.toBack();
            }
        });
    }
}

