/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Lists;

final class KeyStrokes {
    @Nonnull
    @RunsInCurrentThread
    static KeyStroke[] findKeyStrokesForAction(@Nonnull String actionName, @Nonnull Object actionKey, @Nonnull InputMap inputMap) {
        ArrayList keyStrokes = Lists.newArrayList();
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            if (!actionKey.equals(inputMap.get(keyStroke))) continue;
            keyStrokes.add(keyStroke);
        }
        if (!keyStrokes.isEmpty()) {
            return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
        }
        throw ActionFailedException.actionFailure(String.format("Unable to find valid input event for action with key '%s'", actionName));
    }

    private KeyStrokes() {
    }
}

