/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

final class JTreeVerifySelectionTask {
    @RunsInEDT
    static void checkHasSelection(final @Nonnull JTree tree, final @Nonnull int[] selection, final @Nonnull Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree, @Nonnull int[] selection, @Nonnull Description errMsg) {
        int[] selectionRows = tree.getSelectionRows();
        if (selectionRows == null || selectionRows.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        java.util.Arrays.sort(selection);
        if (java.util.Arrays.equals(selectionRows, selection)) {
            return;
        }
        throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionRows);
    }

    @Nonnull
    private static AssertionError failNotEqualSelection(@Nonnull Description errMsg, @Nonnull int[] expected, @Nonnull int[] actual) {
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), Arrays.format((Object)expected), Arrays.format((Object)actual));
        throw Fail.fail((String)msg);
    }

    @RunsInEDT
    static void checkHasSelection(final @Nonnull JTree tree, final @Nonnull String[] selection, final @Nonnull JTreePathFinder pathFinder, final @Nonnull Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTreeVerifySelectionTask.checkSelection(tree, selection, pathFinder, errMsg);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelection(@Nonnull JTree tree, @Nonnull String[] selection, @Nonnull JTreePathFinder pathFinder, @Nonnull Description errMsg) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            JTreeVerifySelectionTask.failNoSelection(errMsg);
            return;
        }
        int selectionCount = selection.length;
        if (selectionCount != selectionPaths.length) {
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
        for (int i = 0; i < selectionCount; ++i) {
            TreePath actual;
            TreePath expected = JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, (String)Preconditions.checkNotNull((Object)selection[i]), pathFinder);
            if (Objects.areEqual((Object)expected, (Object)(actual = selectionPaths[i]))) continue;
            throw JTreeVerifySelectionTask.failNotEqualSelection(errMsg, selection, selectionPaths);
        }
    }

    @Nonnull
    private static AssertionError failNotEqualSelection(@Nonnull Description errMsg, @Nonnull String[] expected, @Nonnull TreePath[] actual) {
        String format = "[%s] expecting selection:<%s> but was:<%s>";
        String msg = String.format(format, errMsg.value(), Arrays.format((Object)expected), Arrays.format((Object)actual));
        throw Fail.fail((String)msg);
    }

    private static void failNoSelection(@Nonnull Description errMessage) {
        Fail.fail((String)String.format("[%s] No selection", errMessage.value()));
    }

    @RunsInEDT
    static void checkNoSelection(final @Nonnull JTree tree, final @Nonnull Description errMsg) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                String format = "[%s] expected no selection but was:<%s>";
                String message = String.format(format, errMsg.value(), Arrays.format((Object)tree.getSelectionPaths()));
                Fail.fail((String)message);
            }
        });
    }

    private JTreeVerifySelectionTask() {
    }
}

