/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JSplitPane;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSplitPaneLocationCalculator;
import org.fest.swing.driver.JSplitPaneSetDividerLocationTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.GenericRange;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JSplitPaneDriver
extends JComponentDriver {
    public JSplitPaneDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveDividerTo(@Nonnull JSplitPane splitPane, int location) {
        int newLocation = JSplitPaneLocationCalculator.locationToMoveDividerTo(splitPane, location);
        this.simulateMovingDivider(splitPane, newLocation);
        JSplitPaneSetDividerLocationTask.setDividerLocation(splitPane, newLocation);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane split, int location) {
        if (split.getOrientation() == 0) {
            this.simulateMovingDividerVertically(split, location);
            return;
        }
        this.simulateMovingDividerHorizontally(split, location);
    }

    @RunsInEDT
    private void simulateMovingDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerVertically(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerVertically(final @Nonnull JSplitPane splitPane, final int location) {
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerVertically(splitPane, location);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerVertically(@Nonnull JSplitPane splitPane, int location) {
        int x = splitPane.getWidth() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(x, dividerLocation), new Point(x, location));
    }

    private void simulateMovingDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        GenericRange<Point> whereToMove = JSplitPaneDriver.findWhereToMoveDividerHorizontally(splitPane, location);
        this.simulateMovingDivider(splitPane, whereToMove);
    }

    @Nonnull
    @RunsInEDT
    private static GenericRange<Point> findWhereToMoveDividerHorizontally(final @Nonnull JSplitPane splitPane, final int location) {
        GenericRange<Point> result = GuiActionRunner.execute(new GuiQuery<GenericRange<Point>>(){

            @Override
            protected GenericRange<Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(splitPane);
                return JSplitPaneDriver.whereToMoveDividerHorizontally(splitPane, location);
            }
        });
        return (GenericRange)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInCurrentThread
    private static GenericRange<Point> whereToMoveDividerHorizontally(@Nonnull JSplitPane splitPane, int location) {
        int y = splitPane.getHeight() / 2;
        int dividerLocation = splitPane.getDividerLocation();
        return new GenericRange<Point>(new Point(dividerLocation, y), new Point(location, y));
    }

    @RunsInEDT
    private void simulateMovingDivider(@Nonnull JSplitPane splitPane, @Nonnull GenericRange<Point> range) {
        try {
            this.robot.moveMouse(splitPane, range.from());
            this.robot.pressMouse(MouseButton.LEFT_BUTTON);
            this.robot.moveMouse(splitPane, range.to());
            this.robot.releaseMouse(MouseButton.LEFT_BUTTON);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

