/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.MenuElementComponentQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Preconditions;

final class JPopupMenuElementsAsTextQuery {
    @Nonnull
    @RunsInEDT
    static String[] menuElementsAsText(final @Nonnull JPopupMenu popupMenu) {
        String[] result = GuiActionRunner.execute(new GuiQuery<String[]>(){

            @Override
            protected String[] executeInEDT() throws Throwable {
                MenuElement[] subElements = popupMenu.getSubElements();
                String[] result = new String[subElements.length];
                for (int i = 0; i < subElements.length; ++i) {
                    MenuElement subElement = (MenuElement)Preconditions.checkNotNull((Object)subElements[i]);
                    result[i] = JPopupMenuElementsAsTextQuery.textOf(subElement);
                }
                return result;
            }
        });
        return (String[])Preconditions.checkNotNull((Object)result);
    }

    @Nullable
    private static String textOf(@Nonnull MenuElement e) {
        Component c = MenuElementComponentQuery.componentIn(e);
        if (c instanceof JMenuItem) {
            return ((JMenuItem)c).getText();
        }
        return "-";
    }

    private JPopupMenuElementsAsTextQuery() {
    }
}

