/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;

final class JListItemPreconditions {
    @RunsInCurrentThread
    static void checkIndexInBounds(@Nonnull JList list, int index) {
        JListItemPreconditions.checkIndexInBounds(index, list.getModel().getSize());
    }

    @RunsInCurrentThread
    static void checkIndicesInBounds(@Nonnull JList list, int ... indices) {
        int itemCount = list.getModel().getSize();
        for (int index : indices) {
            JListItemPreconditions.checkIndexInBounds(index, itemCount);
        }
    }

    private static void checkIndexInBounds(int index, int itemCount) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        String format = "Item index (%d) should be between [0] and [%d] (inclusive)";
        String msg = String.format(format, index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    private JListItemPreconditions() {
    }
}

