/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.annotation.ThreadSafeAction;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.WindowDriver;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class FrameDriver
extends WindowDriver {
    public FrameDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void iconify(@Nonnull Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.iconifyInfo(frame));
        this.robot.waitForIdle();
        this.updateFrameExtendedState(frame, 1);
    }

    @RunsInEDT
    private static Point iconifyInfo(final @Nonnull Frame frame) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(frame);
                return WindowLikeContainers.iconifyButtonLocation(frame);
            }
        });
    }

    @RunsInEDT
    public void deiconify(@Nonnull Frame frame) {
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void normalize(@Nonnull Frame frame) {
        FrameDriver.checkInEdtEnabledAndShowing(frame);
        this.updateFrameExtendedState(frame, 0);
    }

    @RunsInEDT
    public void maximize(@Nonnull Frame frame) {
        this.moveMouseIgnoringAnyError(frame, FrameDriver.maximizeInfo(frame));
        if (!FrameDriver.supportsMaximize(ToolkitProvider.instance().defaultToolkit())) {
            throw ActionFailedException.actionFailure("Platform does not support maximizing frames");
        }
        this.updateFrameExtendedState(frame, 6);
    }

    @Nonnull
    @RunsInEDT
    private static Point maximizeInfo(final @Nonnull Frame frame) {
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            @Nullable
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(frame);
                return WindowLikeContainers.maximizeButtonLocation(frame);
            }
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @ThreadSafeAction
    private void updateFrameExtendedState(@Nonnull Frame frame, int state) {
        frame.setExtendedState(state);
    }

    private static boolean supportsMaximize(@Nonnull Toolkit toolkit) {
        return toolkit.isFrameStateSupported(6);
    }
}

