/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.fest.swing.cell.JTableCellWriter;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JTableCheckBoxEditorCellWriter;
import org.fest.swing.driver.JTableComboBoxEditorCellWriter;
import org.fest.swing.driver.JTableTextComponentEditorCellWriter;

public class BasicJTableCellWriter
extends AbstractJTableCellWriter {
    private final JTableCheckBoxEditorCellWriter checkBoxWriter;
    private final JTableComboBoxEditorCellWriter comboBoxWriter;
    private final JTableTextComponentEditorCellWriter textComponentWriter;

    public BasicJTableCellWriter(@Nonnull Robot robot) {
        super(robot);
        this.checkBoxWriter = new JTableCheckBoxEditorCellWriter(robot);
        this.comboBoxWriter = new JTableComboBoxEditorCellWriter(robot);
        this.textComponentWriter = new JTableTextComponentEditorCellWriter(robot);
    }

    @Override
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        this.cellWriterFor(table, row, column).enterValue(table, row, column, value);
    }

    @Override
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        this.cellWriterFor(table, row, column).startCellEditing(table, row, column);
    }

    @Override
    public void stopCellEditing(@Nonnull JTable table, int row, int column) {
        this.cellWriterFor(table, row, column).stopCellEditing(table, row, column);
    }

    @Override
    public void cancelCellEditing(@Nonnull JTable table, int row, int column) {
        this.cellWriterFor(table, row, column).cancelCellEditing(table, row, column);
    }

    @Nonnull
    private JTableCellWriter cellWriterFor(@Nonnull JTable table, int row, int column) {
        Component editor = this.editorForCell(table, row, column);
        if (editor instanceof JCheckBox) {
            return this.checkBoxWriter;
        }
        if (editor instanceof JComboBox) {
            return this.comboBoxWriter;
        }
        if (editor instanceof JTextComponent) {
            return this.textComponentWriter;
        }
        throw BasicJTableCellWriter.cannotFindOrActivateEditor(row, column);
    }
}

