/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

final class Actions {
    @Nonnull
    static Object findActionKey(@Nonnull String name, @Nonnull ActionMap actionMap) {
        Action action = actionMap.get(name);
        if (action != null) {
            return name;
        }
        Object[] allKeys = actionMap.allKeys();
        if (allKeys != null) {
            for (Object key : allKeys) {
                action = actionMap.get(key);
                if (!name.equals(action.getValue("Name"))) continue;
                return Preconditions.checkNotNull((Object)key);
            }
        }
        String message = String.format("The action '%s' is not available", name);
        if (allKeys != null && allKeys.length > 0) {
            message = Strings.concat((Object[])new Object[]{message, ", available actions:", Actions.formatAllActionKeys(allKeys)});
        }
        throw ActionFailedException.actionFailure(message);
    }

    @Nonnull
    private static List<String> formatAllActionKeys(@Nonnull Object[] keys) {
        ArrayList formattedKeys = Lists.newArrayList();
        for (Object key : keys) {
            String keyAsString = Actions.keyAsString(key);
            if (keyAsString == null) continue;
            formattedKeys.add(keyAsString);
        }
        Collections.sort(formattedKeys);
        return formattedKeys;
    }

    @Nullable
    private static String keyAsString(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (String)Strings.quote((Object)key);
        }
        return String.format("%s(%s)", key.toString(), key.getClass().getName());
    }

    private Actions() {
    }
}

