/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.ActionPanel;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.Centerizer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;

public class TabLabel
extends JPanel
implements Accessible {
    private static final Logger LOG = Logger.getInstance(TabLabel.class);
    protected final SimpleColoredComponent myLabel;
    private final LayeredIcon myIcon;
    private Icon myOverlayedIcon;
    private final TabInfo myInfo;
    protected ActionPanel myActionPanel;
    private boolean myCentered;
    private final Wrapper myLabelPlaceholder = new Wrapper(false);
    protected final JBTabsImpl myTabs;

    public TabLabel(JBTabsImpl tabs, final TabInfo info) {
        super(false);
        this.myTabs = tabs;
        this.myInfo = info;
        this.myLabel = this.createLabel(tabs);
        this.setFocusable(ScreenReader.isActive());
        this.setOpaque(false);
        this.setLayout(new MyTabLabelLayout());
        this.myLabelPlaceholder.setOpaque(false);
        this.myLabelPlaceholder.setFocusable(false);
        this.myLabel.setFocusable(false);
        this.add((Component)this.myLabelPlaceholder, "Center");
        this.setAlignmentToCenter(true);
        this.myIcon = new LayeredIcon(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e, (int)501)) {
                    return;
                }
                if (JBTabsImpl.isSelectionClick(e, false) && TabLabel.this.myInfo.isEnabled()) {
                    Component c;
                    TabInfo selectedInfo = TabLabel.this.myTabs.getSelectedInfo();
                    if (selectedInfo != TabLabel.this.myInfo) {
                        TabLabel.this.myInfo.setPreviousSelection(selectedInfo);
                    }
                    if ((c = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY())) instanceof InplaceButton) {
                        return;
                    }
                    TabLabel.this.myTabs.select(info, true);
                } else {
                    TabLabel.this.handlePopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TabLabel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TabLabel.this.myInfo.setPreviousSelection(null);
                TabLabel.this.handlePopup(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabLabel.this.setHovered(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabLabel.this.setHovered(false);
            }
        });
        if (this.isFocusable()) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int index;
                    if (e.getKeyCode() == 37) {
                        int index2 = TabLabel.this.myTabs.getIndexOf(TabLabel.this.myInfo);
                        if (index2 >= 0) {
                            e.consume();
                            TabInfo previous = TabLabel.this.myTabs.findEnabledBackward(index2, true);
                            if (previous != null) {
                                TabLabel.this.myTabs.select(previous, false).doWhenDone(() -> TabLabel.this.myTabs.getSelectedLabel().requestFocusInWindow());
                            }
                        }
                    } else if (e.getKeyCode() == 39 && (index = TabLabel.this.myTabs.getIndexOf(TabLabel.this.myInfo)) >= 0) {
                        e.consume();
                        TabInfo next = TabLabel.this.myTabs.findEnabledForward(index, true);
                        if (next != null) {
                            TabLabel.this.myTabs.select(next, false).doWhenDone(() -> TabLabel.this.myTabs.getSelectedLabel().requestFocusInWindow());
                        }
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    TabLabel.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TabLabel.this.repaint();
                }
            });
        }
    }

    private void setHovered(boolean value) {
        if (this.myTabs.isHoveredTab(this) == value) {
            return;
        }
        if (value) {
            this.myTabs.setHovered(this);
        } else {
            this.myTabs.unHover(this);
        }
    }

    @Override
    public boolean isFocusable() {
        if (this.myTabs.getSelectedLabel() != this) {
            return false;
        }
        return super.isFocusable();
    }

    private SimpleColoredComponent createLabel(JBTabsImpl tabs) {
        SimpleColoredComponent label = new SimpleColoredComponent(){

            @Override
            public Font getFont() {
                if (this.isFontSet() || !TabLabel.this.myTabs.useSmallLabels()) {
                    return super.getFont();
                }
                return UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            }

            @Override
            protected Color getActiveTextColor(Color attributesColor) {
                TabPainterAdapter painterAdapter = TabLabel.this.myTabs.getTabPainterAdapter();
                TabTheme theme = painterAdapter.getTabTheme();
                return TabLabel.this.myTabs.getSelectedInfo() == TabLabel.this.myInfo && (UIUtil.getLabelForeground().equals(attributesColor) || attributesColor == null) ? (TabLabel.this.myTabs.isActiveTabs(TabLabel.this.myInfo) ? theme.getUnderlinedTabForeground() : theme.getUnderlinedTabInactiveForeground()) : super.getActiveTextColor(attributesColor);
            }
        };
        label.setOpaque(false);
        label.setBorder(null);
        label.setIconTextGap(tabs.isEditorTabs() ? (!UISettings.getShadowInstance().getHideTabsIfNeeded() ? 4 : 2) + 1 : new JLabel().getIconTextGap());
        label.setIconOpaque(false);
        label.setIpad((Insets)JBUI.emptyInsets());
        return label;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.myTabs.isEditorTabs() && UISettings.getShadowInstance().getShowCloseButton() && this.hasIcons()) {
            if (UISettings.getShadowInstance().getCloseTabButtonOnTheRight()) {
                insets.right -= JBUIScale.scale((int)4);
            } else {
                insets.left -= JBUIScale.scale((int)4);
            }
        }
        return insets;
    }

    public void setAlignmentToCenter(boolean toCenter) {
        if (this.myCentered == toCenter && this.getLabelComponent().getParent() != null) {
            return;
        }
        this.setPlaceholderContent(toCenter, this.getLabelComponent());
    }

    protected void setPlaceholderContent(boolean toCenter, JComponent component) {
        this.myLabelPlaceholder.removeAll();
        Centerizer content = toCenter ? new Centerizer(component, Centerizer.TYPE.BOTH) : new Centerizer(component, Centerizer.TYPE.VERTICAL);
        this.myLabelPlaceholder.setContent((JComponent)content);
        this.myCentered = toCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOffscreen(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        this.doPaint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.myTabs.isDropTarget(this.myInfo)) {
            return;
        }
        this.doPaint(g);
    }

    private void doPaint(Graphics g) {
        super.paint(g);
    }

    private void handlePopup(MouseEvent e) {
        JBTabsImpl tabs;
        if (e.getClickCount() != 1 || !e.isPopupTrigger()) {
            return;
        }
        if (e.getX() < 0 || e.getX() >= e.getComponent().getWidth() || e.getY() < 0 || e.getY() >= e.getComponent().getHeight()) {
            return;
        }
        String place = this.myTabs.getPopupPlace();
        place = place != null ? place : "unknown";
        this.myTabs.myPopupInfo = this.myInfo;
        DefaultActionGroup toShow = new DefaultActionGroup();
        if (this.myTabs.getPopupGroup() != null) {
            toShow.addAll(this.myTabs.getPopupGroup());
            toShow.addSeparator();
        }
        if ((tabs = (JBTabsImpl)JBTabsEx.NAVIGATION_ACTIONS_KEY.getData(DataManager.getInstance().getDataContext(e.getComponent(), e.getX(), e.getY()))) == this.myTabs && this.myTabs.myAddNavigationGroup) {
            toShow.addAll(this.myTabs.myNavigationActions);
        }
        if (toShow.getChildrenCount() == 0) {
            return;
        }
        this.myTabs.myActivePopup = ActionManager.getInstance().createActionPopupMenu(place, toShow).getComponent();
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs.myPopupListener);
        this.myTabs.myActivePopup.addPopupMenuListener(this.myTabs);
        this.myTabs.myActivePopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setText(SimpleColoredText text) {
        this.myLabel.change(() -> {
            this.myLabel.clear();
            this.myLabel.setIcon((Icon)(this.hasIcons() ? this.myIcon : null));
            if (text != null) {
                SimpleColoredText derive = this.myTabs.useBoldLabels() ? text.derive(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true) : text;
                derive.appendToComponent((ColoredTextContainer)this.myLabel);
            }
        }, false);
        this.invalidateIfNeeded();
    }

    private void invalidateIfNeeded() {
        if (this.getLabelComponent().getRootPane() == null) {
            return;
        }
        Dimension d = this.getLabelComponent().getSize();
        Dimension pref = this.getLabelComponent().getPreferredSize();
        if (d != null && d.equals(pref)) {
            return;
        }
        this.getLabelComponent().invalidate();
        if (this.myActionPanel != null) {
            this.myActionPanel.invalidate();
        }
        this.myTabs.revalidateAndRepaint(false);
    }

    public void setIcon(Icon icon) {
        this.setIcon(icon, 0);
    }

    private boolean hasIcons() {
        Icon[] layers;
        LayeredIcon layeredIcon = this.getLayeredIcon();
        boolean hasIcons = false;
        for (Icon layer1 : layers = layeredIcon.getAllLayers()) {
            if (layer1 == null) continue;
            hasIcons = true;
            break;
        }
        return hasIcons;
    }

    private void setIcon(@Nullable Icon icon, int layer) {
        LayeredIcon layeredIcon = this.getLayeredIcon();
        layeredIcon.setIcon(icon, layer);
        if (this.hasIcons()) {
            this.myLabel.setIcon((Icon)layeredIcon);
        } else {
            this.myLabel.setIcon(null);
        }
        this.invalidateIfNeeded();
    }

    private LayeredIcon getLayeredIcon() {
        return this.myIcon;
    }

    public TabInfo getInfo() {
        return this.myInfo;
    }

    public void apply(UiDecorator.UiDecoration decoration) {
        Insets current;
        Insets insets;
        if (decoration == null) {
            return;
        }
        if (decoration.getLabelFont() != null) {
            this.setFont(decoration.getLabelFont());
            this.getLabelComponent().setFont(decoration.getLabelFont());
        }
        if ((insets = decoration.getLabelInsets()) != null && (current = JBTabsImpl.ourDefaultDecorator.getDecoration().getLabelInsets()) != null) {
            this.setBorder(new EmptyBorder(TabLabel.getValue(current.top, insets.top), TabLabel.getValue(current.left, insets.left), TabLabel.getValue(current.bottom, insets.bottom), TabLabel.getValue(current.right, insets.right)));
        }
    }

    private static int getValue(int currentValue, int newValue) {
        return newValue != -1 ? newValue : currentValue;
    }

    public void setTabActions(ActionGroup group) {
        this.removeOldActionPanel();
        if (group == null) {
            return;
        }
        this.myActionPanel = new ActionPanel(this.myTabs, this.myInfo, e -> this.processMouseEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, this)), value -> this.setHovered((boolean)value));
        this.myActionPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)0));
        this.toggleShowActions(false);
        this.add((Component)this.myActionPanel, UISettings.getShadowInstance().getCloseTabButtonOnTheRight() ? "East" : "West");
        this.myTabs.revalidateAndRepaint(false);
    }

    private void removeOldActionPanel() {
        if (this.myActionPanel != null) {
            this.myActionPanel.getParent().remove(this.myActionPanel);
            this.myActionPanel = null;
        }
    }

    public boolean updateTabActions() {
        return this.myActionPanel != null && this.myActionPanel.update();
    }

    private void setAttractionIcon(@Nullable Icon icon) {
        if (this.myIcon.getIcon(0) == null) {
            this.setIcon(null, 1);
            this.myOverlayedIcon = icon;
        } else {
            this.setIcon(icon, 1);
            this.myOverlayedIcon = null;
        }
    }

    public boolean repaintAttraction() {
        if (!this.myTabs.myAttractions.contains(this.myInfo)) {
            if (this.getLayeredIcon().isLayerEnabled(1)) {
                this.getLayeredIcon().setLayerEnabled(1, false);
                this.setAttractionIcon(null);
                this.invalidateIfNeeded();
                return true;
            }
            return false;
        }
        boolean needsUpdate = false;
        if (this.getLayeredIcon().getIcon(1) != this.myInfo.getAlertIcon()) {
            this.setAttractionIcon(this.myInfo.getAlertIcon());
            needsUpdate = true;
        }
        int maxInitialBlinkCount = 5;
        int maxRefireBlinkCount = maxInitialBlinkCount + 2;
        if (this.myInfo.getBlinkCount() < maxInitialBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            if (this.myInfo.getBlinkCount() == 0) {
                needsUpdate = true;
            }
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxInitialBlinkCount) {
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else if (this.myInfo.getBlinkCount() < maxRefireBlinkCount && this.myInfo.isAlertRequested()) {
            this.getLayeredIcon().setLayerEnabled(1, !this.getLayeredIcon().isLayerEnabled(1));
            this.myInfo.setBlinkCount(this.myInfo.getBlinkCount() + 1);
            if (this.myInfo.getBlinkCount() == maxRefireBlinkCount) {
                this.myInfo.setBlinkCount(maxInitialBlinkCount);
                this.myInfo.resetAlertRequest();
            }
            this.repaint();
        } else {
            needsUpdate = !this.getLayeredIcon().isLayerEnabled(1);
            this.getLayeredIcon().setLayerEnabled(1, true);
        }
        this.invalidateIfNeeded();
        return needsUpdate;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
    }

    private void paintBackground(Graphics g) {
        TabPainterAdapter painterAdapter = this.myTabs.getTabPainterAdapter();
        painterAdapter.paintBackground(this, g, this.myTabs);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.getLabelComponent().getParent() == null) {
            return;
        }
        Rectangle textBounds = SwingUtilities.convertRectangle(this.getLabelComponent().getParent(), this.getLabelComponent().getBounds(), this);
        if (this.isFocusOwner()) {
            g.setColor(UIUtil.getTreeSelectionBorderColor());
            UIUtil.drawDottedRectangle((Graphics)g, (int)textBounds.x, (int)textBounds.y, (int)(textBounds.x + textBounds.width - 1), (int)(textBounds.y + textBounds.height - 1));
        }
        if (this.myOverlayedIcon == null) {
            return;
        }
        if (this.getLayeredIcon().isLayerEnabled(1)) {
            int top = (this.getSize().height - this.myOverlayedIcon.getIconHeight()) / 2;
            this.myOverlayedIcon.paintIcon(this, g, textBounds.x - this.myOverlayedIcon.getIconWidth() / 2, top);
        }
    }

    public void setTabActionsAutoHide(boolean autoHide) {
        if (this.myActionPanel == null || this.myActionPanel.isAutoHide() == autoHide) {
            return;
        }
        this.myActionPanel.setAutoHide(autoHide);
    }

    public void toggleShowActions(boolean show) {
        if (this.myActionPanel != null) {
            this.myActionPanel.toggleShowActions(show);
        }
    }

    void updateActionLabelPosition() {
        if (this.myActionPanel != null) {
            if (!this.myActionPanel.isVisible()) {
                this.remove(this.myActionPanel);
            } else {
                this.add((Component)this.myActionPanel, UISettings.getShadowInstance().getCloseTabButtonOnTheRight() ? "East" : "West");
            }
        }
    }

    @Override
    public String toString() {
        return this.myInfo.getText();
    }

    public void setTabEnabled(boolean enabled) {
        this.getLabelComponent().setEnabled(enabled);
    }

    public JComponent getLabelComponent() {
        return this.myLabel;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTabLabel();
        }
        return this.accessibleContext;
    }

    private class MyTabLabelLayout
    extends BorderLayout {
        private MyTabLabelLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.checkConstraints(constraints);
            super.addLayoutComponent(comp, constraints);
        }

        private void checkConstraints(Object constraints) {
            if ("North".equals(constraints) || "South".equals(constraints)) {
                LOG.warn((Throwable)new IllegalArgumentException("constraints=" + constraints));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                boolean success = this.doCustomLayout(parent);
                if (!success) {
                    super.layoutContainer(parent);
                }
            }
        }

        private boolean doCustomLayout(Container parent) {
            if (TabLabel.this.myTabs != null && TabLabel.this.myTabs.ignoreTabLabelLimitedWidthWhenPaint() && parent.getWidth() < parent.getPreferredSize().width) {
                int spaceTop = parent.getInsets().top;
                int spaceLeft = parent.getInsets().left;
                int spaceBottom = parent.getHeight() - parent.getInsets().bottom;
                int spaceHeight = spaceBottom - spaceTop;
                int xOffset = spaceLeft;
                xOffset = this.layoutComponent(xOffset, this.getLayoutComponent("West"), spaceTop, spaceHeight);
                xOffset = this.layoutComponent(xOffset, this.getLayoutComponent("Center"), spaceTop, spaceHeight);
                this.layoutComponent(xOffset, this.getLayoutComponent("East"), spaceTop, spaceHeight);
                return true;
            }
            return false;
        }

        private int layoutComponent(int xOffset, Component component, int spaceTop, int spaceHeight) {
            if (component != null) {
                int prefWestWidth = component.getPreferredSize().width;
                this.setBoundsWithVAlign(component, xOffset, prefWestWidth, spaceTop, spaceHeight);
                xOffset += prefWestWidth + this.getHgap();
            }
            return xOffset;
        }

        private void setBoundsWithVAlign(Component component, int left, int width, int spaceTop, int spaceHeight) {
            if (component == null) {
                return;
            }
            int height = component.getPreferredSize().height;
            int top = spaceTop + (spaceHeight - height) / 2;
            component.setBounds(left, top, width, height);
        }
    }

    protected class AccessibleTabLabel
    extends JPanel.AccessibleJPanel {
        protected AccessibleTabLabel() {
            super(TabLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name == null && TabLabel.this.myLabel != null) {
                name = TabLabel.this.myLabel.getAccessibleContext().getAccessibleName();
            }
            return name;
        }

        @Override
        public String getAccessibleDescription() {
            String description = super.getAccessibleDescription();
            if (description == null && TabLabel.this.myLabel != null) {
                description = TabLabel.this.myLabel.getAccessibleContext().getAccessibleDescription();
            }
            return description;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }
    }
}

