/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefFileSchemeHandler;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class JBCefApp {
    private static JBCefApp INSTANCE;
    @NotNull
    private final CefApp myCefApp;
    @NotNull
    private final Disposable myDisposable = new Disposable(){

        public void dispose() {
            JBCefApp.this.myCefApp.dispose();
        }
    };
    private static final AtomicBoolean ourInitialized;
    private static final List<JBCefSchemeHandlerFactory> ourSchemeHandlerFactoryList;

    private JBCefApp() {
        CefApp.startup();
        CefAppConfig config = this.getCefAppConfig();
        config.mySettings.windowless_rendering_enabled = false;
        config.mySettings.log_severity = CefSettings.LogSeverity.LOGSEVERITY_ERROR;
        Color bg = JBColor.background();
        CefSettings cefSettings = config.mySettings;
        CefSettings cefSettings2 = config.mySettings;
        cefSettings2.getClass();
        cefSettings.background_color = new CefSettings.ColorType(cefSettings2, bg.getAlpha(), bg.getRed(), bg.getGreen(), bg.getBlue());
        if (ApplicationManager.getApplication().isInternal()) {
            config.mySettings.remote_debugging_port = Registry.intValue((String)"ide.browser.jcef.debug.port");
        }
        CefApp.addAppHandler((CefAppHandler)new MyCefAppHandler(config.myAppArgs));
        this.myCefApp = CefApp.getInstance((CefSettings)config.mySettings);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
    }

    @NotNull
    Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            JBCefApp.$$$reportNull$$$0(0);
        }
        return disposable;
    }

    @NotNull
    public static JBCefApp getInstance() {
        if (!JBCefApp.isEnabled()) {
            throw new IllegalStateException("JCEF is disabled");
        }
        if (!ourInitialized.getAndSet(true)) {
            if (SystemInfo.isMac) {
                INSTANCE = new JBCefAppMac();
            } else if (SystemInfo.isLinux) {
                INSTANCE = new JBCefAppLinux();
            } else if (SystemInfo.isWindows) {
                INSTANCE = new JBCefAppWindows();
            } else {
                throw new IllegalStateException("JCEF is initialized on unsupported platform");
            }
        }
        JBCefApp jBCefApp = INSTANCE;
        if (jBCefApp == null) {
            JBCefApp.$$$reportNull$$$0(1);
        }
        return jBCefApp;
    }

    @Deprecated
    public static boolean isEnabled() {
        return Registry.is((String)"ide.browser.jcef.enabled");
    }

    @NotNull
    protected abstract CefAppConfig getCefAppConfig();

    @NotNull
    public JBCefClient createClient() {
        return new JBCefClient(this.myCefApp.createClient());
    }

    public static void addCefSchemeHandlerFactory(@NotNull JBCefSchemeHandlerFactory factory) {
        if (factory == null) {
            JBCefApp.$$$reportNull$$$0(2);
        }
        if (ourInitialized.get()) {
            throw new IllegalStateException("JBCefApp has already been initialized!");
        }
        ourSchemeHandlerFactoryList.add(factory);
    }

    static {
        ourInitialized = new AtomicBoolean(false);
        ourSchemeHandlerFactoryList = Collections.synchronizedList(new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCefSchemeHandlerFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCefAppHandler
    extends CefAppHandlerAdapter {
        MyCefAppHandler(String @Nullable [] args) {
            super(args);
        }

        public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
            for (JBCefSchemeHandlerFactory f : ourSchemeHandlerFactoryList) {
                f.registerCustomScheme(registrar);
            }
        }

        public void onContextInitialized() {
            for (JBCefSchemeHandlerFactory f : ourSchemeHandlerFactoryList) {
                JBCefApp.getInstance().myCefApp.registerSchemeHandlerFactory(f.getSchemeName(), f.getDomainName(), (CefSchemeHandlerFactory)f);
            }
            ourSchemeHandlerFactoryList.clear();
            JBCefApp.getInstance().myCefApp.registerSchemeHandlerFactory("file", "", new CefSchemeHandlerFactory(){

                public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
                    return "file".equals(schemeName) ? new JBCefFileSchemeHandler(browser, frame) : null;
                }
            });
        }
    }

    public static interface JBCefSchemeHandlerFactory
    extends CefSchemeHandlerFactory {
        public void registerCustomScheme(@NotNull CefSchemeRegistrar var1);

        @NotNull
        public String getSchemeName();

        @NotNull
        public String getDomainName();
    }

    private static class JBCefAppLinux
    extends JBCefApp {
        private JBCefAppLinux() {
        }

        @Override
        @NotNull
        protected CefAppConfig getCefAppConfig() {
            String JCEF_PATH = System.getProperty("java.home") + "/lib";
            CefSettings settings = new CefSettings();
            settings.resources_dir_path = JCEF_PATH;
            settings.locales_dir_path = JCEF_PATH + "/locales";
            settings.browser_subprocess_path = JCEF_PATH + "/jcef_helper";
            return new CefAppConfig(settings, new String[]{"--force-device-scale-factor=" + JBUIScale.sysScale()});
        }
    }

    private static class JBCefAppWindows
    extends JBCefApp {
        private JBCefAppWindows() {
        }

        @Override
        @NotNull
        protected CefAppConfig getCefAppConfig() {
            String JCEF_PATH = System.getProperty("java.home") + "/bin";
            CefSettings settings = new CefSettings();
            settings.resources_dir_path = JCEF_PATH;
            settings.locales_dir_path = JCEF_PATH + "/locales";
            settings.browser_subprocess_path = JCEF_PATH + "/jcef_helper";
            return new CefAppConfig(settings, ArrayUtil.EMPTY_STRING_ARRAY);
        }
    }

    private static class JBCefAppMac
    extends JBCefApp {
        private JBCefAppMac() {
        }

        @Override
        @NotNull
        protected CefAppConfig getCefAppConfig() {
            String ALT_CEF_FRAMEWORK_DIR = System.getenv("ALT_CEF_FRAMEWORK_DIR");
            String ALT_CEF_BROWSER_SUBPROCESS = System.getenv("ALT_CEF_BROWSER_SUBPROCESS");
            if (ALT_CEF_FRAMEWORK_DIR == null || ALT_CEF_BROWSER_SUBPROCESS == null) {
                String CONTENTS_PATH = System.getProperty("java.home") + "/..";
                if (ALT_CEF_FRAMEWORK_DIR == null) {
                    ALT_CEF_FRAMEWORK_DIR = CONTENTS_PATH + "/Frameworks/Chromium Embedded Framework.framework";
                }
                if (ALT_CEF_BROWSER_SUBPROCESS == null) {
                    ALT_CEF_BROWSER_SUBPROCESS = CONTENTS_PATH + "/Helpers/jcef Helper.app/Contents/MacOS/jcef Helper";
                }
            }
            return new CefAppConfig(new CefSettings(), new String[]{"--framework-dir-path=" + JBCefAppMac.normalize(ALT_CEF_FRAMEWORK_DIR), "--browser-subprocess-path=" + JBCefAppMac.normalize(ALT_CEF_BROWSER_SUBPROCESS), "--disable-in-process-stack-traces"});
        }

        private static String normalize(String path2) {
            try {
                return new File(path2).getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CefAppConfig {
        @NotNull
        public final CefSettings mySettings;
        public final String @NotNull [] myAppArgs;

        public CefAppConfig(@NotNull CefSettings settings, String @NotNull [] appArgs) {
            if (settings == null) {
                CefAppConfig.$$$reportNull$$$0(0);
            }
            if (appArgs == null) {
                CefAppConfig.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myAppArgs = appArgs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "appArgs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/jcef/JBCefApp$CefAppConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

