/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.fields.valueEditors;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractValueEditor<T>
implements ValueEditor<T> {
    @NotNull
    private T myDefaultValue;
    @Nullable
    private String myValueName;
    private final List<ValueEditor.Listener<T>> myListeners;

    protected AbstractValueEditor(@Nullable String valueName, @NotNull T defaultValue) {
        if (defaultValue == null) {
            AbstractValueEditor.$$$reportNull$$$0(0);
        }
        this.myListeners = new ArrayList<ValueEditor.Listener<T>>();
        this.myDefaultValue = defaultValue;
        this.myValueName = valueName;
    }

    @Override
    @NotNull
    public T getValue() {
        Object t;
        try {
            t = this.parseValue(this.getValueText());
        }
        catch (InvalidDataException ex) {
            T t2 = this.getDefaultValue();
            if (t2 == null) {
                AbstractValueEditor.$$$reportNull$$$0(2);
            }
            return t2;
        }
        if (t == null) {
            AbstractValueEditor.$$$reportNull$$$0(1);
        }
        return t;
    }

    public void setValueName(@Nullable String valueName) {
        this.myValueName = valueName;
    }

    @Override
    @Nullable
    public String getValueName() {
        return this.myValueName;
    }

    @Override
    public void setValue(@NotNull T newValue) {
        if (newValue == null) {
            AbstractValueEditor.$$$reportNull$$$0(3);
        }
        if (!newValue.equals(this.getDefaultValue()) && !this.isValid(newValue)) {
            newValue = this.getDefaultValue();
        }
        this.setValueText(this.valueToString(newValue));
    }

    @Override
    public void validateContent() throws ConfigurationException {
        try {
            this.parseValue(this.getValueText());
        }
        catch (InvalidDataException ex) {
            String name = this.getValueName();
            throw new ConfigurationException((name != null ? name + " " : "") + ex.getMessage());
        }
    }

    @Override
    public void setDefaultValue(@NotNull T defaultValue) {
        if (defaultValue == null) {
            AbstractValueEditor.$$$reportNull$$$0(4);
        }
        this.myDefaultValue = defaultValue;
    }

    @Override
    @NotNull
    public T getDefaultValue() {
        T t = this.myDefaultValue;
        if (t == null) {
            AbstractValueEditor.$$$reportNull$$$0(5);
        }
        return t;
    }

    @Override
    public void addListener(@NotNull ValueEditor.Listener<T> editorListener) {
        if (editorListener == null) {
            AbstractValueEditor.$$$reportNull$$$0(6);
        }
        this.myListeners.add(editorListener);
    }

    public void fireValueChanged(@NotNull T newValue) {
        if (newValue == null) {
            AbstractValueEditor.$$$reportNull$$$0(7);
        }
        for (ValueEditor.Listener<T> listener2 : this.myListeners) {
            listener2.valueChanged(newValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/fields/valueEditors/AbstractValueEditor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/fields/valueEditors/AbstractValueEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fireValueChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

