/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowAllAffectedGenericAction
extends AnAction
implements DumbAware {
    private static final String ACTION_ID = "VcsHistory.ShowAllAffected";

    private ShowAllAffectedGenericAction() {
    }

    public static ShowAllAffectedGenericAction getInstance() {
        return (ShowAllAffectedGenericAction)ActionManager.getInstance().getAction(ACTION_ID);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (vcsKey == null) {
            return;
        }
        VcsFileRevision revision = e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        if (revision != null && revisionVirtualFile != null) {
            ShowAllAffectedGenericAction.showSubmittedFiles(project, revision.getRevisionNumber(), revisionVirtualFile, vcsKey, revision.getChangedRepositoryPath(), Boolean.TRUE.equals(isNonLocal));
        }
    }

    public static void showSubmittedFiles(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile2, @NotNull VcsKey vcsKey) {
        if (project == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(2);
        }
        if (virtualFile2 == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(3);
        }
        if (vcsKey == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(4);
        }
        ShowAllAffectedGenericAction.showSubmittedFiles(project, revision, virtualFile2, vcsKey, null, false);
    }

    public static void showSubmittedFiles(@NotNull Project project, @NotNull VcsRevisionNumber revision, @NotNull VirtualFile virtualFile2, @NotNull VcsKey vcsKey, @Nullable RepositoryLocation location, boolean isNonLocal) {
        if (project == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(5);
        }
        if (revision == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(6);
        }
        if (virtualFile2 == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(7);
        }
        if (vcsKey == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(8);
        }
        AbstractVcsHelper.getInstance(project).loadAndShowCommittedChangesDetails(project, revision, virtualFile2, vcsKey, location, isNonLocal);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(9);
        }
        Project project = e.getData(CommonDataKeys.PROJECT);
        VcsKey vcsKey = e.getData(VcsDataKeys.VCS);
        if (project == null || vcsKey == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Boolean isNonLocal = e.getData(VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION);
        VirtualFile revisionVirtualFile = e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        boolean enabled = e.getData(VcsDataKeys.VCS_FILE_REVISION) != null && revisionVirtualFile != null;
        enabled = enabled && (!Boolean.TRUE.equals(isNonLocal) || ShowAllAffectedGenericAction.canPresentNonLocal(project, vcsKey, revisionVirtualFile));
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean canPresentNonLocal(@NotNull Project project, @NotNull VcsKey key, @NotNull VirtualFile file) {
        AbstractVcs vcs;
        if (project == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(10);
        }
        if (key == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ShowAllAffectedGenericAction.$$$reportNull$$$0(12);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance(project).findVcsByName(key.getName())) == null) {
            return false;
        }
        CommittedChangesProvider provider = vcs.getCommittedChangesProvider();
        if (provider == null) {
            return false;
        }
        return provider.getForNonLocal(file) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/annotate/ShowAllAffectedGenericAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showSubmittedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "canPresentNonLocal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

