/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.MacMessages;
import com.intellij.util.ObjectUtils;
import java.awt.Window;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MessageDialogBuilder<T extends MessageDialogBuilder> {
    protected final String myMessage;
    protected final String myTitle;
    protected String myYesText;
    protected String myNoText;
    protected Project myProject;
    protected Icon myIcon;
    protected DialogWrapper.DoNotAskOption myDoNotAskOption;

    private MessageDialogBuilder(@NotNull String title, @NotNull String message) {
        if (title == null) {
            MessageDialogBuilder.$$$reportNull$$$0(0);
        }
        if (message == null) {
            MessageDialogBuilder.$$$reportNull$$$0(1);
        }
        this.myTitle = title;
        this.myMessage = message;
    }

    @NotNull
    public static YesNo yesNo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            MessageDialogBuilder.$$$reportNull$$$0(2);
        }
        if (message == null) {
            MessageDialogBuilder.$$$reportNull$$$0(3);
        }
        YesNo yesNo = (YesNo)new YesNo(title, message).icon(Messages.getQuestionIcon());
        if (yesNo == null) {
            MessageDialogBuilder.$$$reportNull$$$0(4);
        }
        return yesNo;
    }

    public static YesNoCancel yesNoCancel(@NotNull String title, @NotNull String message) {
        if (title == null) {
            MessageDialogBuilder.$$$reportNull$$$0(5);
        }
        if (message == null) {
            MessageDialogBuilder.$$$reportNull$$$0(6);
        }
        return (YesNoCancel)new YesNoCancel(title, message).icon(Messages.getQuestionIcon());
    }

    protected abstract T getThis();

    @NotNull
    public T project(@Nullable Project project) {
        this.myProject = project;
        T t = this.getThis();
        if (t == null) {
            MessageDialogBuilder.$$$reportNull$$$0(7);
        }
        return t;
    }

    public T icon(@Nullable Icon icon) {
        this.myIcon = icon;
        return this.getThis();
    }

    @NotNull
    public T doNotAsk(@NotNull DialogWrapper.DoNotAskOption doNotAskOption) {
        if (doNotAskOption == null) {
            MessageDialogBuilder.$$$reportNull$$$0(8);
        }
        this.myDoNotAskOption = doNotAskOption;
        T t = this.getThis();
        if (t == null) {
            MessageDialogBuilder.$$$reportNull$$$0(9);
        }
        return t;
    }

    public T yesText(@NotNull String yesText) {
        if (yesText == null) {
            MessageDialogBuilder.$$$reportNull$$$0(10);
        }
        this.myYesText = yesText;
        return this.getThis();
    }

    public T noText(@NotNull String noText) {
        if (noText == null) {
            MessageDialogBuilder.$$$reportNull$$$0(11);
        }
        this.myNoText = noText;
        return this.getThis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/MessageDialogBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doNotAskOption";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/MessageDialogBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "yesNo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "project";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doNotAsk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "yesNo";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "yesNoCancel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doNotAsk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "yesText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "noText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class YesNoCancel
    extends MessageDialogBuilder<YesNoCancel> {
        private String myCancelText;

        private YesNoCancel(@NotNull String title, @NotNull String message) {
            if (title == null) {
                YesNoCancel.$$$reportNull$$$0(0);
            }
            if (message == null) {
                YesNoCancel.$$$reportNull$$$0(1);
            }
            super(title, message);
        }

        public YesNoCancel cancelText(@NotNull String cancelText) {
            if (cancelText == null) {
                YesNoCancel.$$$reportNull$$$0(2);
            }
            this.myCancelText = cancelText;
            return this.getThis();
        }

        @Override
        protected YesNoCancel getThis() {
            return this;
        }

        @Messages.YesNoCancelResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.getYesButton());
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.getNoButton());
            String cancelText = (String)ObjectUtils.chooseNotNull((Object)this.myCancelText, (Object)Messages.getCancelButton());
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
                    return MacMessages.getInstance().showYesNoCancelDialog(this.myTitle, this.myMessage, yesText, noText, cancelText, window, this.myDoNotAskOption);
                }
            }
            catch (Exception window) {
                // empty catch block
            }
            String[] options = new String[]{yesText, noText, cancelText};
            int buttonNumber = Messages.showDialog(this.myProject, this.myMessage, this.myTitle, options, 0, this.myIcon, this.myDoNotAskOption);
            return buttonNumber == 0 ? 0 : (buttonNumber == 1 ? 1 : 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancelText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/ui/MessageDialogBuilder$YesNoCancel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cancelText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class YesNo
    extends MessageDialogBuilder<YesNo> {
        private YesNo(@NotNull String title, @NotNull String message) {
            if (title == null) {
                YesNo.$$$reportNull$$$0(0);
            }
            if (message == null) {
                YesNo.$$$reportNull$$$0(1);
            }
            super(title, message);
        }

        @Override
        protected YesNo getThis() {
            return this;
        }

        @Messages.YesNoResult
        public int show() {
            String yesText = (String)ObjectUtils.chooseNotNull((Object)this.myYesText, (Object)Messages.getYesButton());
            String noText = (String)ObjectUtils.chooseNotNull((Object)this.myNoText, (Object)Messages.getNoButton());
            try {
                if (Messages.canShowMacSheetPanel() && !Messages.isApplicationInUnitTestOrHeadless()) {
                    Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
                    return MacMessages.getInstance().showYesNoDialog(this.myTitle, this.myMessage, yesText, noText, window, this.myDoNotAskOption);
                }
            }
            catch (Exception window) {
                // empty catch block
            }
            String[] options = new String[]{yesText, noText};
            return Messages.showDialog(this.myProject, this.myMessage, this.myTitle, options, 0, this.myIcon, this.myDoNotAskOption) == 0 ? 0 : 1;
        }

        public boolean isYes() {
            return this.show() == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/ui/MessageDialogBuilder$YesNo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

