/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleBasedConfigurationOptions;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleBasedConfiguration<ConfigurationModule extends RunConfigurationModule, T>
extends LocatableConfigurationBase<T>
implements Cloneable,
ModuleRunConfiguration {
    private static final Logger LOG = Logger.getInstance(ModuleBasedConfiguration.class);
    protected static final String TO_CLONE_ELEMENT_NAME = "toClone";
    private final ConfigurationModule myModule;

    public ModuleBasedConfiguration(String name, @NotNull ConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(1);
        }
        super(((RunConfigurationModule)configurationModule).getProject(), factory, name);
        this.myModule = configurationModule;
        this.setInitialModuleName();
    }

    public ModuleBasedConfiguration(@NotNull ConfigurationModule configurationModule, @NotNull ConfigurationFactory factory) {
        if (configurationModule == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(3);
        }
        super(((RunConfigurationModule)configurationModule).getProject(), factory);
        this.myModule = configurationModule;
        this.setInitialModuleName();
    }

    private void setInitialModuleName() {
        this.syncModuleName();
        this.getOptions().resetModificationCount();
    }

    @Override
    @NotNull
    protected ModuleBasedConfigurationOptions getOptions() {
        ModuleBasedConfigurationOptions moduleBasedConfigurationOptions = (ModuleBasedConfigurationOptions)super.getOptions();
        if (moduleBasedConfigurationOptions == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(4);
        }
        return moduleBasedConfigurationOptions;
    }

    @Override
    @NotNull
    protected Class<? extends ModuleBasedConfigurationOptions> getDefaultOptionsClass() {
        return ModuleBasedConfigurationOptions.class;
    }

    public abstract Collection<Module> getValidModules();

    public ConfigurationModule getConfigurationModule() {
        return this.myModule;
    }

    @Transient
    public void setModule(Module module) {
        ((RunConfigurationModule)this.getConfigurationModule()).setModule(module);
    }

    public void setModuleName(@Nullable String moduleName) {
        ((RunConfigurationModule)this.getConfigurationModule()).setModuleName(moduleName);
    }

    protected void readModule(@NotNull Element element) {
        if (element == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(5);
        }
        ((RunConfigurationModule)this.getConfigurationModule()).readExternal(element);
    }

    @Deprecated
    protected void writeModule(@NotNull Element element) {
        if (element == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(6);
        }
        ((RunConfigurationModule)this.getConfigurationModule()).writeExternal(element);
    }

    public Collection<Module> getAllModules() {
        return Arrays.asList(ModuleManager.getInstance(this.getProject()).getModules());
    }

    @Deprecated
    protected ModuleBasedConfiguration createInstance() {
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)this.getFactory().createTemplateConfiguration(this.getProject());
        configuration.setName(this.getName());
        return configuration;
    }

    @Override
    @Nullable
    public final T getState() {
        this.syncModuleName();
        return super.getState();
    }

    @Override
    public void loadState(@NotNull T state) {
        if (state == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(7);
        }
        super.loadState(state);
        ((RunConfigurationModule)this.myModule).setModuleName(this.getOptions().getModule());
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(8);
        }
        super.readExternal(element);
        ((RunConfigurationModule)this.myModule).setModuleName(this.getOptions().getModule());
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(9);
        }
        this.syncModuleName();
        super.writeExternal(element);
    }

    protected final void syncModuleName() {
        this.getOptions().setModule(((RunConfigurationModule)this.myModule).getModuleName());
    }

    @Override
    public ModuleBasedConfiguration clone() {
        Class stateClass;
        ModuleBasedConfiguration configuration = (ModuleBasedConfiguration)Objects.requireNonNull(this.getFactory()).createTemplateConfiguration(this.getProject());
        configuration.setName(this.getName());
        ConfigurationModule configurationModule = configuration.getConfigurationModule();
        String moduleName = StringUtil.nullize((String)((RunConfigurationModule)configurationModule).getModuleName());
        boolean isUseReadWriteExternal = true;
        if (this instanceof PersistentStateComponent && (stateClass = ComponentSerializationUtil.getStateClass(this.getClass())) != Element.class) {
            isUseReadWriteExternal = false;
            configuration.doCopyOptionsFrom(this);
        }
        if (isUseReadWriteExternal) {
            Element element = new Element(TO_CLONE_ELEMENT_NAME);
            try {
                this.writeExternal(element);
                configuration.readExternal(element);
                configuration.setAllowRunningInParallel(this.isAllowRunningInParallel());
            }
            catch (InvalidDataException | WriteExternalException e) {
                LOG.error(e);
                return null;
            }
        }
        if (moduleName != null && StringUtil.nullize((String)((RunConfigurationModule)configurationModule).getModuleName()) == null) {
            ((RunConfigurationModule)configurationModule).setModuleName(moduleName);
        }
        return configuration;
    }

    @Override
    public Module @NotNull [] getModules() {
        Module[] moduleArray;
        Module module = (Module)ReadAction.compute(() -> ((RunConfigurationModule)this.getConfigurationModule()).getModule());
        if (module == null) {
            moduleArray = Module.EMPTY_ARRAY;
        } else {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module;
        }
        if (moduleArray == null) {
            ModuleBasedConfiguration.$$$reportNull$$$0(10);
        }
        return moduleArray;
    }

    public void restoreOriginalModule(Module originalModule) {
        if (ModuleBasedConfiguration.canRestoreOriginalModule(originalModule, this.getModules())) {
            this.setModule(originalModule);
        }
    }

    public static boolean canRestoreOriginalModule(Module originalModule, Module[] configModules) {
        if (originalModule == null || configModules.length == 0) {
            return false;
        }
        ArrayDeque<Module> queue = new ArrayDeque<Module>();
        queue.addLast(originalModule);
        THashSet modules = new THashSet();
        while (!queue.isEmpty()) {
            Module module = (Module)queue.removeFirst();
            if (ArrayUtil.contains((Object)module, (Object[])configModules)) {
                return true;
            }
            for (Module next : ModuleRootManager.getInstance(module).getModuleDependencies(true)) {
                if (!modules.add(next)) continue;
                queue.addLast(next);
            }
        }
        return false;
    }

    @Override
    public void onNewConfigurationCreated() {
        ConfigurationModule configurationModule = this.getConfigurationModule();
        if (((RunConfigurationModule)configurationModule).getModule() == null) {
            Module[] modules = ModuleManager.getInstance(this.getProject()).getModules();
            ((RunConfigurationModule)configurationModule).setModule(modules.length == 1 ? modules[0] : null);
        }
    }

    public boolean isModuleDirMacroSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationModule";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/ModuleBasedConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/ModuleBasedConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

