/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.FieldAccessorFactory;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCodeStylePropertyMapper {
    @NotNull
    private final CodeStyleSettings myRootSettings;
    private final AtomicNotNullLazyValue<Map<String, CodeStylePropertyAccessor<?>>> myAccessorMap;

    public AbstractCodeStylePropertyMapper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(0);
        }
        this.myRootSettings = settings;
        this.myAccessorMap = AtomicNotNullLazyValue.createValue(() -> this.createMap());
    }

    public List<String> enumProperties() {
        return this.getAccessorMap().keySet().stream().sorted().collect(Collectors.toList());
    }

    private Map<String, CodeStylePropertyAccessor<?>> createMap() {
        HashMap accessorMap = new HashMap();
        for (CodeStyleObjectDescriptor descriptor : this.getSupportedFields()) {
            this.addAccessorsFor(accessorMap, descriptor.getCodeStyleObject(), descriptor.getSupportedFields());
        }
        this.addAdditionalAccessors(accessorMap);
        return accessorMap;
    }

    @NotNull
    protected abstract List<CodeStyleObjectDescriptor> getSupportedFields();

    protected void addAdditionalAccessors(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap) {
        if (accessorMap == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(1);
        }
    }

    private void addAccessorsFor(@NotNull Map<String, CodeStylePropertyAccessor<?>> accessorMap, @NotNull Object codeStyleObject, @Nullable Set<String> supportedFields) {
        if (accessorMap == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(2);
        }
        if (codeStyleObject == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(3);
        }
        Class<?> codeStyleClass = AbstractCodeStylePropertyMapper.getObjectStorageClass(codeStyleObject);
        for (Field field : this.getCodeStyleFields(codeStyleClass)) {
            CodeStylePropertyAccessor<?> accessor;
            String fieldName = field.getName();
            if (supportedFields != null && !supportedFields.contains(fieldName) || (accessor = this.getAccessor(codeStyleObject, field)) == null || accessor.isIgnorable()) continue;
            accessorMap.put(accessor.getPropertyName(), accessor);
        }
    }

    private static Class<?> getObjectStorageClass(@NotNull Object codeStyleObject) {
        Class<?> objectClass;
        if (codeStyleObject == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(4);
        }
        if (CodeStyleSettings.class.isAssignableFrom(objectClass = codeStyleObject.getClass())) {
            return CodeStyleSettings.class;
        }
        return objectClass;
    }

    @Nullable
    protected CodeStylePropertyAccessor<?> getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(5);
        }
        if (field == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(6);
        }
        return new FieldAccessorFactory(field).createAccessor(codeStyleObject);
    }

    private List<Field> getCodeStyleFields(Class<?> codeStyleClass) {
        Field[] allFields;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : allFields = this.useDeclaredFields() ? codeStyleClass.getDeclaredFields() : codeStyleClass.getFields()) {
            if (!AbstractCodeStylePropertyMapper.isPublic(field) || AbstractCodeStylePropertyMapper.isFinal(field)) continue;
            fields.add(field);
        }
        return fields;
    }

    private static boolean isPublic(Field field) {
        return (field.getModifiers() & 1) != 0;
    }

    private static boolean isFinal(Field field) {
        return (field.getModifiers() & 0x10) != 0;
    }

    @NotNull
    protected CodeStyleSettings getRootSettings() {
        CodeStyleSettings codeStyleSettings = this.myRootSettings;
        if (codeStyleSettings == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(7);
        }
        return codeStyleSettings;
    }

    @NotNull
    private Map<String, CodeStylePropertyAccessor<?>> getAccessorMap() {
        Map map = (Map)this.myAccessorMap.getValue();
        if (map == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(8);
        }
        return map;
    }

    public CodeStylePropertyAccessor<?> getAccessor(@NotNull String property) {
        if (property == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(9);
        }
        return (CodeStylePropertyAccessor)((Map)this.myAccessorMap.getValue()).get(property);
    }

    protected boolean useDeclaredFields() {
        return false;
    }

    @NotNull
    public abstract String getLanguageDomainId();

    @Deprecated
    public boolean containsProperty(@NotNull String name) {
        if (name == null) {
            AbstractCodeStylePropertyMapper.$$$reportNull$$$0(10);
        }
        return this.getAccessorMap().containsKey(name);
    }

    @Nullable
    public abstract String getPropertyDescription(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorMap";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalAccessors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAccessorsFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObjectStorageClass";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class CodeStyleObjectDescriptor {
        private final Object myObject;
        private final Set<String> mySupportedFields;

        public CodeStyleObjectDescriptor(@NotNull Object codeStyleObject, @Nullable Set<String> fields) {
            if (codeStyleObject == null) {
                CodeStyleObjectDescriptor.$$$reportNull$$$0(0);
            }
            this.myObject = codeStyleObject;
            this.mySupportedFields = fields;
        }

        @NotNull
        private Object getCodeStyleObject() {
            Object object = this.myObject;
            if (object == null) {
                CodeStyleObjectDescriptor.$$$reportNull$$$0(1);
            }
            return object;
        }

        @Nullable
        private Set<String> getSupportedFields() {
            return this.mySupportedFields;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeStyleObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper$CodeStyleObjectDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper$CodeStyleObjectDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeStyleObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

