/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.vcsUtil.AuthDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;

class HgCommandAuthenticator {
    private GetPasswordRunnable myGetPassword;
    private final boolean myForceAuthorization;
    private final boolean mySilentMode;

    HgCommandAuthenticator(boolean forceAuthorization, boolean silent) {
        this.myForceAuthorization = forceAuthorization;
        this.mySilentMode = silent;
    }

    public void forgetPassword() {
        if (this.myGetPassword == null) {
            return;
        }
        String url = VirtualFileManager.extractPath((String)this.myGetPassword.getURL());
        PasswordSafe.getInstance().set(HgCommandAuthenticator.createCredentialAttributes(url), null);
    }

    public boolean promptForAuthentication(Project project, @NotNull String proposedLogin, @NotNull String uri, @NotNull String path, @Nullable ModalityState state) {
        if (proposedLogin == null) {
            HgCommandAuthenticator.$$$reportNull$$$0(0);
        }
        if (uri == null) {
            HgCommandAuthenticator.$$$reportNull$$$0(1);
        }
        if (path == null) {
            HgCommandAuthenticator.$$$reportNull$$$0(2);
        }
        GetPasswordRunnable runnable = new GetPasswordRunnable(project, proposedLogin, uri, path, this.myForceAuthorization, this.mySilentMode);
        ApplicationManager.getApplication().invokeAndWait((Runnable)runnable, state == null ? ModalityState.defaultModalityState() : state);
        this.myGetPassword = runnable;
        return runnable.isOk();
    }

    public String getUserName() {
        return this.myGetPassword.getUserName();
    }

    public String getPassword() {
        return this.myGetPassword.getPassword();
    }

    @NotNull
    private static CredentialAttributes createCredentialAttributes(@NotNull String url) {
        if (url == null) {
            HgCommandAuthenticator.$$$reportNull$$$0(3);
        }
        return new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"HG", (String)url), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proposedLogin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/execution/HgCommandAuthenticator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "promptForAuthentication";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCredentialAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GetPasswordRunnable
    implements Runnable {
        private Credentials myCredentials;
        private final Project myProject;
        @NotNull
        private final String myProposedLogin;
        private boolean ok;
        @NotNull
        private final String myURL;
        private final boolean myForceAuthorization;
        private final boolean mySilent;

        GetPasswordRunnable(Project project, @NotNull String proposedLogin, @NotNull String uri, @NotNull String path, boolean forceAuthorization, boolean silent) {
            if (proposedLogin == null) {
                GetPasswordRunnable.$$$reportNull$$$0(0);
            }
            if (uri == null) {
                GetPasswordRunnable.$$$reportNull$$$0(1);
            }
            if (path == null) {
                GetPasswordRunnable.$$$reportNull$$$0(2);
            }
            this.ok = false;
            this.myProject = project;
            this.myProposedLogin = proposedLogin;
            this.myURL = uri + path;
            this.myForceAuthorization = forceAuthorization;
            this.mySilent = silent;
        }

        @Override
        public void run() {
            Credentials savedCredentials;
            String password;
            String login;
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            @NotNull HgGlobalSettings hgGlobalSettings = vcs.getGlobalSettings();
            @Nullable String rememberedLoginsForUrl = null;
            String url = VirtualFileManager.extractPath((String)this.myURL);
            if (!StringUtil.isEmptyOrSpaces((String)this.myURL)) {
                rememberedLoginsForUrl = hgGlobalSettings.getRememberedUserName(url);
            }
            if (StringUtil.isEmptyOrSpaces((String)(login = this.myProposedLogin))) {
                login = rememberedLoginsForUrl;
            }
            String string = password = (savedCredentials = PasswordSafe.getInstance().get(HgCommandAuthenticator.createCredentialAttributes(url))) == null ? null : savedCredentials.getPasswordAsString();
            if (savedCredentials != null && StringUtil.isEmptyOrSpaces((String)login)) {
                login = savedCredentials.getUserName();
            }
            if (!(this.myForceAuthorization || StringUtil.isEmptyOrSpaces((String)password) || StringUtil.isEmptyOrSpaces((String)login))) {
                this.myCredentials = new Credentials(login, password);
                this.ok = true;
                return;
            }
            if (this.mySilent) {
                this.ok = false;
                return;
            }
            AuthDialog dialog = new AuthDialog(this.myProject, HgBundle.message("hg4idea.dialog.login.password.required", new Object[0]), HgBundle.message("hg4idea.dialog.login.description", this.myURL), login, password, true);
            if (dialog.showAndGet()) {
                Credentials credentials;
                this.ok = true;
                this.myCredentials = credentials = new Credentials(dialog.getUsername(), dialog.getPassword());
                PasswordSafe.getInstance().set(HgCommandAuthenticator.createCredentialAttributes(url), credentials, !dialog.isRememberPassword());
                hgGlobalSettings.addRememberedUrl(url, credentials.getUserName());
            }
        }

        public String getUserName() {
            return this.myCredentials.getUserName();
        }

        public String getPassword() {
            return this.myCredentials == null ? null : this.myCredentials.getPasswordAsString();
        }

        public boolean isOk() {
            return this.ok;
        }

        @NotNull
        public String getURL() {
            String string = this.myURL;
            if (string == null) {
                GetPasswordRunnable.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proposedLogin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/execution/HgCommandAuthenticator$GetPasswordRunnable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

