/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.PluginInfoProvider;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.TimeoutCachedValue;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntProcedure;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0002\u001a\"\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u001c\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017\u001a\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0001\u001a\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0000\u001a(\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u0005\u001a\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"kilo", "", "mega", "pluginIdsFromOfficialJbPluginRepo", "Lcom/intellij/openapi/util/Getter;", "", "Lcom/intellij/openapi/extensions/PluginId;", "addAll", "", "result", "Lcom/intellij/util/containers/ObjectIntHashMap;", "", "usages", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "addPluginInfoTo", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "data", "", "", "getCountingStepName", "value", "steps", "", "getCountingUsage", "key", "getPluginInfoProvider", "Lcom/intellij/ide/plugins/PluginInfoProvider;", "humanize", "number", "isPluginFromOfficialJbPluginRepo", "", "pluginId", "isSafeToReportFrom", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "merge", "first", "second", "toUsageDescriptors", "intellij.platform.statistics"})
public final class StatisticsUtilKt {
    private static final int kilo = 1000;
    private static final int mega = 1000000;
    private static final Getter<Set<PluginId>> pluginIdsFromOfficialJbPluginRepo = (Getter)new TimeoutCachedValue(1L, TimeUnit.HOURS, (Supplier)pluginIdsFromOfficialJbPluginRepo.1.INSTANCE);

    public static final void addPluginInfoTo(@NotNull PluginInfo info, @NotNull Map<String, Object> data) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        data.put("plugin_type", info.getType().name());
        if (!info.getType().isSafeToReport()) {
            return;
        }
        String id = info.getId();
        CharSequence charSequence = id;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            data.put("plugin", id);
        }
        String version = info.getVersion();
        CharSequence charSequence2 = version;
        bl2 = false;
        boolean bl3 = false;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            data.put("plugin_version", version);
        }
    }

    @NotNull
    public static final String getCountingStepName(int value, @NotNull List<Integer> steps) {
        int stepIndex;
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        if (steps.isEmpty()) {
            return String.valueOf(value);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return "<" + ((Number)steps.get(0)).intValue();
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        return StatisticsUtilKt.humanize(step) + (addPlus ? "+" : "");
    }

    @NotNull
    public static final UsageDescriptor getCountingUsage(@NotNull String key, int value) {
        Object element$iv;
        block5: {
            List fixedSteps;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            if (value > 0xCCCCCCC) {
                return new UsageDescriptor(key + ".MANY", 1);
            }
            if (value < 0) {
                return new UsageDescriptor(key + ".<0", 1);
            }
            if (value < 3) {
                return new UsageDescriptor(key + '.' + value, 1);
            }
            List $this$last$iv = fixedSteps = CollectionsKt.listOf((Object[])new Integer[]{3, 5, 10, 15, 30, 50});
            boolean $i$f$last = false;
            ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it <= value)) continue;
                break block5;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        int step = ((Number)element$iv).intValue();
        while (value >= step * 2 && value >= (step *= 2) * 5) {
            step *= 5;
        }
        String stepName = StatisticsUtilKt.humanize(step);
        return new UsageDescriptor(key + '.' + stepName + '+', 1);
    }

    private static final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / 1000000;
        int k = number % 1000000 / 1000;
        int r = number % 1000;
        String ms = m > 0 ? "" + m + 'M' : "";
        String ks = k > 0 ? "" + k + 'K' : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return ms + ks + rs;
    }

    @NotNull
    public static final Set<UsageDescriptor> toUsageDescriptors(@NotNull ObjectIntHashMap<String> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        if (result.isEmpty()) {
            return SetsKt.emptySet();
        }
        THashSet descriptors = new THashSet(result.size());
        result.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(descriptors){
            final /* synthetic */ THashSet $descriptors;

            public final boolean execute(String key, int value) {
                this.$descriptors.add((Object)new UsageDescriptor(key, value));
                return true;
            }
            {
                this.$descriptors = tHashSet;
            }
        });
        return (Set)descriptors;
    }

    @NotNull
    public static final Set<UsageDescriptor> merge(@NotNull Set<UsageDescriptor> first, @NotNull Set<UsageDescriptor> second) {
        Intrinsics.checkParameterIsNotNull(first, (String)"first");
        Intrinsics.checkParameterIsNotNull(second, (String)"second");
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ObjectIntHashMap merged = new ObjectIntHashMap();
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, first);
        StatisticsUtilKt.addAll((ObjectIntHashMap<String>)merged, second);
        return StatisticsUtilKt.toUsageDescriptors((ObjectIntHashMap<String>)merged);
    }

    private static final void addAll(ObjectIntHashMap<String> result, Set<UsageDescriptor> usages) {
        for (UsageDescriptor usage : usages) {
            String key = usage.getKey();
            result.put((Object)key, result.get((Object)key, 0) + usage.getValue());
        }
    }

    @Nullable
    public static final PluginInfoProvider getPluginInfoProvider() {
        PluginInfoProvider pluginInfoProvider;
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Application application2 = application;
            boolean bl = false;
            boolean bl2 = false;
            Application it = application2;
            boolean bl3 = false;
            pluginInfoProvider = (PluginInfoProvider)ServiceManager.getService(PluginInfoProvider.class);
        } else {
            pluginInfoProvider = null;
        }
        return pluginInfoProvider;
    }

    public static final boolean isSafeToReportFrom(@NotNull PluginDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        if (PluginManager.getInstance().isDevelopedByJetBrains(descriptor)) {
            return true;
        }
        if (descriptor.isBundled()) {
            return false;
        }
        PluginId pluginId = descriptor.getPluginId();
        if (pluginId == null) {
            return false;
        }
        PluginId pluginId2 = pluginId;
        return StatisticsUtilKt.isPluginFromOfficialJbPluginRepo(pluginId2);
    }

    public static final boolean isPluginFromOfficialJbPluginRepo(@Nullable PluginId pluginId) {
        if (!ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) {
            return false;
        }
        Object object = pluginIdsFromOfficialJbPluginRepo.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pluginIdsFromOfficialJbPluginRepo.get()");
        return CollectionsKt.contains((Iterable)((Iterable)object), (Object)pluginId);
    }
}

