/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuildNumber;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogTestWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.WhiteListGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.BaseWhitelistStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistTestRulesStorageHolder;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhitelistTestGroupStorage
extends BaseWhitelistStorage {
    protected final ConcurrentMap<String, WhiteListGroupRules> eventsValidators;
    private final Object myLock;
    @NotNull
    private final EventLogTestWhitelistPersistence myTestWhitelistPersistence;
    @NotNull
    private final EventLogWhitelistPersistence myWhitelistPersistence;
    @NotNull
    private final String myRecorderId;

    WhitelistTestGroupStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = ContainerUtil.newConcurrentMap();
        this.myLock = new Object();
        this.myTestWhitelistPersistence = new EventLogTestWhitelistPersistence(recorderId);
        this.myWhitelistPersistence = new EventLogWhitelistPersistence(recorderId);
        this.updateValidators();
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public WhiteListGroupRules getGroupRules(@NotNull String groupId) {
        if (groupId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(1);
        }
        return (WhiteListGroupRules)this.eventsValidators.get(groupId);
    }

    @Override
    public void update() {
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValidators() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.isWhiteListInitialized.set(false);
            FUStatisticsWhiteListGroupsService.WLGroups productionGroups = EventLogTestWhitelistPersistence.loadTestWhitelist(this.myWhitelistPersistence);
            FUStatisticsWhiteListGroupsService.WLGroups testGroups = EventLogTestWhitelistPersistence.loadTestWhitelist(this.myTestWhitelistPersistence);
            Map<String, WhiteListGroupRules> result = this.createValidators(testGroups, productionGroups);
            this.eventsValidators.putAll(result);
            this.isWhiteListInitialized.set(true);
        }
    }

    @NotNull
    protected Map<String, WhiteListGroupRules> createValidators(@NotNull FUStatisticsWhiteListGroupsService.WLGroups groups, @NotNull FUStatisticsWhiteListGroupsService.WLGroups productionGroups) {
        if (groups == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(2);
        }
        if (productionGroups == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(3);
        }
        FUStatisticsWhiteListGroupsService.WLRule rules = WhitelistTestGroupStorage.merge(groups.rules, productionGroups.rules);
        EventLogBuildNumber buildNumber = EventLogBuildNumber.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
        Map<String, WhiteListGroupRules> map = groups.groups.stream().filter(group -> group.accepts(buildNumber)).collect(Collectors.toMap(group -> group.id, group -> WhitelistTestGroupStorage.createRules(group, rules)));
        if (map == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    private static FUStatisticsWhiteListGroupsService.WLRule merge(@Nullable FUStatisticsWhiteListGroupsService.WLRule testRules, @Nullable FUStatisticsWhiteListGroupsService.WLRule productionTestRules) {
        if (testRules == null) {
            return productionTestRules;
        }
        if (productionTestRules == null) {
            return testRules;
        }
        FUStatisticsWhiteListGroupsService.WLRule rule = new FUStatisticsWhiteListGroupsService.WLRule();
        WhitelistTestGroupStorage.copyRules(rule, productionTestRules);
        WhitelistTestGroupStorage.copyRules(rule, testRules);
        return rule;
    }

    private static void copyRules(@NotNull FUStatisticsWhiteListGroupsService.WLRule to, @NotNull FUStatisticsWhiteListGroupsService.WLRule from) {
        if (to == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(5);
        }
        if (from == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(6);
        }
        if (to.enums == null) {
            to.enums = ContainerUtil.newHashMap();
        }
        if (to.regexps == null) {
            to.regexps = ContainerUtil.newHashMap();
        }
        if (from.enums != null) {
            to.enums.putAll(from.enums);
        }
        if (from.regexps != null) {
            to.regexps.putAll(from.regexps);
        }
    }

    public void addGroupWithCustomRules(@NotNull String groupId, @NotNull String rules) throws IOException {
        if (groupId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(7);
        }
        if (rules == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(8);
        }
        EventLogTestWhitelistPersistence.addGroupWithCustomRules(this.myRecorderId, groupId, rules);
        this.updateValidators();
    }

    public void addTestGroup(@NotNull String groupId) throws IOException {
        if (groupId == null) {
            WhitelistTestGroupStorage.$$$reportNull$$$0(9);
        }
        EventLogTestWhitelistPersistence.addTestGroup(this.myRecorderId, groupId);
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.myTestWhitelistPersistence.cleanup();
        }
    }

    public static void cleanupAll() {
        List<String> recorders = StatisticsEventLoggerKt.getEventLogProviders().stream().filter(provider -> provider.isRecordEnabled()).map(provider -> provider.getRecorderId()).collect(Collectors.toList());
        WhitelistTestGroupStorage.cleanupAll(recorders);
    }

    public static void cleanupAll(List<String> recorders) {
        for (String recorderId : recorders) {
            WhitelistTestGroupStorage testWhitelist = WhitelistTestGroupStorage.getTestStorage(recorderId);
            if (testWhitelist == null) continue;
            testWhitelist.cleanup();
        }
    }

    @Nullable
    public static WhitelistTestGroupStorage getTestStorage(String recorderId) {
        SensitiveDataValidator validator = SensitiveDataValidator.getIfInitialized(recorderId);
        WhitelistGroupRulesStorage storage = validator != null ? validator.getWhiteListStorage() : null;
        return storage instanceof WhitelistTestRulesStorageHolder ? ((WhitelistTestRulesStorageHolder)((Object)storage)).getTestGroupStorage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.myLock;
        synchronized (object) {
            return this.eventsValidators.size();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productionGroups";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/whitelist/WhitelistTestGroupStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/whitelist/WhitelistTestGroupStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGroupRules";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyRules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addGroupWithCustomRules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTestGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

