/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegexpWhiteListRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final NullableLazyValue<Pattern> myPattern;
    @Nullable
    private final String myRegexp;
    private static final List<String> ESCAPE_FROM = Arrays.asList("\\", "[", "]", "{", "}", "(", ")", "-", "^", "*", "+", "?", ".", "|", "$");
    private static final List<String> ESCAPE_TO = ContainerUtil.map(ESCAPE_FROM, s -> "\\" + s);

    public RegexpWhiteListRule(final @Nullable String regexp) {
        this.myPattern = regexp == null ? null : new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                try {
                    return Pattern.compile(regexp);
                }
                catch (Exception ignored) {
                    return null;
                }
            }
        };
        this.myRegexp = regexp;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Pattern pattern;
        if (data == null) {
            RegexpWhiteListRule.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RegexpWhiteListRule.$$$reportNull$$$0(1);
        }
        if ((pattern = (Pattern)this.myPattern.getValue()) == null) {
            ValidationResultType validationResultType = ValidationResultType.INCORRECT_RULE;
            if (validationResultType == null) {
                RegexpWhiteListRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }
        ValidationResultType validationResultType = pattern.matcher(StatisticsEventEscaper.escape((String)data)).matches() ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        if (validationResultType == null) {
            RegexpWhiteListRule.$$$reportNull$$$0(3);
        }
        return validationResultType;
    }

    @Override
    @NotNull
    public String asRegexp() {
        return this.myRegexp != null ? this.myRegexp : "<invalid>";
    }

    public String toString() {
        return "RegexpWhiteListRule: myRegexp=" + this.asRegexp();
    }

    public static String escapeText(@NotNull String text) {
        if (text == null) {
            RegexpWhiteListRule.$$$reportNull$$$0(4);
        }
        return StringUtil.replace((String)text, ESCAPE_FROM, ESCAPE_TO);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpWhiteListRule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/RegexpWhiteListRule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidate";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

