/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class PyDefinitionsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyClass(PyClass node) {
        ASTNode name_node = node.getNameNode();
        if (name_node != null) {
            this.addHighlightingAnnotation(name_node, PyHighlighter.PY_CLASS_DEFINITION);
        }
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        ASTNode name_node = node.getNameNode();
        if (name_node != null) {
            String name = node.getName();
            LanguageLevel languageLevel = LanguageLevel.forElement(node);
            if (PyNames.UNDERSCORED_ATTRIBUTES.contains((Object)name) || PyNames.getBuiltinMethods(languageLevel).containsKey((Object)name)) {
                PyClass cls = node.getContainingClass();
                if (PyUtil.isNewMethod(node)) {
                    boolean new_style_class = false;
                    try {
                        if (cls != null) {
                            new_style_class = cls.isNewStyleClass(null);
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    if (new_style_class) {
                        this.addHighlightingAnnotation(name_node, PyHighlighter.PY_PREDEFINED_DEFINITION);
                    }
                } else {
                    this.addHighlightingAnnotation(name_node, PyHighlighter.PY_PREDEFINED_DEFINITION);
                }
            } else {
                this.addHighlightingAnnotation(name_node, PyHighlighter.PY_FUNC_DEFINITION);
            }
        }
    }

    @Override
    public void visitPyDecoratorList(PyDecoratorList node) {
        PyDecorator[] decos;
        for (PyDecorator deco : decos = node.getDecorators()) {
            this.highlightDecorator(deco);
        }
    }

    private void highlightDecorator(@NotNull PyDecorator node) {
        PsiElement atSign;
        if (node == null) {
            PyDefinitionsAnnotator.$$$reportNull$$$0(0);
        }
        if ((atSign = node.getFirstChild()) != null) {
            this.addHighlightingAnnotation(atSign, PyHighlighter.PY_DECORATOR);
            PsiElement refExpression = PyPsiUtils.getNextNonWhitespaceSibling(atSign);
            if (refExpression != null) {
                this.addHighlightingAnnotation(refExpression, PyHighlighter.PY_DECORATOR);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/validation/PyDefinitionsAnnotator", "highlightDecorator"));
    }
}

