/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.pipenv.PyPipEnvSdkAdditionalData;
import icons.PythonIcons;
import java.awt.Component;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final int MINUTE = 60000;
    @NonNls
    private static final String SKELETONS_TOPIC = "Skeletons";
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    private static final Pattern CUSTOM_PYTHON_SDK_HOME_PATH_PATTERN = Pattern.compile("[-a-zA-Z_0-9]{2,}:.*");
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static final OrderRootType BUILTIN_ROOT_TYPE = PythonSdkUtil.BUILTIN_ROOT_TYPE;

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonIcons.Python.Python;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.python";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = PythonFileType.INSTANCE.getIcon();
        if (icon == null) {
            PythonSdkType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    @NonNls
    public static String getBuiltinsFileName(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        String string = PyBuiltinCache.getBuiltinsFileName(PythonSdkType.getLanguageLevelForSdk(sdk));
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        Sdk[] existingSdks = ProjectJdkTable.getInstance().getAllJdks();
        List<PyDetectedSdk> sdks = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(existingSdks));
        PyDetectedSdk latest = StreamEx.of(sdks).findFirst().orElse(null);
        if (latest != null) {
            return latest.getHomePath();
        }
        return null;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return PythonSdkFlavor.getFlavor(path) != null;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        final boolean isWindows = SystemInfo.isWindows;
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !PythonSdkType.this.isValidSdkHome(files[0].getPath())) {
                    throw new Exception(PyBundle.message("sdk.error.invalid.interpreter.name.$0", files[0].getName()));
                }
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && isWindows) {
                    String path = file.getPath();
                    boolean looksExecutable = false;
                    for (String ext : PythonSdkUtil.WINDOWS_EXECUTABLE_SUFFIXES) {
                        if (!path.endsWith(ext)) continue;
                        looksExecutable = true;
                        break;
                    }
                    return looksExecutable && super.isFileVisible(file, showHiddenFiles);
                }
                return super.isFileVisible(file, showHiddenFiles);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (fileChooserDescriptor == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return fileChooserDescriptor;
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(6);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, Arrays.asList(sdkModel.getSdks()), sdk -> {
            if (sdk != null) {
                sdk.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk);
            }
        });
    }

    @Nullable
    public Sdk getVirtualEnvBaseSdk(Sdk sdk) {
        if (PythonSdkUtil.isVirtualEnv(sdk)) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            String version = this.getVersionString(sdk);
            if (flavor != null && version != null) {
                for (Sdk baseSdk : PythonSdkType.getAllSdks()) {
                    if (PythonSdkUtil.isRemote(baseSdk)) continue;
                    PythonSdkFlavor baseFlavor = PythonSdkFlavor.getFlavor(baseSdk);
                    if (PythonSdkUtil.isVirtualEnv(baseSdk) || !flavor.equals(baseFlavor) || !version.equals(this.getVersionString(baseSdk))) continue;
                    return baseSdk;
                }
            }
        }
        return null;
    }

    public static void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk) {
        Map<String, String> virtualEnv;
        if (commandLine == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        if (!(virtualEnv = PythonSdkType.activateVirtualEnv(sdk)).isEmpty()) {
            Map environment = commandLine.getEnvironment();
            for (Map.Entry<String, String> entry : virtualEnv.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (environment.containsKey(key)) {
                    if (!key.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar((String)environment.get(key), value, false);
                    continue;
                }
                environment.put(key, value);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, String sdkHome) {
        String name = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkUtil.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String path = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            String string = name + " virtualenv at " + path;
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + (Object)((Object)flavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(13);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(14);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        PythonRemoteInterpreterManager manager;
        String homePath;
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(17);
        }
        if ((homePath = currentSdk.getHomePath()) != null && PythonSdkType.isCustomPythonSdkHomePath(homePath) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
            return manager.loadRemoteSdkData(currentSdk, additional);
        }
        PyPipEnvSdkAdditionalData pipEnvData = PyPipEnvSdkAdditionalData.load(additional);
        if (pipEnvData != null) {
            return pipEnvData;
        }
        return PythonSdkAdditionalData.load(currentSdk, additional);
    }

    @Contract(pure=true)
    static boolean isCustomPythonSdkHomePath(@NotNull String homePath) {
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        return CUSTOM_PYTHON_SDK_HOME_PATH_PATTERN.matcher(homePath).matches();
    }

    public static boolean isSkeletonsPath(String path) {
        return path.contains("python_stubs");
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile sdkPath;
        String path;
        PythonSdkFlavor flavor;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(path = super.sdkPath(homePath))) != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkPath.getPath());
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)path);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        WeakReference ownerComponentRef;
        Component ownerComponent;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        Project project = (ownerComponent = (Component)SoftReference.dereference((Reference)(ownerComponentRef = (WeakReference)sdk.getUserData(SDK_CREATOR_COMPONENT_KEY)))) != null ? (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)) : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        PythonSdkUpdater.updateOrShowError(sdk, null, project, ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(24);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (e.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, event) -> {
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        VagrantNotStartedException cause = (VagrantNotStartedException)e.getCause();
                        manager.runVagrant(cause.getVagrantFolder(), cause.getMachineName());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = e.getMessage() + "\n<a href=\"#\">Launch vagrant and refresh skeletons</a>";
        } else if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notifications.Bus.notify((Notification)new Notification(SKELETONS_TOPIC, PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), notificationMessage, NotificationType.WARNING, notificationListener));
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path) {
        VirtualFile jar;
        String suffix;
        if (path == null) {
            PythonSdkType.$$$reportNull$$$0(25);
        }
        if ((suffix = path.getExtension()) != null) {
            suffix = StringUtil.toLowerCase((String)suffix);
        }
        if (!path.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(26);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        return virtualFile;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static String getSkeletonsPath(String basePath, String sdkHome) {
        String string = PythonSdkUtil.getSkeletonsPath(basePath, sdkHome);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static String getSkeletonsRootPath(String basePath) {
        String string = PythonSdkUtil.getSkeletonsRootPath(basePath);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static List<String> getSysPath(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(30);
        }
        String working_dir = new File(sdk.getHomePath()).getParent();
        Application application = ApplicationManager.getApplication();
        if (application != null && (!application.isUnitTestMode() || ApplicationInfoImpl.isInStressTest())) {
            return PythonSdkType.getSysPathsFromScript(sdk);
        }
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add(working_dir);
        ArrayList<String> arrayList = ret;
        if (arrayList == null) {
            PythonSdkType.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getSysPathsFromScript(@NotNull Sdk sdk) throws InvalidSdkException {
        String binaryPath;
        GeneralCommandLine cmd;
        ProcessOutput runResult;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(32);
        }
        if (!(runResult = PySdkUtil.getProcessOutput(cmd = PythonHelper.SYSPATH.newCommandLine(binaryPath = sdk.getHomePath(), (List<String>)Lists.newArrayList()), new File(binaryPath).getParent(), PythonSdkType.activateVirtualEnv(sdk), 60000)).checkSuccess(LOG)) {
            throw new InvalidSdkException(String.format("Failed to determine Python's sys.path value:\nSTDOUT: %s\nSTDERR: %s", runResult.getStdout(), runResult.getStderr()));
        }
        List list = runResult.getStdoutLines();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        return list;
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(34);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
            assert (data != null);
            String versionString = data.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                try {
                    versionString = PyRemoteInterpreterUtil.getInterpreterVersion(null, data, true);
                }
                catch (Exception e) {
                    LOG.warn("Couldn't get interpreter version:" + e.getMessage(), (Throwable)e);
                    versionString = "undefined";
                }
                data.setVersionString(versionString);
            }
            return versionString;
        }
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(@Nullable String sdkHome) {
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? flavor.getVersionString(sdkHome) : null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            PythonSdkType.$$$reportNull$$$0(35);
        }
        return type == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            return true;
        }
        VirtualFile homeDir = sdk.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isIncompleteRemote(Sdk sdk) {
        return PythonSdkUtil.isRemote(sdk) && !((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).isValid();
    }

    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        return (data = sdk.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase && ((PyRemoteSdkAdditionalDataBase)data).isRunAsRootViaSudo();
    }

    public static boolean hasInvalidRemoteCredentials(Sdk sdk) {
        if (PythonSdkUtil.isRemote(sdk)) {
            final Ref result = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    result.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase[0]));
            return (Boolean)result.get();
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static Sdk getSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(38);
        }
        return PythonSdkUtil.findPythonSdk(element);
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        String string = sdk.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        return !PythonSdkUtil.isRemote(sdk);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static Map<String, String> activateVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        Map<String, String> map2 = PySdkUtil.activateVirtualEnv(sdk);
        if (map2 == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        return map2;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static Map<String, String> activateVirtualEnv(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        Map<String, String> map2 = PySdkUtil.activateVirtualEnv(sdkHome);
        if (map2 == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        return map2;
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk(module);
        if (moduleSDK != null && !PythonSdkUtil.isRemote(moduleSDK) && PythonSdkFlavor.getFlavor(moduleSDK) instanceof CPythonSdkFlavor) {
            return moduleSDK;
        }
        for (Sdk sdk : ContainerUtil.sorted(PythonSdkType.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkUtil.isRemote(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk) {
        PythonSdkFlavor flavor;
        if (sdk != null && PythonSdkUtil.isPythonSdk(sdk) && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null) {
            LanguageLevel languageLevel = flavor.getLanguageLevel(sdk);
            if (languageLevel == null) {
                PythonSdkType.$$$reportNull$$$0(46);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(47);
        }
        return languageLevel;
    }

    @Nullable
    public static Sdk findPython2Sdk(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk(module);
        if (moduleSDK != null && PythonSdkType.getLanguageLevelForSdk(moduleSDK).isPython2()) {
            return moduleSDK;
        }
        return PythonSdkType.findPython2Sdk(PythonSdkType.getAllSdks());
    }

    @Nullable
    public static Sdk findPython2Sdk(@NotNull List<? extends Sdk> sdks) {
        if (sdks == null) {
            PythonSdkType.$$$reportNull$$$0(48);
        }
        for (Sdk sdk : ContainerUtil.sorted(sdks, (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (!PythonSdkType.getLanguageLevelForSdk(sdk).isPython2()) continue;
            return sdk;
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean hasValidSdk() {
        return PythonSdkUtil.hasValidSdk();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isInvalid(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(49);
        }
        return PythonSdkUtil.isInvalid(sdk);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isRemote(@Nullable Sdk sdk) {
        return PythonSdkUtil.isRemote(sdk);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isRemote(@Nullable String sdkPath) {
        return PythonSdkUtil.isRemote(sdkPath);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(50);
        }
        return PythonSdkUtil.isVirtualEnv(sdk);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isVirtualEnv(@Nullable String path) {
        return PythonSdkUtil.isVirtualEnv(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(51);
        }
        return PythonSdkUtil.isConda(sdk);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isConda(@Nullable String sdkPath) {
        return PythonSdkUtil.isConda(sdkPath);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isCondaVirtualEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PythonSdkType.$$$reportNull$$$0(52);
        }
        return PythonSdkUtil.isCondaVirtualEnv(sdk);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static File getVirtualEnvRoot(@NotNull String binaryPath) {
        if (binaryPath == null) {
            PythonSdkType.$$$reportNull$$$0(53);
        }
        return PythonSdkUtil.getVirtualEnvRoot(binaryPath);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static File findExecutableFile(File parent, String name) {
        return PythonSdkUtil.findExecutableFile(parent, name);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<Sdk> getAllSdks() {
        return PythonSdkUtil.getAllSdks();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static Sdk findPythonSdk(@Nullable Module module) {
        return PythonSdkUtil.findPythonSdk(module);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static Sdk findPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            PythonSdkType.$$$reportNull$$$0(54);
        }
        return PythonSdkUtil.findPythonSdk(element);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static Sdk findSdkByPath(@Nullable String path) {
        return PythonSdkUtil.findSdkByPath(path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static Sdk findSdkByPath(List<? extends Sdk> sdkList, @Nullable String path) {
        return PythonSdkUtil.findSdkByPath(sdkList, path);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static boolean isStdLib(@NotNull VirtualFile vFile, @Nullable Sdk pythonSdk2) {
        if (vFile == null) {
            PythonSdkType.$$$reportNull$$$0(55);
        }
        return PythonSdkUtil.isStdLib(vFile, pythonSdk2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static VirtualFile getSitePackagesDirectory(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(56);
        }
        return PythonSdkUtil.getSitePackagesDirectory(pythonSdk2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static List<Sdk> getAllLocalCPythons() {
        return PythonSdkUtil.getAllLocalCPythons();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static String getPythonExecutable(@NotNull String rootPath) {
        if (rootPath == null) {
            PythonSdkType.$$$reportNull$$$0(57);
        }
        return PythonSdkUtil.getPythonExecutable(rootPath);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static String getExecutablePath(@NotNull String homeDirectory, @NotNull String name) {
        if (homeDirectory == null) {
            PythonSdkType.$$$reportNull$$$0(58);
        }
        if (name == null) {
            PythonSdkType.$$$reportNull$$$0(59);
        }
        return PythonSdkUtil.getExecutablePath(homeDirectory, name);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    @Nullable
    public static Sdk findSdkByKey(@NotNull String key) {
        if (key == null) {
            PythonSdkType.$$$reportNull$$$0(60);
        }
        return PythonSdkUtil.findSdkByKey(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 1: 
            case 8: 
            case 22: 
            case 23: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinsFileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsRootPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysPathsFromScript";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 43: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "activateVirtualEnv";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinsFileName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPythonSdkHomePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSysPath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSysPathsFromScript";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSdk";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "activateVirtualEnv";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findPython2Sdk";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isInvalid";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualEnv";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVirtualEnv";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualEnvRoot";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdk";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isStdLib";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSitePackagesDirectory";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getPythonExecutable";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

