/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FieldsManager
extends MembersManager<PyTargetExpression> {
    private static final SimpleAssignmentsOnly SIMPLE_ASSIGNMENTS_ONLY = new SimpleAssignmentsOnly();
    private static final AssignmentTransform ASSIGNMENT_TRANSFORM = new AssignmentTransform();
    private final boolean myStatic;

    protected FieldsManager(boolean isStatic) {
        super(PyTargetExpression.class);
        this.myStatic = isStatic;
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            FieldsManager.$$$reportNull$$$0(0);
        }
        List<PyElement> list = Collections.emptyList();
        if (list == null) {
            FieldsManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            FieldsManager.$$$reportNull$$$0(2);
        }
        MyPyRecursiveElementVisitor visitor2 = new MyPyRecursiveElementVisitor();
        member.accept(visitor2);
        MultiMap<PyClass, PyElement> multiMap = visitor2.myResult;
        if (multiMap == null) {
            FieldsManager.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @Override
    protected Collection<? extends PyElement> getElementsToStoreReferences(@NotNull Collection<PyTargetExpression> elements) {
        if (elements == null) {
            FieldsManager.$$$reportNull$$$0(4);
        }
        return Collections2.transform(elements, (Function)ASSIGNMENT_TRANSFORM);
    }

    @Override
    @NotNull
    protected List<PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            FieldsManager.$$$reportNull$$$0(5);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(this.getFieldsByClass(pyClass), (Predicate)SIMPLE_ASSIGNMENTS_ONLY));
        if (arrayList == null) {
            FieldsManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyTargetExpression>> members, PyClass ... to) {
        if (from == null) {
            FieldsManager.$$$reportNull$$$0(7);
        }
        if (members == null) {
            FieldsManager.$$$reportNull$$$0(8);
        }
        if (to == null) {
            FieldsManager.$$$reportNull$$$0(9);
        }
        return this.moveAssignments(from, Collections2.filter((Collection)Collections2.transform(FieldsManager.fetchElements(members), (Function)ASSIGNMENT_TRANSFORM), NotNullPredicate.INSTANCE), to);
    }

    protected abstract Collection<PyElement> moveAssignments(@NotNull PyClass var1, @NotNull Collection<PyAssignmentStatement> var2, PyClass ... var3);

    protected abstract boolean classHasField(@NotNull PyClass var1, @NotNull String var2);

    @NotNull
    protected abstract Collection<PyTargetExpression> getFieldsByClass(@NotNull PyClass var1);

    @Override
    @NotNull
    public PyMemberInfo<PyTargetExpression> apply(@NotNull PyTargetExpression input) {
        if (input == null) {
            FieldsManager.$$$reportNull$$$0(10);
        }
        return new PyMemberInfo<PyTargetExpression>(input, this.myStatic, input.getText(), this.isOverrides(input), this, false);
    }

    @Nullable
    private Boolean isOverrides(@NotNull PyTargetExpression input) {
        if (input == null) {
            FieldsManager.$$$reportNull$$$0(11);
        }
        PyClass aClass = input.getContainingClass();
        String name = input.getName();
        if (name == null) {
            return null;
        }
        assert (aClass != null) : "Target expression declared outside of class:" + input;
        return this.classHasField(aClass, name) ? Boolean.valueOf(true) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToStoreReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isOverrides";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPyRecursiveElementVisitor
    extends PyRecursiveElementVisitorWithResult {
        private MyPyRecursiveElementVisitor() {
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyClass parent;
            PsiElement declaration = node.getReference().resolve();
            if (declaration instanceof PyElement && (parent = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)declaration, PyClass.class)) != null) {
                this.myResult.putValue((Object)parent, (Object)((PyElement)declaration));
            }
        }
    }

    private static class AssignmentTransform
    implements Function<PyTargetExpression, PyAssignmentStatement> {
        private AssignmentTransform() {
        }

        @Nullable
        public PyAssignmentStatement apply(@NotNull PyTargetExpression input) {
            if (input == null) {
                AssignmentTransform.$$$reportNull$$$0(0);
            }
            return (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)input, PyAssignmentStatement.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager$AssignmentTransform", "apply"));
        }
    }

    private static class SimpleAssignmentsOnly
    extends NotNullPredicate<PyTargetExpression> {
        private SimpleAssignmentsOnly() {
        }

        @Override
        public boolean applyNotNull(@NotNull PyTargetExpression input) {
            PsiElement parent;
            if (input == null) {
                SimpleAssignmentsOnly.$$$reportNull$$$0(0);
            }
            return (parent = input.getParent()) != null && PyAssignmentStatement.class.isAssignableFrom(parent.getClass());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/FieldsManager$SimpleAssignmentsOnly", "applyNotNull"));
        }
    }
}

