/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.classes.PyDependenciesComparator;
import org.jetbrains.annotations.NotNull;

public class PyPsiRefactoringUtil {
    public static <T extends PyElement> T addElementToStatementList(@NotNull T element, @NotNull PyStatementList statementList) {
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (statementList == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(1);
        }
        PyStatement before = null;
        PyStatement after = null;
        for (PyStatement statement : statementList.getStatements()) {
            if (PyDependenciesComparator.depends(element, statement)) {
                after = statement;
                continue;
            }
            if (!PyDependenciesComparator.depends(statement, element)) continue;
            before = statement;
        }
        PsiElement result = after != null ? statementList.addAfter((PsiElement)element, (PsiElement)after) : (before != null ? statementList.addBefore((PsiElement)element, (PsiElement)before) : PyPsiRefactoringUtil.addElementToStatementList(element, statementList, true));
        PyElement resultCasted = (PyElement)result;
        return (T)resultCasted;
    }

    @NotNull
    public static PsiElement addElementToStatementList(@NotNull PsiElement element, @NotNull PyStatementList statementList, boolean toTheBeginning) {
        PsiElement firstChild;
        PsiDocumentManager manager;
        Document document;
        PsiElement prevElem;
        if (element == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (statementList == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(3);
        }
        if ((prevElem = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)statementList)) != null && PyUtil.onSameLine((PsiElement)statementList, prevElem) && (document = (manager = PsiDocumentManager.getInstance((Project)statementList.getProject())).getDocument(statementList.getContainingFile())) != null) {
            PyStatementListContainer container = (PyStatementListContainer)statementList.getParent();
            manager.doPostponedOperationsAndUnblockDocument(document);
            String indentation = "\n" + PyIndentUtil.getElementIndent((PsiElement)statementList);
            String text2 = statementList.getStatements().length == 0 ? indentation + "pass" : indentation;
            document.insertString(statementList.getTextRange().getStartOffset(), (CharSequence)text2);
            manager.commitDocument(document);
            statementList = container.getStatementList();
        }
        if ((firstChild = statementList.getFirstChild()) == statementList.getLastChild() && firstChild instanceof PyPassStatement) {
            element = firstChild.replace(element);
        } else {
            PyStatement[] statements = statementList.getStatements();
            if (toTheBeginning && statements.length > 0) {
                PyExpression expression;
                PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)statementList, PyDocStringOwner.class);
                PyStatement anchor = statements[0];
                if (docStringOwner != null && anchor instanceof PyExpressionStatement && ((PyExpressionStatement)anchor).getExpression() == docStringOwner.getDocStringExpression()) {
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyPsiRefactoringUtil.$$$reportNull$$$0(4);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                while (anchor instanceof PyExpressionStatement && (expression = ((PyExpressionStatement)anchor).getExpression()) instanceof PyCallExpression) {
                    PyExpression callee = ((PyCallExpression)expression).getCallee();
                    if (!PyUtil.isSuperCall((PyCallExpression)expression) && (callee == null || !"__init__".equals(callee.getName()))) break;
                    PyStatement next = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)anchor, PyStatement.class);
                    if (next == null) {
                        PsiElement psiElement = statementList.addAfter(element, (PsiElement)anchor);
                        if (psiElement == null) {
                            PyPsiRefactoringUtil.$$$reportNull$$$0(5);
                        }
                        return psiElement;
                    }
                    anchor = next;
                }
                element = statementList.addBefore(element, (PsiElement)anchor);
            } else {
                element = statementList.add(element);
            }
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyPsiRefactoringUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyPsiRefactoringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyPsiRefactoringUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addElementToStatementList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElementToStatementList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

