/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DocStringFormat {
    PLAIN("Plain", ""),
    EPYTEXT("Epytext", "epytext"),
    REST("reStructuredText", "rest"),
    NUMPY("NumPy", "numpy"),
    GOOGLE("Google", "google");

    public static final List<String> ALL_NAMES;
    public static final List<String> ALL_NAMES_BUT_PLAIN;
    private final String myName;
    private final String myFormatterCommand;

    @NotNull
    private static List<String> getAllNames() {
        List<String> list = Collections.unmodifiableList(ContainerUtil.map((Object[])DocStringFormat.values(), format -> format.getName()));
        if (list == null) {
            DocStringFormat.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static List<String> getAllNamesButPlain() {
        List<String> list = Collections.unmodifiableList(ContainerUtil.mapNotNull((Object[])DocStringFormat.values(), format -> format == PLAIN ? null : format.getName()));
        if (list == null) {
            DocStringFormat.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static DocStringFormat fromName(@NotNull String name) {
        if (name == null) {
            DocStringFormat.$$$reportNull$$$0(2);
        }
        for (DocStringFormat format : DocStringFormat.values()) {
            if (!format.getName().equalsIgnoreCase(name)) continue;
            return format;
        }
        return null;
    }

    @NotNull
    public static DocStringFormat fromNameOrPlain(@NotNull String name) {
        if (name == null) {
            DocStringFormat.$$$reportNull$$$0(3);
        }
        DocStringFormat docStringFormat = (DocStringFormat)((Object)ObjectUtils.notNull((Object)((Object)DocStringFormat.fromName(name)), (Object)((Object)PLAIN)));
        if (docStringFormat == null) {
            DocStringFormat.$$$reportNull$$$0(4);
        }
        return docStringFormat;
    }

    private DocStringFormat(String name, String formatterCommand) {
        if (name == null) {
            DocStringFormat.$$$reportNull$$$0(5);
        }
        if (formatterCommand == null) {
            DocStringFormat.$$$reportNull$$$0(6);
        }
        this.myName = name;
        this.myFormatterCommand = formatterCommand;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DocStringFormat.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFormatterCommand() {
        String string = this.myFormatterCommand;
        if (string == null) {
            DocStringFormat.$$$reportNull$$$0(8);
        }
        return string;
    }

    static {
        ALL_NAMES = DocStringFormat.getAllNames();
        ALL_NAMES_BUT_PLAIN = DocStringFormat.getAllNamesButPlain();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringFormat";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNamesButPlain";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNameOrPlain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatterCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromNameOrPlain";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

