/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.runners.ConsoleTitleGen;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleDebugProcess;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PyConsoleRootType;
import com.jetbrains.python.console.PyConsoleType;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationServer;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreatorKt;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.console.actions.ShowVarsAction;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PythonSdkUtil;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PydevConsoleRunnerImpl
implements PydevConsoleRunner {
    @NonNls
    private static final String LOCALHOST = "localhost";
    @NonNls
    public static final String WORKING_DIR_AND_PYTHON_PATHS = "WORKING_DIR_AND_PYTHON_PATHS";
    @NonNls
    public static final String CONSOLE_START_COMMAND = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
    @NonNls
    public static final String STARTED_BY_RUNNER = "startedByRunner";
    private static final Logger LOG = Logger.getInstance(PydevConsoleRunnerImpl.class);
    @NonNls
    public static final String PYDEV_PYDEVCONSOLE_PY = "pydev/pydevconsole.py";
    public static final int PORTS_WAITING_TIMEOUT = 20000;
    private final Project myProject;
    private final String myTitle;
    @Nullable
    private final String myWorkingDir;
    private final Consumer<? super String> myRerunAction;
    @Nullable
    private final Sdk mySdk;
    private PydevConsoleCommunication myPydevConsoleCommunication;
    private PyConsoleProcessHandler myProcessHandler;
    protected PythonConsoleExecuteActionHandler myConsoleExecuteActionHandler;
    private final List<PydevConsoleRunner.ConsoleListener> myConsoleListeners;
    private final PyConsoleType myConsoleType;
    @NotNull
    private final Map<String, String> myEnvironmentVariables;
    @NotNull
    protected final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
    private final String[] myStatementsToExecute;
    private RemoteConsoleProcessData myRemoteConsoleProcessData;
    @Nullable
    private String myConsoleInitTitle;
    private PythonConsoleView myConsoleView;

    public PydevConsoleRunnerImpl(@NotNull Project project, @Nullable Sdk sdk, @NotNull PyConsoleType consoleType, @NotNull String title, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... statementsToExecute) {
        if (project == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(0);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(1);
        }
        if (title == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(2);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(4);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(5);
        }
        this.myConsoleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myConsoleInitTitle = null;
        this.myProject = project;
        this.mySdk = sdk;
        this.myTitle = title;
        this.myWorkingDir = workingDir;
        this.myConsoleType = consoleType;
        this.myEnvironmentVariables = environmentVariables;
        this.myConsoleSettings = settingsProvider;
        this.myStatementsToExecute = statementsToExecute;
        this.myRerunAction = rerunAction;
    }

    public PydevConsoleRunnerImpl(@NotNull Project project, @Nullable Sdk sdk, @NotNull PyConsoleType consoleType, @Nullable String workingDir, @NotNull Map<String, String> environmentVariables, @NotNull PyConsoleOptions.PyConsoleSettings settingsProvider, @NotNull Consumer<? super String> rerunAction, String ... statementsToExecute) {
        if (project == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(6);
        }
        if (consoleType == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(7);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(8);
        }
        if (settingsProvider == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(9);
        }
        if (rerunAction == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(10);
        }
        this(project, sdk, consoleType, consoleType.getTitle(), workingDir, environmentVariables, settingsProvider, rerunAction, statementsToExecute);
    }

    public void setConsoleTitle(String consoleTitle) {
        this.myConsoleInitTitle = consoleTitle;
    }

    private List<AnAction> fillRunActionsToolbar(DefaultActionGroup toolbarActions) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add(this.createRerunAction());
        actions.add(this.createStopAction());
        actions.add((AnAction)new ConsoleExecuteAction((LanguageConsoleView)this.myConsoleView, (ConsoleExecuteAction.ConsoleExecuteActionHandler)this.myConsoleExecuteActionHandler, this.myConsoleExecuteActionHandler.getEmptyExecuteAction(), (Condition)this.myConsoleExecuteActionHandler));
        toolbarActions.addAll(actions);
        toolbarActions.add((AnAction)new ConnectDebuggerAction());
        DefaultActionGroup settings = DefaultActionGroup.createPopupGroup(() -> PyBundle.message("pydev.console.runner.settings", new Object[0]));
        settings.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        settings.add((AnAction)new PyVariableViewSettings.VariablesPolicyGroup());
        toolbarActions.add((AnAction)settings);
        toolbarActions.add((AnAction)new NewConsoleAction());
        actions.add(PyConsoleUtil.createInterruptAction(this.myConsoleView));
        actions.add(PyConsoleUtil.createTabCompletionAction(this.myConsoleView));
        actions.add(this.createSplitLineAction());
        return actions;
    }

    private List<AnAction> fillOutputActionsToolbar(DefaultActionGroup toolbarActions) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new SoftWrapAction());
        actions.add(PyConsoleUtil.createScrollToEndAction(this.myConsoleView.getEditor()));
        actions.add(PyConsoleUtil.createPrintAction(this.myConsoleView));
        actions.add((AnAction)new ShowVarsAction(this.myConsoleView, this.myPydevConsoleCommunication));
        actions.add(ConsoleHistoryController.getController((LanguageConsoleView)this.myConsoleView).getBrowseHistory());
        toolbarActions.addAll(actions);
        return actions;
    }

    @Override
    public void open() {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(this.myProject);
        if (toolWindow != null && toolWindow.isInitialized()) {
            toolWindow.getToolWindow().activate(() -> {}, true);
        } else {
            this.runSync(true);
        }
    }

    @Override
    public void runSync(final boolean requestEditorFocus) {
        try {
            if (this.mySdk == null) {
                throw new ExecutionException(PyBundle.message("pydev.console.python.interpreter.is.not.selected", new Object[0]));
            }
            this.initAndRun(this.mySdk);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PyBundle.message("connecting.to.console.title", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setText(PyBundle.message("connecting.to.console.progress", new Object[0]));
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.myStatementsToExecute);
                    if (requestEditorFocus) {
                        PydevConsoleRunnerImpl.this.myConsoleView.requestFocus();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$1", "run"));
                }
            });
        }
        catch (ExecutionException e) {
            LOG.warn("Error running console", (Throwable)e);
            this.showErrorsInConsole((Exception)((Object)e));
        }
    }

    @Override
    public void run(final boolean requestEditorFocus) {
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> FileDocumentManager.getInstance().saveAllDocuments());
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PyBundle.message("connecting.to.console.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(PyBundle.message("connecting.to.console.progress", new Object[0]));
                try {
                    if (PydevConsoleRunnerImpl.this.mySdk == null) {
                        throw new ExecutionException(PyBundle.message("pydev.console.python.interpreter.is.not.selected", new Object[0]));
                    }
                    PydevConsoleRunnerImpl.this.initAndRun(PydevConsoleRunnerImpl.this.mySdk);
                    PydevConsoleRunnerImpl.this.connect(PydevConsoleRunnerImpl.this.myStatementsToExecute);
                    if (requestEditorFocus) {
                        PydevConsoleRunnerImpl.this.myConsoleView.requestFocus();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error running console", (Throwable)e);
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.showErrorsInConsole(e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$2", "run"));
            }
        }));
    }

    private void showErrorsInConsole(Exception e) {
        String[] messages;
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{this.createRerunAction()});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunnerErrors", (ActionGroup)actionGroup, false);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)actionToolbar.getComponent(), "West");
        NewErrorTreeViewPanel errorViewPanel = new NewErrorTreeViewPanel(this.myProject, null, false, false, null);
        String[] stringArray = messages = StringUtil.isNotEmpty((String)e.getMessage()) ? StringUtil.splitByLines((String)e.getMessage()) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (messages.length == 0) {
            messages = new String[]{PyBundle.message("pydev.console.runner.unknown.error", new Object[0])};
        }
        errorViewPanel.addMessage(4, messages, null, -1, -1, null);
        panel2.add((Component)errorViewPanel, "Center");
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, (ProcessHandler)this.myProcessHandler, (JComponent)panel2, PyBundle.message("pydev.console.runner.error.running.console", new Object[0]));
        this.showContentDescriptor(contentDescriptor);
    }

    protected void showContentDescriptor(RunContentDescriptor contentDescriptor) {
        ToolWindow toolwindow = PythonConsoleToolWindow.getToolWindow(this.myProject);
        if (toolwindow != null) {
            toolwindow.getComponent().putClientProperty(STARTED_BY_RUNNER, "true");
            PythonConsoleToolWindow.getInstance(this.myProject).init(toolwindow, contentDescriptor);
        } else {
            RunContentManager.getInstance((Project)this.myProject).showRunContent(PydevConsoleRunnerImpl.getExecutor(), contentDescriptor);
        }
    }

    private static Executor getExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    public static int findAvailablePort(@NotNull Project project, PyConsoleType consoleType) throws ExecutionException {
        if (project == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(11);
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            ExecutionHelper.showErrors((Project)project, Collections.singletonList(e), (String)consoleType.getTitle(), null);
            throw new ExecutionException((Throwable)e);
        }
    }

    protected GeneralCommandLine createCommandLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(12);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(13);
        }
        return this.doCreateConsoleCmdLine(sdk, environmentVariables, workingDir, port);
    }

    protected PythonConsoleRunParams createConsoleRunParams(@Nullable String workingDir, @NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(14);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(15);
        }
        return new PythonConsoleRunParams(this.myConsoleSettings, workingDir, sdk, environmentVariables);
    }

    @NotNull
    protected GeneralCommandLine doCreateConsoleCmdLine(@NotNull Sdk sdk, @NotNull Map<String, String> environmentVariables, @Nullable String workingDir, int port) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(16);
        }
        if (environmentVariables == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(17);
        }
        PythonConsoleRunParams runParams = this.createConsoleRunParams(workingDir, sdk, environmentVariables);
        GeneralCommandLine cmd = PythonCommandLineState.createPythonCommandLine(this.myProject, runParams, false, PtyCommandLine.isEnabled() && !SystemInfo.isWindows);
        cmd.withWorkDirectory(this.myWorkingDir);
        ParamsGroup exeGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        if (exeGroup != null && !runParams.getInterpreterOptions().isEmpty()) {
            exeGroup.addParametersString(runParams.getInterpreterOptions());
        }
        PydevConsoleCli.setupPythonConsoleScriptInClientMode(cmd, sdk, port);
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(18);
        }
        return generalCommandLine;
    }

    @NotNull
    private PythonConsoleView createConsoleView(@NotNull Sdk sdk) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(19);
        }
        PythonConsoleView consoleView = new PythonConsoleView(this.myProject, this.myTitle, sdk, false);
        this.myPydevConsoleCommunication.setConsoleFile(consoleView.getVirtualFile());
        consoleView.addMessageFilter(new PythonTracebackFilter(this.myProject));
        PythonConsoleView pythonConsoleView = consoleView;
        if (pythonConsoleView == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(20);
        }
        return pythonConsoleView;
    }

    @NotNull
    private CommandLineProcess createProcess(@NotNull Sdk sdk) throws ExecutionException {
        PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData;
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(21);
        }
        if ((remoteSdkAdditionalData = PydevConsoleRunnerImpl.getRemoteAdditionalData(sdk)) != null) {
            RemoteConsoleProcessData remoteConsoleProcessData;
            GeneralCommandLine generalCommandLine = this.createCommandLine(sdk, this.myEnvironmentVariables, this.myWorkingDir, 0);
            PyRemotePathMapper pathMapper = PydevConsoleRunner.getPathMapper(this.myProject, this.myConsoleSettings, remoteSdkAdditionalData);
            this.myRemoteConsoleProcessData = remoteConsoleProcessData = PythonConsoleRemoteProcessCreatorKt.createRemoteConsoleProcess(generalCommandLine, pathMapper, this.myProject, remoteSdkAdditionalData, this.getRunnerFileFromHelpers());
            this.myPydevConsoleCommunication = remoteConsoleProcessData.getPydevConsoleCommunication();
            return new CommandLineProcess(remoteConsoleProcessData.getProcess(), remoteConsoleProcessData.getCommandLine());
        }
        int port = PydevConsoleRunnerImpl.findAvailablePort(this.myProject, this.myConsoleType);
        GeneralCommandLine generalCommandLine = this.createCommandLine(sdk, this.myEnvironmentVariables, this.myWorkingDir, port);
        Map envs = generalCommandLine.getEnvironment();
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)generalCommandLine.getCharset());
        PydevConsoleCommunicationServer communicationServer = new PydevConsoleCommunicationServer(this.myProject, LOCALHOST, port);
        this.myPydevConsoleCommunication = communicationServer;
        try {
            communicationServer.serve();
        }
        catch (Exception e) {
            communicationServer.close();
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        Process process2 = generalCommandLine.createProcess();
        communicationServer.setPythonConsoleProcess(process2);
        return new CommandLineProcess(process2, generalCommandLine.getCommandLineString());
    }

    @Contract(value="null -> null")
    @Nullable
    private static PyRemoteSdkAdditionalDataBase getRemoteAdditionalData(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase) {
            return (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
        }
        return null;
    }

    protected String getRunnerFileFromHelpers() {
        return PYDEV_PYDEVCONSOLE_PY;
    }

    public static int getRemotePortFromProcess(@NotNull Process process2) throws ExecutionException {
        if (process2 == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(22);
        }
        Scanner s = new Scanner(process2.getInputStream());
        return PydevConsoleRunnerImpl.readInt(s, process2);
    }

    private static int readInt(Scanner s, Process process2) throws ExecutionException {
        long started = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() - started < 20000L) {
            String error;
            if (s.hasNextLine()) {
                String line2 = s.nextLine();
                sb.append(line2).append("\n");
                try {
                    int i = Integer.parseInt(line2);
                    if (flag) {
                        LOG.warn("Unexpected strings in output:\n" + sb.toString());
                    }
                    return i;
                }
                catch (NumberFormatException ignored) {
                    flag = true;
                    continue;
                }
            }
            TimeoutUtil.sleep((long)200L);
            if (process2.exitValue() == 0) break;
            try {
                error = PyBundle.message("pydev.console.console.process.terminated.with.error", StreamUtil.readText((InputStream)process2.getErrorStream()), sb.toString());
            }
            catch (Exception ignored) {
                error = PyBundle.message("pydev.console.console.process.terminated.with.exit.code", process2.exitValue(), sb.toString());
            }
            throw new ExecutionException(error);
        }
        throw new ExecutionException(PyBundle.message("pydev.console.couldnt.read.integer.value.from.stream", new Object[0]));
    }

    private PyConsoleProcessHandler createProcessHandler(Process process2, String commandLine, @NotNull Sdk sdk) {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(23);
        }
        if (PythonSdkUtil.isRemote(sdk)) {
            PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
            if (manager != null) {
                PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdk.getSdkAdditionalData();
                assert (data != null);
                this.myProcessHandler = manager.createConsoleProcessHandler(process2, this.myConsoleView, this.myPydevConsoleCommunication, commandLine, StandardCharsets.UTF_8, PythonRemoteInterpreterManager.appendBasicMappings(this.myProject, null, data), this.myRemoteConsoleProcessData.getSocketProvider());
            } else {
                LOG.error("Can't create remote console process handler");
            }
        } else {
            this.myProcessHandler = new PyConsoleProcessHandler(process2, this.myConsoleView, this.myPydevConsoleCommunication, commandLine, StandardCharsets.UTF_8);
        }
        return this.myProcessHandler;
    }

    private void initAndRun(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(24);
        }
        CommandLineProcess commandLineProcess = this.createProcess(sdk);
        Process process2 = commandLineProcess.getProcess();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myConsoleView = this.createConsoleView(sdk);
            this.myConsoleView.setBorder((Border)new SideBorder(JBColor.border(), 1));
            this.myPydevConsoleCommunication.setConsoleView(this.myConsoleView);
            this.myProcessHandler = this.createProcessHandler(process2, commandLineProcess.getCommandLine(), sdk);
            this.myConsoleExecuteActionHandler = this.createExecuteActionHandler();
            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
            final PythonConsoleView consoleView = this.myConsoleView;
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    consoleView.setEditable(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/console/PydevConsoleRunnerImpl$3", "processTerminated"));
                }
            });
            this.myConsoleView.attachToProcess((ProcessHandler)this.myProcessHandler);
            this.createContentDescriptorAndActions();
            this.myProcessHandler.startNotify();
        });
    }

    protected void createContentDescriptorAndActions() {
        DefaultActionGroup runToolbarActions = new DefaultActionGroup();
        ActionToolbar runActionsToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)runToolbarActions, false);
        DefaultActionGroup outputToolbarActions = new DefaultActionGroup();
        ActionToolbar outputActionsToolbar = ActionManager.getInstance().createActionToolbar("PydevConsoleRunner", (ActionGroup)outputToolbarActions, false);
        JPanel actionsPanel = new JPanel(new BorderLayout());
        actionsPanel.add((Component)runActionsToolbar.getComponent(), "West");
        JComponent outputActionsComponent = outputActionsToolbar.getComponent();
        int emptyBorderSize = outputActionsComponent.getBorder().getBorderInsets((Component)outputActionsComponent).left;
        outputActionsComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JBColor.border()), (Border)new JBEmptyBorder(emptyBorderSize)));
        actionsPanel.add((Component)outputActionsComponent, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)actionsPanel, "West");
        mainPanel.add((Component)this.myConsoleView.getComponent(), "Center");
        runActionsToolbar.setTargetComponent((JComponent)mainPanel);
        outputActionsToolbar.setTargetComponent((JComponent)mainPanel);
        if (this.myConsoleInitTitle == null) {
            this.myConsoleInitTitle = new ConsoleTitleGen(this.myProject, this.myTitle){

                @NotNull
                protected List<String> getActiveConsoles(@NotNull String consoleTitle) {
                    PythonConsoleToolWindow toolWindow;
                    if (consoleTitle == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((toolWindow = PythonConsoleToolWindow.getInstance(PydevConsoleRunnerImpl.this.myProject)) != null && toolWindow.isInitialized() && toolWindow.getToolWindow() != null) {
                        List<String> list = Lists.newArrayList((Object[])toolWindow.getToolWindow().getContentManager().getContents()).stream().map(c -> c.getDisplayName()).filter(s -> s.startsWith(PydevConsoleRunnerImpl.this.myTitle)).collect(Collectors.toList());
                        if (list == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return list;
                    }
                    List list = super.getActiveConsoles(consoleTitle);
                    if (list == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "consoleTitle";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$4";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActiveConsoles";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getActiveConsoles";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.makeTitle();
        }
        RunContentDescriptor contentDescriptor = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, (ProcessHandler)this.myProcessHandler, (JComponent)mainPanel, this.myConsoleInitTitle, null);
        Disposer.register((Disposable)this.myProject, (Disposable)contentDescriptor);
        contentDescriptor.setFocusComputable(() -> this.myConsoleView.getConsoleEditor().getContentComponent());
        contentDescriptor.setAutoFocusContent(true);
        List<AnAction> actions = this.fillRunActionsToolbar(runToolbarActions);
        List<AnAction> outputActions = this.fillOutputActionsToolbar(outputToolbarActions);
        actions.addAll(outputActions);
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, (JComponent)this.myConsoleView.getConsoleEditor().getComponent());
        AbstractConsoleRunnerWithHistory.registerActionShortcuts(actions, (JComponent)mainPanel);
        this.getConsoleView().addConsoleFolding(false, false);
        this.showContentDescriptor(contentDescriptor);
    }

    private void connect(String[] statements2execute) {
        if (this.handshake()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                final PythonConsoleView consoleView = this.myConsoleView;
                consoleView.setConsoleCommunication(this.myPydevConsoleCommunication);
                consoleView.setSdk(this.mySdk);
                consoleView.setExecutionHandler(this.myConsoleExecuteActionHandler);
                this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        consoleView.print(event.getText(), outputType);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$5";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                this.enableConsoleExecuteAction();
                if (statements2execute.length == 1 && statements2execute[0].isEmpty()) {
                    statements2execute[0] = "\t";
                }
                for (String statement : statements2execute) {
                    consoleView.executeStatement(statement + "\n", ProcessOutputTypes.SYSTEM);
                }
                this.fireConsoleInitializedEvent((LanguageConsoleView)consoleView);
                consoleView.initialized();
            });
        } else {
            this.myConsoleView.print(PyBundle.message("pydev.console.couldnt.connect.to.console.process", new Object[0]), ProcessOutputTypes.STDERR);
            this.myProcessHandler.destroyProcess();
            this.myConsoleView.setEditable(false);
        }
    }

    protected AnAction createRerunAction() {
        return new RestartAction(this, this.myConsoleInitTitle);
    }

    private void enableConsoleExecuteAction() {
        this.myConsoleExecuteActionHandler.setEnabled(true);
    }

    private boolean handshake() {
        return this.myPydevConsoleCommunication.handshake();
    }

    private AnAction createStopAction() {
        return new DumbAwareAction(PyBundle.messagePointer("action.DumbAware.PydevConsoleRunnerImpl.text.stop.console", new Object[0]), PyBundle.messagePointer("action.DumbAware.PydevConsoleRunnerImpl.description.stop.python.console", new Object[0]), AllIcons.Actions.Suspend){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!PydevConsoleRunnerImpl.this.isConsoleProcessTerminated());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                PydevConsoleRunnerImpl.this.stopConsole();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void stopConsole() {
        if (this.myPydevConsoleCommunication != null) {
            try {
                this.closeCommunication();
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected AnAction createSplitLineAction() {
        class ConsoleSplitLineAction
        extends EditorAction {
            private static final String CONSOLE_SPLIT_LINE_ACTION_ID = "Console.SplitLine";

            ConsoleSplitLineAction() {
                super((EditorActionHandler)new EditorWriteActionHandler(){
                    private final SplitLineAction mySplitLineAction = new SplitLineAction();

                    public boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext) {
                        if (editor2 == null) {
                            1ConsoleSplitLineAction.1.$$$reportNull$$$0(0);
                        }
                        if (caret == null) {
                            1ConsoleSplitLineAction.1.$$$reportNull$$$0(1);
                        }
                        return this.mySplitLineAction.getHandler().isEnabled(editor2, caret, dataContext);
                    }

                    public void executeWriteAction(Editor editor2, @Nullable Caret caret, DataContext dataContext) {
                        ((EditorWriteActionHandler)this.mySplitLineAction.getHandler()).executeWriteAction(editor2, caret, dataContext);
                        editor2.getCaretModel().getCurrentCaret().moveCaretRelatively(0, 1, false, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "caret";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$1ConsoleSplitLineAction$1";
                        objectArray[2] = "isEnabledForCaret";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public void setup() {
                EmptyAction.setupAction((AnAction)this, (String)CONSOLE_SPLIT_LINE_ACTION_ID, null);
            }
        }
        ConsoleSplitLineAction action = new ConsoleSplitLineAction();
        action.setup();
        return action;
    }

    private void closeCommunication() {
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myPydevConsoleCommunication.close();
        }
    }

    private boolean isConsoleProcessTerminated() {
        return this.myProcessHandler.isProcessTerminated();
    }

    @NotNull
    protected PythonConsoleExecuteActionHandler createExecuteActionHandler() {
        this.myConsoleExecuteActionHandler = new PydevConsoleExecuteActionHandler((LanguageConsoleView)this.myConsoleView, (ProcessHandler)this.myProcessHandler, this.myPydevConsoleCommunication);
        this.myConsoleExecuteActionHandler.setEnabled(false);
        new ConsoleHistoryController((ConsoleRootType)PyConsoleRootType.Companion.getInstance(), "", (LanguageConsoleView)this.myConsoleView).install();
        PythonConsoleExecuteActionHandler pythonConsoleExecuteActionHandler = this.myConsoleExecuteActionHandler;
        if (pythonConsoleExecuteActionHandler == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(25);
        }
        return pythonConsoleExecuteActionHandler;
    }

    @Override
    public PydevConsoleCommunication getPydevConsoleCommunication() {
        return this.myPydevConsoleCommunication;
    }

    static VirtualFile getConsoleFile(PsiFile psiFile) {
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        return file;
    }

    @Override
    public void addConsoleListener(PydevConsoleRunner.ConsoleListener consoleListener) {
        this.myConsoleListeners.add(consoleListener);
    }

    private void fireConsoleInitializedEvent(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(26);
        }
        for (PydevConsoleRunner.ConsoleListener listener2 : this.myConsoleListeners) {
            listener2.handleConsoleInitialized(consoleView);
        }
        this.myConsoleListeners.clear();
    }

    @Override
    public PythonConsoleExecuteActionHandler getConsoleExecuteActionHandler() {
        return this.myConsoleExecuteActionHandler;
    }

    @Nullable
    private static String getConsoleDisplayName(@NotNull Project project) {
        PythonConsoleToolWindow toolWindow;
        ToolWindow window;
        if (project == null) {
            PydevConsoleRunnerImpl.$$$reportNull$$$0(27);
        }
        if ((window = (toolWindow = PythonConsoleToolWindow.getInstance(project)).getToolWindow()) == null) {
            return null;
        }
        Content content2 = window.getContentManager().getSelectedContent();
        if (content2 == null) {
            return null;
        }
        return content2.getDisplayName();
    }

    private void rerun(final String displayName) {
        new Task.Backgroundable(this.myProject, PyBundle.message("console.restarting.console", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (PydevConsoleRunnerImpl.this.myProcessHandler != null) {
                    UIUtil.invokeAndWaitIfNeeded(() -> PydevConsoleRunnerImpl.this.closeCommunication());
                    boolean processStopped = PydevConsoleRunnerImpl.this.myProcessHandler.waitFor(5000L);
                    if (!processStopped && PydevConsoleRunnerImpl.this.myProcessHandler.canKillProcess()) {
                        PydevConsoleRunnerImpl.this.myProcessHandler.killProcess();
                    }
                    PydevConsoleRunnerImpl.this.myProcessHandler.waitFor();
                }
                GuiUtils.invokeLaterIfNeeded(() -> PydevConsoleRunnerImpl.this.myRerunAction.consume((Object)displayName), (ModalityState)ModalityState.defaultModalityState());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleRunnerImpl$7", "run"));
            }
        }.queue();
    }

    private XDebugSession connectToDebugger() throws ExecutionException {
        final ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        return XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(PyBundle.message("pydev.console.runner.python.console.debugger", new Object[0]), PythonIcons.Python.Python, null, true, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(final @NotNull XDebugSession session) {
                if (session == null) {
                    8.$$$reportNull$$$0(0);
                }
                PythonDebugLanguageConsoleView debugConsoleView = new PythonDebugLanguageConsoleView(PydevConsoleRunnerImpl.this.myProject, PydevConsoleRunnerImpl.this.mySdk);
                PyConsoleDebugProcessHandler consoleDebugProcessHandler = new PyConsoleDebugProcessHandler(PydevConsoleRunnerImpl.this.myProcessHandler);
                PyConsoleDebugProcess consoleDebugProcess = new PyConsoleDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, consoleDebugProcessHandler);
                PythonDebugConsoleCommunication communication = PyDebugRunner.initDebugConsoleView(PydevConsoleRunnerImpl.this.myProject, consoleDebugProcess, debugConsoleView, consoleDebugProcessHandler, session);
                communication.addCommunicationListener(new ConsoleCommunicationListener(){

                    @Override
                    public void commandExecuted(boolean more) {
                        session.rebuildViews();
                    }

                    @Override
                    public void inputRequested() {
                    }
                });
                PydevConsoleRunnerImpl.this.myPydevConsoleCommunication.setDebugCommunication(communication);
                debugConsoleView.attachToProcess(consoleDebugProcessHandler);
                consoleDebugProcess.waitForNextConnection();
                try {
                    consoleDebugProcess.connect(PydevConsoleRunnerImpl.this.myPydevConsoleCommunication);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                PydevConsoleRunnerImpl.this.myProcessHandler.notifyTextAvailable(PyBundle.message("pydev.console.debugger.connected", new Object[0]), ProcessOutputTypes.STDERR);
                PyConsoleDebugProcess pyConsoleDebugProcess = consoleDebugProcess;
                if (pyConsoleDebugProcess == null) {
                    8.$$$reportNull$$$0(1);
                }
                return pyConsoleDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Override
    public PyConsoleProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    public PythonConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    public static PythonConsoleRunnerFactory factory() {
        return new PydevConsoleRunnerFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVariables";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleCmdLine";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleView";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecuteActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAvailablePort";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunParams";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsoleCmdLine";
                break;
            }
            case 18: 
            case 20: 
            case 25: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePortFromProcess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initAndRun";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireConsoleInitializedEvent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PythonConsoleRunParams
    implements PythonRunParams {
        private final PyConsoleOptions.PyConsoleSettings myConsoleSettings;
        private final String myWorkingDir;
        private final Sdk mySdk;
        private final Map<String, String> myEnvironmentVariables;

        public PythonConsoleRunParams(@NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @Nullable String workingDir, @NotNull Sdk sdk, @NotNull Map<String, String> envs) {
            if (consoleSettings == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(1);
            }
            if (envs == null) {
                PythonConsoleRunParams.$$$reportNull$$$0(2);
            }
            this.myConsoleSettings = consoleSettings;
            this.myWorkingDir = workingDir;
            this.mySdk = sdk;
            this.myEnvironmentVariables = envs;
            this.myEnvironmentVariables.putAll(consoleSettings.getEnvs());
            PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
            if (debuggerSettings.getValuesPolicy() != PyDebugValue.ValuesPolicy.SYNC) {
                this.myEnvironmentVariables.put(PyDebugValue.POLICY_ENV_VARS.get((Object)debuggerSettings.getValuesPolicy()), "True");
            }
        }

        @Override
        public String getInterpreterOptions() {
            return this.myConsoleSettings.getInterpreterOptions();
        }

        @Override
        public void setInterpreterOptions(String interpreterOptions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkingDirectory() {
            return this.myWorkingDir;
        }

        @Override
        public void setWorkingDirectory(String workingDirectory) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getSdkHome() {
            return this.mySdk.getHomePath();
        }

        @Override
        public void setSdkHome(String sdkHome) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setModule(Module module) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModuleName() {
            return this.myConsoleSettings.getModuleName();
        }

        @Override
        public boolean isUseModuleSdk() {
            return this.myConsoleSettings.isUseModuleSdk();
        }

        @Override
        public void setUseModuleSdk(boolean useModuleSdk) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPassParentEnvs() {
            return this.myConsoleSettings.isPassParentEnvs();
        }

        @Override
        public void setPassParentEnvs(boolean passParentEnvs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getEnvs() {
            return this.myEnvironmentVariables;
        }

        @Override
        public void setEnvs(Map<String, String> envs) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PathMappingSettings getMappingSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldAddContentRoots() {
            return this.myConsoleSettings.shouldAddContentRoots();
        }

        @Override
        public boolean shouldAddSourceRoots() {
            return this.myConsoleSettings.shouldAddSourceRoots();
        }

        @Override
        public void setAddContentRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAddSourceRoots(boolean flag) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consoleSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envs";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$PythonConsoleRunParams";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewConsoleAction
    extends AnAction
    implements DumbAware {
        NewConsoleAction() {
            super(PyBundle.messagePointer("console.new.console", new Object[0]), PyBundle.messagePointer("console.new.console.description", new Object[0]), AllIcons.General.Add);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewConsoleAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                NewConsoleAction.$$$reportNull$$$0(1);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) != null) {
                PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(project, (Module)e.getData(LangDataKeys.MODULE));
                runner.run(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$NewConsoleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConnectDebuggerAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private XDebugSession mySession;

        ConnectDebuggerAction() {
            super(PyBundle.messagePointer("console.attach.debugger", new Object[0]), PyBundle.messagePointer("console.attach.debugger.description", new Object[0]), AllIcons.Actions.StartDebugger);
            this.mySelected = false;
            this.mySession = null;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(0);
            }
            return this.mySelected;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(1);
            }
            if (this.mySession != null) {
                e.getPresentation().setEnabled(false);
            } else {
                super.update(e);
                e.getPresentation().setEnabled(true);
            }
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                ConnectDebuggerAction.$$$reportNull$$$0(2);
            }
            this.mySelected = state2;
            if (this.mySelected) {
                try {
                    this.mySession = PydevConsoleRunnerImpl.this.connectToDebugger();
                }
                catch (Exception e1) {
                    LOG.error((Throwable)e1);
                    Messages.showErrorDialog((String)PyBundle.message("console.cannot.connect.to.debugger", new Object[0]), (String)PyBundle.message("console.error.connecting.debugger", new Object[0]));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$ConnectDebuggerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CommandLineProcess {
        @NotNull
        private final Process myProcess;
        @Nullable
        private final String myCommandLine;

        private CommandLineProcess(@NotNull Process process2, @Nullable String commandLine) {
            if (process2 == null) {
                CommandLineProcess.$$$reportNull$$$0(0);
            }
            this.myProcess = process2;
            this.myCommandLine = commandLine;
        }

        @NotNull
        public Process getProcess() {
            Process process2 = this.myProcess;
            if (process2 == null) {
                CommandLineProcess.$$$reportNull$$$0(1);
            }
            return process2;
        }

        @Nullable
        public String getCommandLine() {
            return this.myCommandLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$CommandLineProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$CommandLineProcess";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RestartAction
    extends AnAction {
        private final PydevConsoleRunnerImpl myConsoleRunner;
        private final String myInitTitle;

        private RestartAction(PydevConsoleRunnerImpl runner, String initTitle) {
            ActionUtil.copyFrom((AnAction)this, (String)"Rerun");
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Restart);
            this.myConsoleRunner = runner;
            this.myInitTitle = initTitle;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            if (e == null) {
                RestartAction.$$$reportNull$$$0(0);
            }
            String displayName = this.myInitTitle;
            Project project = e.getProject();
            if (project != null && !displayName.equals(name = PydevConsoleRunnerImpl.getConsoleDisplayName(project))) {
                displayName = name;
            }
            this.myConsoleRunner.rerun(displayName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/console/PydevConsoleRunnerImpl$RestartAction", "actionPerformed"));
        }
    }

    private class SoftWrapAction
    extends ToggleAction
    implements DumbAware {
        private boolean isSelected;

        SoftWrapAction() {
            super(ActionsBundle.actionText((String)"EditorToggleUseSoftWraps"), ActionsBundle.actionDescription((String)"EditorToggleUseSoftWraps"), AllIcons.Actions.ToggleSoftWrap);
            this.isSelected = PydevConsoleRunnerImpl.this.myConsoleSettings.isUseSoftWraps();
            this.updateEditors();
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SoftWrapAction.$$$reportNull$$$0(0);
            }
            return this.isSelected;
        }

        private void updateEditors() {
            PydevConsoleRunnerImpl.this.myConsoleView.getEditor().getSettings().setUseSoftWraps(this.isSelected);
            PydevConsoleRunnerImpl.this.myConsoleView.getConsoleEditor().getSettings().setUseSoftWraps(this.isSelected);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state2) {
            if (e == null) {
                SoftWrapAction.$$$reportNull$$$0(1);
            }
            this.isSelected = state2;
            this.updateEditors();
            PydevConsoleRunnerImpl.this.myConsoleSettings.setUseSoftWraps(this.isSelected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/console/PydevConsoleRunnerImpl$SoftWrapAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

