/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.regexp;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.regexp.PythonRegexpLanguage;
import com.jetbrains.python.codeInsight.regexp.PythonVerboseRegexpLanguage;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRegexpInjector
implements MultiHostInjector {
    private final List<RegexpMethodDescriptor> myDescriptors = new ArrayList<RegexpMethodDescriptor>();

    public PythonRegexpInjector() {
        this.addMethod("compile");
        this.addMethod("search");
        this.addMethod("match");
        this.addMethod("split");
        this.addMethod("findall");
        this.addMethod("finditer");
        this.addMethod("sub");
        this.addMethod("subn");
        this.addMethod("fullmatch");
    }

    private void addMethod(@NotNull String name) {
        if (name == null) {
            PythonRegexpInjector.$$$reportNull$$$0(0);
        }
        this.myDescriptors.add(new RegexpMethodDescriptor(name, 0));
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        RegexpMethodDescriptor methodDescriptor;
        PyCallExpression call;
        if (registrar == null) {
            PythonRegexpInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonRegexpInjector.$$$reportNull$$$0(2);
        }
        PyArgumentList argumentList = PyUtil.as(context.getParent(), PyArgumentList.class);
        if (PyInjectionUtil.getLargestStringLiteral(context) == context && argumentList != null && (call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PyCallExpression.class)) != null && (methodDescriptor = this.findRegexpMethodDescriptor(this.resolvePossibleRegexpCall(call))) != null && methodDescriptor.argIndex == ArrayUtil.indexOf((Object[])argumentList.getArguments(), (Object)context)) {
            PythonRegexpInjector.injectRegexpLanguage(registrar, context, PythonRegexpInjector.isVerbose(call));
        }
    }

    @Nullable
    private PsiElement resolvePossibleRegexpCall(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            PythonRegexpInjector.$$$reportNull$$$0(3);
        }
        if ((callee = call.getCallee()) instanceof PyReferenceExpression && this.canBeRegexpCall(callee)) {
            PyReferenceExpression referenceExpression = (PyReferenceExpression)callee;
            TypeEvalContext context = TypeEvalContext.codeAnalysis(call.getProject(), call.getContainingFile());
            return referenceExpression.getReference(PyResolveContext.defaultContext().withTypeEvalContext(context)).resolve();
        }
        return null;
    }

    private static void injectRegexpLanguage(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context, boolean verbose) {
        PsiFile file;
        Language language;
        PyInjectionUtil.InjectionResult result;
        if (registrar == null) {
            PythonRegexpInjector.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonRegexpInjector.$$$reportNull$$$0(5);
        }
        if ((result = PyInjectionUtil.registerStringLiteralInjection(context, registrar, language = verbose ? PythonVerboseRegexpLanguage.INSTANCE : PythonRegexpLanguage.INSTANCE)).isInjected() && !result.isStrict() && (file = InjectedLanguageUtil.getCachedInjectedFileWithLanguage((PsiElement)context, (Language)language)) != null) {
            file.putUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class);
        if (list == null) {
            PythonRegexpInjector.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isVerbose(@NotNull PyCallExpression call) {
        PyExpression[] arguments;
        if (call == null) {
            PythonRegexpInjector.$$$reportNull$$$0(7);
        }
        return (arguments = call.getArguments()).length > 1 && PythonRegexpInjector.isVerbose(arguments[arguments.length - 1]);
    }

    private static boolean isVerbose(@Nullable PyExpression expression) {
        if (expression instanceof PyKeywordArgument) {
            PyKeywordArgument keywordArgument = (PyKeywordArgument)expression;
            return "flags".equals(keywordArgument.getName()) && PythonRegexpInjector.isVerbose(keywordArgument.getValueExpression());
        }
        if (expression instanceof PyReferenceExpression) {
            String flagName = ((PyReferenceExpression)expression).getReferencedName();
            return "VERBOSE".equals(flagName) || "X".equals(flagName);
        }
        if (expression instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
            return PythonRegexpInjector.isVerbose(binaryExpression.getLeftExpression()) || PythonRegexpInjector.isVerbose(binaryExpression.getRightExpression());
        }
        return false;
    }

    @Nullable
    private RegexpMethodDescriptor findRegexpMethodDescriptor(@Nullable PsiElement element) {
        if (!(element != null && ScopeUtil.getScopeOwner(element) instanceof PyFile && ArrayUtil.contains((String)element.getContainingFile().getName(), (String[])new String[]{"re.py", "re.pyi"}) && element instanceof PyFunction)) {
            return null;
        }
        String functionName = ((PyFunction)element).getName();
        return this.myDescriptors.stream().filter(descriptor2 -> ((RegexpMethodDescriptor)descriptor2).methodName.equals(functionName)).findAny().orElse(null);
    }

    private boolean canBeRegexpCall(@NotNull PyExpression callee) {
        if (callee == null) {
            PythonRegexpInjector.$$$reportNull$$$0(8);
        }
        String text2 = callee.getText();
        return this.myDescriptors.stream().anyMatch(descriptor2 -> text2.endsWith(((RegexpMethodDescriptor)descriptor2).methodName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callee";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleRegexpCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "injectRegexpLanguage";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVerbose";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeRegexpCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RegexpMethodDescriptor {
        @NotNull
        private final String methodName;
        private final int argIndex;

        private RegexpMethodDescriptor(@NotNull String methodName, int argIndex) {
            if (methodName == null) {
                RegexpMethodDescriptor.$$$reportNull$$$0(0);
            }
            this.methodName = methodName;
            this.argIndex = argIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/jetbrains/python/codeInsight/regexp/PythonRegexpInjector$RegexpMethodDescriptor", "<init>"));
        }
    }
}

