/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyNegateComparisonIntention
extends PyBaseIntentionAction {
    private static final Map<PyElementType, String> comparisonStrings = new HashMap<PyElementType, String>(7);
    private static final Map<PyElementType, PyElementType> invertedComparasions = new HashMap<PyElementType, PyElementType>(7);

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.negate.comparison", new Object[0]);
        if (string == null) {
            PyNegateComparisonIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyNegateComparisonIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (comparisonStrings.containsKey((Object)operator)) {
                this.setText(PyBundle.message("INTN.negate.$0.to.$1", comparisonStrings.get((Object)operator), comparisonStrings.get((Object)invertedComparasions.get((Object)operator))));
                return true;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
        return false;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyNegateComparisonIntention.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(editor2.getCaretModel().getOffset());
        PyBinaryExpression binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class, (boolean)false);
        while (binaryExpression != null) {
            PyElementType operator = binaryExpression.getOperator();
            if (comparisonStrings.containsKey((Object)operator)) {
                PsiElement parent = binaryExpression.getParent();
                while (parent instanceof PyParenthesizedExpression) {
                    parent = parent.getParent();
                }
                PyElementType invertedOperator = invertedComparasions.get((Object)binaryExpression.getOperator());
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                PyBinaryExpression newElement = elementGenerator.createBinaryExpression(comparisonStrings.get((Object)invertedOperator), binaryExpression.getLeftExpression(), binaryExpression.getRightExpression());
                if (parent instanceof PyPrefixExpression && ((PyPrefixExpression)parent).getOperator() == PyTokenTypes.NOT_KEYWORD) {
                    parent.replace((PsiElement)newElement);
                } else {
                    LanguageLevel level = LanguageLevel.forElement((PsiElement)file);
                    binaryExpression.replace((PsiElement)elementGenerator.createExpressionFromText(level, "not " + newElement.getText()));
                }
                return;
            }
            binaryExpression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)binaryExpression, PyBinaryExpression.class);
        }
    }

    static {
        comparisonStrings.put(PyTokenTypes.LT, "<");
        comparisonStrings.put(PyTokenTypes.GT, ">");
        comparisonStrings.put(PyTokenTypes.EQEQ, "==");
        comparisonStrings.put(PyTokenTypes.LE, "<=");
        comparisonStrings.put(PyTokenTypes.GE, ">=");
        comparisonStrings.put(PyTokenTypes.NE, "!=");
        comparisonStrings.put(PyTokenTypes.NE_OLD, "<>");
        invertedComparasions.put(PyTokenTypes.LT, PyTokenTypes.GE);
        invertedComparasions.put(PyTokenTypes.GT, PyTokenTypes.LE);
        invertedComparasions.put(PyTokenTypes.EQEQ, PyTokenTypes.NE);
        invertedComparasions.put(PyTokenTypes.LE, PyTokenTypes.GT);
        invertedComparasions.put(PyTokenTypes.GE, PyTokenTypes.LT);
        invertedComparasions.put(PyTokenTypes.NE, PyTokenTypes.EQEQ);
        invertedComparasions.put(PyTokenTypes.NE_OLD, PyTokenTypes.EQEQ);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyNegateComparisonIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyNegateComparisonIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

