/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.codeInsight.imports.ImportChooser;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class PyImportChooser
implements ImportChooser {
    @Override
    public Promise<ImportCandidateHolder> selectImport(List<? extends ImportCandidateHolder> sources, String name, boolean useQualifiedImport, PsiElement target) {
        AsyncPromise result = new AsyncPromise();
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> JBPopupFactory.getInstance().createPopupChooserBuilder(sources).setRenderer((ListCellRenderer)new CellRenderer(name)).setTitle(useQualifiedImport ? PyPsiBundle.message("ACT.qualify.with.module", new Object[0]) : PyPsiBundle.message("ACT.from.some.module.import", new Object[0])).setItemChosenCallback(item -> result.setResult(item)).setNamerForFiltering(o -> o.getPresentableText(name)).createPopup().showInBestPositionFor(dataContext));
        return result;
    }

    private static class CellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer {
        private final Font FONT;
        private final String myName;

        CellRenderer(String name) {
            this.myName = name;
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.FONT = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize());
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            ImportCandidateHolder item = (ImportCandidateHolder)value;
            PsiElement importable = ((ImportCandidateHolder)value).getImportable();
            if (importable != null) {
                this.setIcon(importable.getIcon(0));
            }
            String item_name = item.getPresentableText(this.myName);
            this.append(item_name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setFont(this.FONT);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

