/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PythonDialectsTokenSetContributor;

public class PythonDialectsTokenSetProvider {
    public static PythonDialectsTokenSetProvider INSTANCE = new PythonDialectsTokenSetProvider();
    private final TokenSet myStatementTokens;
    private final TokenSet myExpressionTokens;
    private final TokenSet myKeywordTokens;
    private final TokenSet myParameterTokens;
    private final TokenSet myFunctionDeclarationTokens;
    private final TokenSet myUnbalancedBracesRecoveryTokens;
    private final TokenSet myReferenceExpressionTokens;

    private PythonDialectsTokenSetProvider() {
        TokenSet stmts = TokenSet.EMPTY;
        TokenSet exprs = TokenSet.EMPTY;
        TokenSet keywords = TokenSet.EMPTY;
        TokenSet parameters = TokenSet.EMPTY;
        TokenSet functionDeclarations = TokenSet.EMPTY;
        TokenSet recoveryTokens = TokenSet.EMPTY;
        TokenSet referenceExpressions = TokenSet.EMPTY;
        for (PythonDialectsTokenSetContributor contributor : PythonDialectsTokenSetContributor.EP_NAME.getExtensionList()) {
            stmts = TokenSet.orSet((TokenSet[])new TokenSet[]{stmts, contributor.getStatementTokens()});
            exprs = TokenSet.orSet((TokenSet[])new TokenSet[]{exprs, contributor.getExpressionTokens()});
            keywords = TokenSet.orSet((TokenSet[])new TokenSet[]{keywords, contributor.getKeywordTokens()});
            parameters = TokenSet.orSet((TokenSet[])new TokenSet[]{parameters, contributor.getParameterTokens()});
            functionDeclarations = TokenSet.orSet((TokenSet[])new TokenSet[]{functionDeclarations, contributor.getFunctionDeclarationTokens()});
            recoveryTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{recoveryTokens, contributor.getUnbalancedBracesRecoveryTokens()});
            referenceExpressions = TokenSet.orSet((TokenSet[])new TokenSet[]{referenceExpressions, contributor.getReferenceExpressionTokens()});
        }
        this.myStatementTokens = stmts;
        this.myExpressionTokens = exprs;
        this.myKeywordTokens = keywords;
        this.myParameterTokens = parameters;
        this.myFunctionDeclarationTokens = functionDeclarations;
        this.myUnbalancedBracesRecoveryTokens = recoveryTokens;
        this.myReferenceExpressionTokens = referenceExpressions;
    }

    public TokenSet getStatementTokens() {
        return this.myStatementTokens;
    }

    public TokenSet getExpressionTokens() {
        return this.myExpressionTokens;
    }

    public TokenSet getKeywordTokens() {
        return this.myKeywordTokens;
    }

    public TokenSet getParameterTokens() {
        return this.myParameterTokens;
    }

    public TokenSet getFunctionDeclarationTokens() {
        return this.myFunctionDeclarationTokens;
    }

    public TokenSet getUnbalancedBracesRecoveryTokens() {
        return this.myUnbalancedBracesRecoveryTokens;
    }

    public TokenSet getReferenceExpressionTokens() {
        return this.myReferenceExpressionTokens;
    }

    public static void reset() {
        INSTANCE = new PythonDialectsTokenSetProvider();
    }
}

