/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.mtc;

import edu.umd.cs.mtc.MultithreadedTest;
import edu.umd.cs.mtc.MultithreadedTestCase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestFramework {
    private static final boolean isJDK14 = System.getProperty("java.version").indexOf("1.4.") != -1;
    public static final String CLOCKPERIOD_KEY = "tunit.clockPeriod";
    public static final String RUNLIMIT_KEY = "tunit.runLimit";
    public static final Integer DEFAULT_CLOCKPERIOD = 10;
    public static final Integer DEFAULT_RUNLIMIT = 5;

    public static void setGlobalClockPeriod(Integer v) {
        if (v != null) {
            System.setProperty(CLOCKPERIOD_KEY, v.toString());
        }
    }

    public static void setGlobalRunLimit(Integer v) {
        if (v != null) {
            System.setProperty(RUNLIMIT_KEY, v.toString());
        }
    }

    public static void runInstrumentedManyTimes(MultithreadedTestCase test, int count, int[] failureCount) throws Throwable {
        int failures = 0;
        Throwable t = null;
        boolean failed = false;
        System.out.println("Testing " + ((Object)((Object)test)).getClass());
        int i = 0;
        while (i < count) {
            block9: {
                try {
                    TestFramework.runOnce(test);
                }
                catch (Throwable e) {
                    failed = true;
                    ++failures;
                    if (t != null) break block9;
                    t = e;
                }
            }
            if (i % 10 == 9) {
                if (failed) {
                    System.out.print("f");
                    failed = false;
                } else {
                    System.out.print(".");
                }
                if (i % 100 == 99) {
                    System.out.println(" " + (i + 1));
                }
            }
            ++i;
        }
        if (failureCount != null && failureCount.length > 0) {
            failureCount[0] = failures;
        }
        if (t != null) {
            throw t;
        }
    }

    public static void runManyTimes(MultithreadedTestCase test, int count) throws Throwable {
        TestFramework.runManyTimes(test, count, null, null);
    }

    public static void runManyTimes(MultithreadedTestCase test, int count, Integer clockPeriod, Integer runLimit) throws Throwable {
        int i = 0;
        while (i < count) {
            TestFramework.runOnce(test, clockPeriod, runLimit);
            ++i;
        }
    }

    public static void runOnce(MultithreadedTestCase test) throws Throwable {
        TestFramework.runOnce(test, null, null);
    }

    public static void runOnce(MultithreadedTestCase test, Integer clockPeriod, Integer runLimit) throws Throwable {
        if (clockPeriod == null) {
            clockPeriod = Integer.getInteger(CLOCKPERIOD_KEY, DEFAULT_CLOCKPERIOD);
        }
        if (runLimit == null) {
            runLimit = Integer.getInteger(RUNLIMIT_KEY, DEFAULT_RUNLIMIT);
        }
        Collection<Method> methods = TestFramework.getAllThreads(test);
        LinkedList<Thread> threads = new LinkedList<Thread>();
        Throwable[] error = new Throwable[1];
        test.initialize();
        test.clock = 0;
        ThreadGroup threadGroup = TestFramework.startMethodThreads(test, methods, threads, error);
        threads.add(TestFramework.startClock(test, threadGroup, error, clockPeriod, runLimit));
        TestFramework.waitForMethodThreads(threads, error);
        test.finish();
    }

    private static Collection<Method> getAllThreads(MultithreadedTestCase test) {
        Class<?> c = ((Object)((Object)test)).getClass();
        TreeMap<String, Method> result = new TreeMap<String, Method>();
        Method[] methodArray = c.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("thread") && m.getParameterTypes().length == 0 && m.getReturnType().equals(Void.TYPE)) {
                result.put(m.getName(), m);
            }
            ++n2;
        }
        return result.values();
    }

    private static Thread startClock(final MultithreadedTestCase test, final ThreadGroup threadGroup, final Throwable[] error, final int clockPeriod, final int runLimit) {
        final Thread mainThread = Thread.currentThread();
        Thread t = new Thread("Tick thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                try {
                    lastProgress = System.currentTimeMillis();
                    deadlocksDetected = 0;
                    readyToTick = 0;
                    block15: while (true) lbl-1000:
                    // 3 sources

                    {
                        Thread.sleep(clockPeriod);
                        if (!test.clockLock.writeLock().tryLock(1000L * (long)runLimit, TimeUnit.MILLISECONDS)) {
                            var5_5 = test.lock;
                            synchronized (var5_5) {
                                test.failed = true;
                                test.lock.notifyAll();
                                if (error[0] == null) {
                                    error[0] = new IllegalStateException("No progress");
                                }
                                mainThread.interrupt();
                                return;
                            }
                        }
                        var5_5 = test.lock;
                        synchronized (var5_5) {
                            block42: {
                                block44: {
                                    tgCount = threadGroup.activeCount() + 10;
                                    ths = new Thread[tgCount];
                                    tgCount = threadGroup.enumerate(ths, false);
                                    if (tgCount == 0) lbl-1000:
                                    // 3 sources

                                    {
                                        return;
                                    }
                                    checkProgress = false;
                                    timedWaiting = false;
                                    nextTick = 0x7FFFFFFF;
                                    ii = 0;
                                    while (ii < tgCount) {
                                        t = ths[ii];
                                        if (!TestFramework.access$0()) {
                                            try {
                                                if (test.getTrace()) {
                                                    System.out.println(String.valueOf(t.getName()) + " is in state " + (Object)t.getState());
                                                }
                                                if (t.getState() == Thread.State.RUNNABLE) {
                                                    checkProgress = true;
                                                }
                                                if (t.getState() == Thread.State.TIMED_WAITING) {
                                                    timedWaiting = true;
                                                }
                                            }
                                            catch (Throwable e) {
                                                checkProgress = false;
                                                timedWaiting = true;
                                            }
                                        } else {
                                            checkProgress = false;
                                            timedWaiting = true;
                                        }
                                        if ((waitingFor = test.threads.get(t)) != null && waitingFor > test.clock) {
                                            nextTick = Math.min(nextTick, waitingFor);
                                        }
                                        ++ii;
                                    }
                                    if (nextTick == 0x7FFFFFFF && timedWaiting) {
                                        checkProgress = true;
                                    }
                                    if (!checkProgress) ** break block43
                                    if (readyToTick > 0) {
                                        if (test.getTrace()) {
                                            System.out.println("Was Ready to tick too early");
                                        }
                                        readyToTick = 0;
                                    }
                                    if ((now = System.currentTimeMillis()) - lastProgress <= 1000L * (long)runLimit) break block44;
                                    test.failed = true;
                                    test.lock.notifyAll();
                                    if (error[0] == null) {
                                        error[0] = new IllegalStateException("No progress");
                                    }
                                    mainThread.interrupt();
                                    ** GOTO lbl-1000
                                }
                                deadlocksDetected = 0;
lbl72:
                                // 3 sources

                                ** do 
lbl-1000:
                                // 1 sources

                                {
                                    continue block15;
                                }
                                {
                                    block45: {
                                        block46: {
                                            if (nextTick != 0x7FFFFFFF) break block45;
                                            if (readyToTick > 0) {
                                                if (test.getTrace()) {
                                                    System.out.println("Was Ready to tick too early");
                                                }
                                                readyToTick = 0;
                                            }
                                            if (++deadlocksDetected >= 50) break block46;
                                            if (deadlocksDetected % 10 == 0 && test.getTrace()) {
                                                System.out.println("[Detecting deadlock... " + deadlocksDetected + " trys]");
                                            }
                                            ** GOTO lbl72
                                        }
                                        if (test.getTrace()) {
                                            System.out.println("Deadlock!");
                                        }
                                        sw = new StringWriter();
                                        out = new PrintWriter(sw);
                                        for (Map.Entry<Thread, Integer> e : test.threads.entrySet()) {
                                            t = e.getKey();
                                            out.println(String.valueOf(t.getName()) + " " + (Object)t.getState());
                                            var19_22 = t.getStackTrace();
                                            var18_21 = var19_22.length;
                                            var17_20 = 0;
                                            while (var17_20 < var18_21) {
                                                st = var19_22[var17_20];
                                                out.println("  " + st);
                                                ++var17_20;
                                            }
                                        }
                                        test.failed = true;
                                        if (error[0] == null) {
                                            error[0] = new IllegalStateException("Apparent deadlock\n" + sw.toString());
                                        }
                                        mainThread.interrupt();
                                        ** continue;
                                    }
                                    deadlocksDetected = 0;
                                    if (++readyToTick >= 2) ** break;
                                    ** continue;
                                    readyToTick = 0;
                                    test.clock = nextTick;
                                    lastProgress = System.currentTimeMillis();
                                    test.lock.notifyAll();
                                    if (test.getTrace()) {
                                        System.out.println("Time is now " + test.clock);
                                    }
                                    break block42;
                                }
                                finally {
                                    test.clockLock.writeLock().unlock();
                                }
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    if (test.getTrace()) {
                        System.out.println("Tick thread killed");
                    }
                    return;
                }
                {
                    ** while (true)
                }
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    private static void waitForMethodThreads(LinkedList<Thread> threads, Throwable[] error) throws Throwable {
        for (Thread t : threads) {
            try {
                if (t.isAlive() && error[0] != null) {
                    t.stop();
                    continue;
                }
                t.join();
            }
            catch (InterruptedException e1) {
                if (error[0] != null) {
                    throw error[0];
                }
                throw new AssertionError((Object)e1);
            }
        }
        if (error[0] != null) {
            throw error[0];
        }
    }

    private static ThreadGroup startMethodThreads(final MultithreadedTestCase test, Collection<Method> methods, final LinkedList<Thread> threads, final Throwable[] error) {
        ThreadGroup threadGroup = new ThreadGroup("MTC-Threads");
        final CountDownLatch latch = new CountDownLatch(methods.size());
        final Semaphore waitForRegistration = new Semaphore(0);
        for (final Method m : methods) {
            Runnable r = new Runnable(){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            String threadName = "thread " + m.getName().substring(6);
            Thread t = new Thread(threadGroup, r, threadName);
            threads.add(t);
            test.putThread(m.getName(), t);
            t.start();
            waitForRegistration.acquireUninterruptibly();
        }
        return threadGroup;
    }

    private static void signalError(LinkedList<Thread> threads) {
        Thread currentThread = Thread.currentThread();
        for (Thread t : threads) {
            if (t == currentThread) continue;
            AssertionError assertionError = new AssertionError((Object)(String.valueOf(t.getName()) + " killed by " + currentThread.getName()));
            ((Throwable)((Object)assertionError)).setStackTrace(t.getStackTrace());
            t.stop((Throwable)((Object)assertionError));
        }
    }

    private static void makeAccessible(final AccessibleObject obj) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                obj.setAccessible(true);
                return null;
            }
        });
    }

    public static TestSuite buildTestSuite(Class<?> c) {
        return TestFramework.buildTestSuite(c, c.getName());
    }

    public static TestSuite buildTestSuite(Class<?> c, String suiteName) {
        Class<?>[] innerClasses;
        TestSuite suite = new TestSuite(suiteName);
        Class[] CNULL = null;
        Object[] ONULL = null;
        Constructor<?> mainCons = null;
        Class<?>[] classArray = innerClasses = c.getDeclaredClasses();
        int n = innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (Test.class.isAssignableFrom(innerClass)) {
                Constructor<?> cons2;
                try {
                    cons2 = innerClass.getDeclaredConstructor(CNULL);
                    if (!cons2.isAccessible()) {
                        TestFramework.makeAccessible(cons2);
                    }
                    suite.addTest((Test)cons2.newInstance(ONULL));
                }
                catch (Exception cons2) {
                    try {
                        cons2 = innerClass.getDeclaredConstructor(c);
                        if (!cons2.isAccessible()) {
                            TestFramework.makeAccessible(cons2);
                        }
                        if (mainCons == null && !(mainCons = c.getDeclaredConstructor(CNULL)).isAccessible()) {
                            TestFramework.makeAccessible(mainCons);
                        }
                        Object outerInstance = mainCons.newInstance(ONULL);
                        Test test = (Test)cons2.newInstance(outerInstance);
                        if (outerInstance instanceof TestCase && test instanceof MultithreadedTest) {
                            TestFramework.addSetUpAndTearDown((MultithreadedTest)test, (TestCase)outerInstance);
                        }
                        suite.addTest(test);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        return suite;
    }

    public static void addSetUpAndTearDown(MultithreadedTest mtc, TestCase tc) throws SecurityException, NoSuchMethodException {
        Method setUp = null;
        Method tearDown = null;
        setUp = TestCase.class.getDeclaredMethod("setUp", null);
        if (!setUp.isAccessible()) {
            TestFramework.makeAccessible(setUp);
        }
        if (!(tearDown = TestCase.class.getDeclaredMethod("tearDown", null)).isAccessible()) {
            TestFramework.makeAccessible(tearDown);
        }
        mtc.addSetUpAndTearDown(tc, setUp, tearDown);
    }

    static /* synthetic */ boolean access$0() {
        return isJDK14;
    }

    static /* synthetic */ void access$1(AccessibleObject accessibleObject) {
        TestFramework.makeAccessible(accessibleObject);
    }

    static /* synthetic */ void access$2(LinkedList linkedList) {
        TestFramework.signalError(linkedList);
    }
}

