/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemEventSerializer {
    @NotNull
    public static String serialize(@NotNull ExternalSystemEvent event) {
        if (event == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(0);
        }
        String prefix = event.getTimestamp() + " " + event.getEventType().name();
        if (event instanceof ExternalUploadFinishedEvent) {
            ExternalUploadFinishedEvent failed = (ExternalUploadFinishedEvent)event;
            if (StatisticsEventLogUtil.isNotEmpty(failed.getError())) {
                String string = prefix + " " + StatisticsEventEscaper.escape(failed.getError());
                if (string == null) {
                    ExternalSystemEventSerializer.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = prefix;
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (event instanceof ExternalUploadSendEvent) {
            ExternalUploadSendEvent finished = (ExternalUploadSendEvent)event;
            String string = prefix + " " + finished.getSucceed() + " " + finished.getFailed() + " " + finished.getTotal();
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (event instanceof ExternalSystemErrorEvent) {
            ExternalSystemErrorEvent error = (ExternalSystemErrorEvent)event;
            String string = prefix + " " + StatisticsEventEscaper.escape(error.getEvent()) + " " + StatisticsEventEscaper.escape(error.getErrorClass());
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = prefix;
        if (string == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static ExternalSystemEvent deserialize(@NotNull String line) {
        String[] parts;
        int length;
        ExternalSystemEventType type;
        if (line == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(6);
        }
        ExternalSystemEventType externalSystemEventType = type = (length = (parts = line.split(" ")).length) > 1 ? ExternalSystemEventType.parse(parts[1]) : null;
        if (type == null) {
            return null;
        }
        long timestamp = ExternalSystemEventSerializer.parseLong(parts[0]);
        if (type == ExternalSystemEventType.FINISHED) {
            String error = parts.length >= 3 ? parts[2].trim() : null;
            return new ExternalUploadFinishedEvent(timestamp, error);
        }
        if (type == ExternalSystemEventType.SEND && length == 5) {
            int succeed = ExternalSystemEventSerializer.parseInt(parts[2]);
            int failed = ExternalSystemEventSerializer.parseInt(parts[3]);
            int total = ExternalSystemEventSerializer.parseInt(parts[4]);
            return new ExternalUploadSendEvent(timestamp, succeed, failed, total);
        }
        if (type == ExternalSystemEventType.STARTED && length == 2) {
            return new ExternalUploadStartedEvent(timestamp);
        }
        if (type == ExternalSystemEventType.ERROR && length == 4) {
            String event = parts[2].trim();
            String errorClass = parts[3].trim();
            return new ExternalSystemErrorEvent(timestamp, event, errorClass);
        }
        return null;
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/events/ExternalSystemEventSerializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/events/ExternalSystemEventSerializer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

