/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.connect.StatServiceException;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogStatisticsService
implements StatisticsService {
    private static final ContentType APPLICATION_JSON = ContentType.create((String)"application/json", (Charset)Consts.UTF_8);
    private static final int MAX_FILES_TO_SEND = 5;
    private final DeviceConfiguration myDeviceConfiguration;
    private final EventLogSettingsService mySettingsService;
    private final EventLogRecorderConfig myRecorderConfiguration;
    private final EventLogSendListener mySendListener;

    public EventLogStatisticsService(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogApplicationInfo application, @Nullable EventLogSendListener listener) {
        if (device == null) {
            EventLogStatisticsService.$$$reportNull$$$0(0);
        }
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(1);
        }
        if (application == null) {
            EventLogStatisticsService.$$$reportNull$$$0(2);
        }
        this.myDeviceConfiguration = device;
        this.myRecorderConfiguration = config;
        this.mySettingsService = new EventLogUploadSettingsService(config.getRecorderId(), application);
        this.mySendListener = listener;
    }

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, new EventLogCounterResultDecorator(this.mySendListener));
    }

    public StatisticsResult send(@NotNull EventLogResultDecorator decorator) {
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(3);
        }
        return EventLogStatisticsService.send(this.myDeviceConfiguration, this.myRecorderConfiguration, this.mySettingsService, decorator);
    }

    public static StatisticsResult send(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        if (device == null) {
            EventLogStatisticsService.$$$reportNull$$$0(4);
        }
        if (config == null) {
            EventLogStatisticsService.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            EventLogStatisticsService.$$$reportNull$$$0(6);
        }
        if (decorator == null) {
            EventLogStatisticsService.$$$reportNull$$$0(7);
        }
        EventLogApplicationInfo info = settings.getApplicationInfo();
        DataCollectorDebugLogger logger = info.getLogger();
        List<EventLogFile> logs = EventLogStatisticsService.getLogFiles(config, logger);
        if (!config.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        if (!EventLogStatisticsService.isSendLogsEnabled(device, settings.getPermittedTraffic())) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger);
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        boolean isInternal = info.isInternal();
        String productCode = info.getProductCode();
        LogEventFilter filter = settings.getEventFilter();
        try {
            decorator.onLogsLoaded(logs.size());
            ArrayList<File> toRemove = new ArrayList<File>(logs.size());
            int size = Math.min(5, logs.size());
            for (int i = 0; i < size; ++i) {
                File file = logs.get(i).getFile();
                String deviceId = device.getDeviceId();
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file, config.getRecorderId(), productCode, deviceId, filter, isInternal, logger);
                String error = EventLogStatisticsService.validate(recordRequest, file);
                if (StatisticsEventLogUtil.isNotEmpty(error) || recordRequest == null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(file.getName() + "-> " + error);
                    }
                    decorator.onFailed(recordRequest);
                    toRemove.add(file);
                    continue;
                }
                try {
                    HttpResponse response = EventLogStatisticsService.execute(info.getUserAgent(), serviceUrl, recordRequest);
                    int code = response.getStatusLine().getStatusCode();
                    if (code == 200) {
                        decorator.onSucceed(recordRequest);
                        toRemove.add(file);
                    } else {
                        decorator.onFailed(recordRequest);
                        if (code == 400) {
                            toRemove.add(file);
                        }
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(file.getName() + " -> " + EventLogStatisticsService.getResponseMessage(response));
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(file.getName() + " -> " + e.getMessage());
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove, logger);
            return decorator.onFinished();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    @NotNull
    private static HttpResponse execute(@NotNull String userAgent, String serviceUrl, LogEventRecordRequest recordRequest) throws IOException {
        if (userAgent == null) {
            EventLogStatisticsService.$$$reportNull$$$0(8);
        }
        HttpPost post = new HttpPost(serviceUrl);
        post.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new StringEntity(LogEventSerializer.INSTANCE.toString(recordRequest), APPLICATION_JSON)));
        CloseableHttpResponse closeableHttpResponse = StatisticsEventLogUtil.create(userAgent).execute((HttpUriRequest)post);
        if (closeableHttpResponse == null) {
            EventLogStatisticsService.$$$reportNull$$$0(9);
        }
        return closeableHttpResponse;
    }

    @NotNull
    private static String getResponseMessage(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (string == null) {
                EventLogStatisticsService.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = Integer.toString(response.getStatusLine().getStatusCode());
        if (string == null) {
            EventLogStatisticsService.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isSendLogsEnabled(@NotNull DeviceConfiguration userData, int percent) {
        if (userData == null) {
            EventLogStatisticsService.$$$reportNull$$$0(12);
        }
        if (percent == 0) {
            return false;
        }
        return (double)userData.getBucket() < (double)percent * 2.56;
    }

    @Nullable
    private static String validate(@Nullable LogEventRecordRequest request, @NotNull File file) {
        if (file == null) {
            EventLogStatisticsService.$$$reportNull$$$0(13);
        }
        if (request == null) {
            return "File is empty or has invalid format: " + file.getName();
        }
        if (StatisticsEventLogUtil.isEmpty(request.getDevice())) {
            return "Cannot upload event log, device ID is empty";
        }
        if (StatisticsEventLogUtil.isEmpty(request.getProduct())) {
            return "Cannot upload event log, product code is empty";
        }
        if (StatisticsEventLogUtil.isEmpty(request.getRecorder())) {
            return "Cannot upload event log, recorder code is empty";
        }
        if (request.getRecords().isEmpty()) {
            return "Cannot upload event log, record list is empty";
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return "Cannot upload event log, event list is empty";
        }
        return null;
    }

    @NotNull
    protected static List<EventLogFile> getLogFiles(@NotNull EventLogRecorderConfig provider, @NotNull DataCollectorDebugLogger logger) {
        List<EventLogFile> list;
        if (provider == null) {
            EventLogStatisticsService.$$$reportNull$$$0(14);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(15);
        }
        try {
            list = provider.getLogFilesProvider().getLogFiles();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.info(message != null ? message : "", e);
            List<EventLogFile> list2 = Collections.emptyList();
            if (list2 == null) {
                EventLogStatisticsService.$$$reportNull$$$0(17);
            }
            return list2;
        }
        if (list == null) {
            EventLogStatisticsService.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static void cleanupEventLogFiles(@NotNull List<EventLogFile> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(18);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(19);
        }
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (EventLogFile file : toRemove) {
            filesToRemove.add(file.getFile());
        }
        EventLogStatisticsService.cleanupFiles(filesToRemove, logger);
    }

    private static void cleanupFiles(@NotNull List<File> toRemove, @NotNull DataCollectorDebugLogger logger) {
        if (toRemove == null) {
            EventLogStatisticsService.$$$reportNull$$$0(20);
        }
        if (logger == null) {
            EventLogStatisticsService.$$$reportNull$$$0(21);
        }
        for (File file : toRemove) {
            if (!file.delete()) {
                logger.warn("Failed deleting event log: " + file.getName());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Removed sent log: " + file.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAgent";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 15: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogStatisticsService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "send";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSendLogsEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLogFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cleanupEventLogFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanupFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private final EventLogSendListener myListener;
        private int myLocalFiles = -1;
        private int myFailed = 0;
        private int mySucceed = 0;

        private EventLogCounterResultDecorator(@Nullable EventLogSendListener listener) {
            this.myListener = listener;
        }

        @Override
        public void onLogsLoaded(int localFiles) {
            this.myLocalFiles = localFiles;
        }

        @Override
        public void onSucceed(@NotNull LogEventRecordRequest request) {
            if (request == null) {
                EventLogCounterResultDecorator.$$$reportNull$$$0(0);
            }
            ++this.mySucceed;
        }

        @Override
        public void onFailed(@Nullable LogEventRecordRequest request) {
            ++this.myFailed;
        }

        @Override
        @NotNull
        public StatisticsResult onFinished() {
            int total;
            if (this.myListener != null) {
                this.myListener.onLogsSend(this.mySucceed, this.myFailed, this.myLocalFiles);
            }
            if ((total = this.mySucceed + this.myFailed) == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (this.myFailed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + this.mySucceed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + this.mySucceed + " files.");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/internal/statistic/eventLog/EventLogStatisticsService$EventLogCounterResultDecorator", "onSucceed"));
        }
    }
}

