/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    protected static final String SERVICE_URL_ATTR_NAME = "url";
    private Map<String, String> myAttributesMap;
    @Nullable
    private final String mySettingsUrl;
    @Nullable
    private final String myDefaultServiceUrl;
    @NotNull
    private final String myUserAgent;
    @Nullable
    private final DataCollectorDebugLogger myLogger;
    @NotNull
    private final DataCollectorSystemEventLogger myEventLogger;

    protected String @NotNull [] getAttributeNames() {
        String[] stringArray = new String[]{SERVICE_URL_ATTR_NAME};
        if (stringArray == null) {
            SettingsConnectionService.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    protected SettingsConnectionService(@Nullable String settingsUrl, @Nullable String defaultServiceUrl, @NotNull String userAgent, @Nullable DataCollectorDebugLogger logger, @NotNull DataCollectorSystemEventLogger eventLogger) {
        if (userAgent == null) {
            SettingsConnectionService.$$$reportNull$$$0(1);
        }
        if (eventLogger == null) {
            SettingsConnectionService.$$$reportNull$$$0(2);
        }
        this.mySettingsUrl = settingsUrl;
        this.myDefaultServiceUrl = defaultServiceUrl;
        this.myUserAgent = userAgent;
        this.myLogger = logger;
        this.myEventLogger = eventLogger;
    }

    @Deprecated
    @Nullable
    public String getSettingsUrl() {
        return this.mySettingsUrl;
    }

    @Nullable
    public String getDefaultServiceUrl() {
        return this.myDefaultServiceUrl;
    }

    @NotNull
    private Map<String, String> readSettings(String ... attributes) {
        block9: {
            LinkedHashMap<String, String> linkedHashMap;
            if (this.mySettingsUrl == null) {
                Map<String, String> map = Collections.emptyMap();
                if (map == null) {
                    SettingsConnectionService.$$$reportNull$$$0(3);
                }
                return map;
            }
            try {
                InputStream content;
                HttpEntity entity = StatisticsEventLogUtil.create(this.myUserAgent).execute((HttpUriRequest)new HttpGet(this.mySettingsUrl)).getEntity();
                InputStream inputStream = content = entity != null ? entity.getContent() : null;
                if (content == null) break block9;
                LinkedHashMap<String, String> settings = new LinkedHashMap<String, String>();
                try {
                    Element root = StatisticsEventLogUtil.parseXml(content);
                    for (String s : attributes) {
                        String attributeValue = root.getAttributeValue(s);
                        if (!StatisticsEventLogUtil.isNotEmpty(attributeValue)) continue;
                        settings.put(s, attributeValue);
                    }
                }
                catch (JDOMException e) {
                    this.logError((Exception)((Object)e));
                }
                linkedHashMap = settings;
            }
            catch (Exception e) {
                this.logError(e);
            }
            if (linkedHashMap == null) {
                SettingsConnectionService.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            SettingsConnectionService.$$$reportNull$$$0(5);
        }
        return map;
    }

    private void logError(Exception e) {
        if (this.myLogger != null) {
            String message = e.getMessage();
            this.myLogger.warn(message != null ? message : "", e);
        }
        this.myEventLogger.logErrorEvent("loading.config.failed", e);
    }

    @Nullable
    public String getServiceUrl() {
        String serviceUrl = this.getSettingValue(SERVICE_URL_ATTR_NAME);
        return serviceUrl == null ? this.getDefaultServiceUrl() : serviceUrl;
    }

    @Nullable
    protected String getSettingValue(@NotNull String attributeValue) {
        if (attributeValue == null) {
            SettingsConnectionService.$$$reportNull$$$0(6);
        }
        if (this.myAttributesMap == null || this.myAttributesMap.isEmpty()) {
            this.myAttributesMap = this.readSettings(this.getAttributeNames());
        }
        return this.myAttributesMap.get(attributeValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/connect/SettingsConnectionService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userAgent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLogger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/connect/SettingsConnectionService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSettingValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

