/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.FlowLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFile;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigPreviewFileEditor
implements FileEditor,
CodeStyleSettingsListener {
    private final Editor myEditor;
    private final EditorConfigPreviewFile myPreviewFile;

    public EditorConfigPreviewFileEditor(@NotNull Editor editor, @NotNull EditorConfigPreviewFile previewFile) {
        if (editor == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(0);
        }
        if (previewFile == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(1);
        }
        this.myEditor = editor;
        this.myPreviewFile = previewFile;
        if (this.myEditor instanceof EditorEx) {
            ((EditorEx)this.myEditor).setPermanentHeaderComponent(EditorConfigPreviewFileEditor.getHeaderComponent());
        }
        this.myEditor.setHeaderComponent(EditorConfigPreviewFileEditor.getHeaderComponent());
        EditorSettings editorSettings = this.myEditor.getSettings();
        editorSettings.setWhitespacesShown(true);
        editorSettings.setGutterIconsShown(false);
        editorSettings.setLineNumbersShown(false);
        this.updateEditor();
        CodeStyleSettingsManager.getInstance((Project)this.myEditor.getProject()).addListener((CodeStyleSettingsListener)this);
    }

    private static JComponent getHeaderComponent() {
        JPanel previewHeaderPanel = new JPanel();
        previewHeaderPanel.setLayout(new FlowLayout(0));
        JLabel warningLabel = new JLabel(EditorConfigBundle.message("editor.preview.not.saved.warning"));
        warningLabel.setForeground((Color)JBColor.GRAY);
        previewHeaderPanel.add(warningLabel);
        previewHeaderPanel.setBorder(IdeBorderFactory.createBorder());
        return previewHeaderPanel;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Preview";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myEditor.getProject(), (CodeStyleSettingsListener)this);
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(6);
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(7);
        }
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            EditorConfigPreviewFileEditor.$$$reportNull$$$0(8);
        }
        this.updateEditor();
    }

    private void updateEditor() {
        PsiFile originalPsi = this.myPreviewFile.resolveOriginalPsi();
        if (originalPsi != null) {
            CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)originalPsi);
            Language language = this.myPreviewFile.getLanguage();
            this.myEditor.getSettings().setRightMargin(settings.getRightMargin(language));
            this.myEditor.getSettings().setSoftMargins(settings.getSoftMargins(language));
            this.myEditor.getSettings().setTabSize(settings.getTabSize(this.myPreviewFile.getFileType()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/editor/EditorConfigPreviewFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

