/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogCachesInvalidator;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogProjectTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsProjectLog
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsProjectLog.class);
    public static final Topic<ProjectLogListener> VCS_PROJECT_LOG_CHANGED = Topic.create((String)"Project Vcs Log Created or Disposed", ProjectLogListener.class);
    private static final int RECREATE_LOG_TRIES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @NotNull
    private final VcsLogTabsManager myTabsManager;
    @NotNull
    private final LazyVcsLogManager myLogManager;
    @NotNull
    private final Disposable myMessageBusConnections;
    @NotNull
    private final ExecutorService myExecutor;
    private volatile boolean myDisposeStarted;
    private int myRecreatedLogCount;

    public VcsProjectLog(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(0);
        }
        this.myLogManager = new LazyVcsLogManager();
        this.myMessageBusConnections = Disposer.newDisposable();
        this.myDisposeStarted = false;
        this.myRecreatedLogCount = 0;
        this.myProject = project;
        this.myMessageBus = this.myProject.getMessageBus();
        VcsLogProjectTabsProperties uiProperties = (VcsLogProjectTabsProperties)ServiceManager.getService((Project)this.myProject, VcsLogProjectTabsProperties.class);
        this.myUiProperties = uiProperties;
        this.myTabsManager = new VcsLogTabsManager(project, this.myMessageBus, uiProperties, this);
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Vcs Log Initialization/Dispose", (int)1);
        this.myMessageBus.connect(this.myMessageBusConnections).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VcsProjectLog.this.myProject != project) {
                    return;
                }
                VcsProjectLog.this.myDisposeStarted = true;
                Disposer.dispose((Disposable)VcsProjectLog.this.myMessageBusConnections);
                VcsProjectLog.this.disposeLog(false);
                VcsProjectLog.this.myExecutor.shutdown();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    try {
                        VcsProjectLog.this.myExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }, VcsLogBundle.message((String)"vcs.log.closing.process", (Object[])new Object[0]), false, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$1", "projectClosing"));
            }
        });
    }

    private void subscribeToMappingsChanges() {
        this.myMessageBus.connect(this.myMessageBusConnections).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.disposeLog(true));
    }

    @Nullable
    public VcsLogData getDataManager() {
        VcsLogManager cached = this.myLogManager.getCached();
        if (cached == null) {
            return null;
        }
        return cached.getDataManager();
    }

    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        VcsLogContentProvider logContentProvider = VcsLogContentProvider.getInstance(this.myProject);
        if (logContentProvider == null) {
            return null;
        }
        return (VcsLogUiImpl)logContentProvider.getUi();
    }

    @Nullable
    public VcsLogManager getLogManager() {
        return this.myLogManager.getCached();
    }

    @NotNull
    public VcsLogTabsManager getTabsManager() {
        VcsLogTabsManager vcsLogTabsManager = this.myTabsManager;
        if (vcsLogTabsManager == null) {
            VcsProjectLog.$$$reportNull$$$0(1);
        }
        return vcsLogTabsManager;
    }

    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters) {
        return this.openLogTab(filters, VcsLogManager.LogWindowKind.TOOL_WINDOW);
    }

    @Nullable
    public MainVcsLogUi openLogTab(@Nullable VcsLogFilterCollection filters, @NotNull VcsLogManager.LogWindowKind kind) {
        VcsLogManager logManager;
        if (kind == null) {
            VcsProjectLog.$$$reportNull$$$0(2);
        }
        if ((logManager = this.getLogManager()) == null) {
            return null;
        }
        return this.myTabsManager.openAnotherLogTab(logManager, filters, kind);
    }

    private void disposeLog(boolean recreate) {
        this.myExecutor.execute(() -> {
            VcsLogManager logManager = (VcsLogManager)VcsProjectLog.invokeAndWait(() -> {
                VcsLogManager manager = this.myLogManager.dropValue();
                if (manager != null) {
                    manager.disposeUi();
                }
                return manager;
            });
            if (logManager != null) {
                Disposer.dispose((Disposable)logManager);
            }
            if (recreate) {
                this.createLog(false);
            }
        });
    }

    private void recreateOnError(@NotNull Throwable t) {
        if (t == null) {
            VcsProjectLog.$$$reportNull$$$0(3);
        }
        if (++this.myRecreatedLogCount % 5 == 0) {
            String message = VcsLogBundle.message((String)"vcs.log.recreated.due.to.corruption", (Object[])new Object[]{this.myRecreatedLogCount, PersistentUtil.LOG_CACHE, ApplicationNamesInfo.getInstance().getFullProductName(), t.getMessage()});
            LOG.error(message, t);
            VcsLogManager manager = this.getLogManager();
            if (manager != null && manager.isLogVisible()) {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
            }
        } else {
            LOG.debug("Recreating VCS Log after storage corruption", t);
        }
        this.disposeLog(true);
    }

    @NotNull
    Future<VcsLogManager> createLogInBackground(boolean forceInit) {
        Future<VcsLogManager> future2 = this.myExecutor.submit(() -> this.createLog(forceInit));
        if (future2 == null) {
            VcsProjectLog.$$$reportNull$$$0(4);
        }
        return future2;
    }

    @Nullable
    private VcsLogManager createLog(boolean forceInit) {
        if (this.myDisposeStarted) {
            return null;
        }
        Map<VirtualFile, VcsLogProvider> logProviders = VcsProjectLog.getLogProviders(this.myProject);
        if (!logProviders.isEmpty()) {
            VcsLogManager logManager = this.myLogManager.getValue(logProviders);
            VcsProjectLog.initialize(logManager, forceInit);
            return logManager;
        }
        return null;
    }

    private static void initialize(@NotNull VcsLogManager logManager, boolean force) {
        VcsLogCachesInvalidator invalidator;
        if (logManager == null) {
            VcsProjectLog.$$$reportNull$$$0(5);
        }
        if (force) {
            logManager.scheduleInitialization();
            return;
        }
        if (PostponableLogRefresher.keepUpToDate() && (invalidator = (VcsLogCachesInvalidator)((Object)CachesInvalidator.EP_NAME.findExtension(VcsLogCachesInvalidator.class))).isValid()) {
            HeavyAwareExecutor.executeOutOfHeavyProcessLater(logManager::scheduleInitialization, 5000);
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (logManager.isLogVisible()) {
                logManager.scheduleInitialization();
            }
        }, VcsProjectLog.getModality());
    }

    @NotNull
    static Map<VirtualFile, VcsLogProvider> getLogProviders(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(6);
        }
        Map<VirtualFile, VcsLogProvider> map2 = VcsLogManager.findLogProviders(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()), project);
        if (map2 == null) {
            VcsProjectLog.$$$reportNull$$$0(7);
        }
        return map2;
    }

    public static VcsProjectLog getInstance(@NotNull Project project) {
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(8);
        }
        return (VcsProjectLog)ServiceManager.getService((Project)project, VcsProjectLog.class);
    }

    public void dispose() {
    }

    private static <T> T invokeAndWait(@NotNull Computable<T> computable) {
        if (computable == null) {
            VcsProjectLog.$$$reportNull$$$0(9);
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set(computable.compute()), VcsProjectLog.getModality());
        return (T)result2.get();
    }

    @NotNull
    private static ModalityState getModality() {
        ModalityState modalityState = ModalityState.any();
        if (modalityState == null) {
            VcsProjectLog.$$$reportNull$$$0(10);
        }
        return modalityState;
    }

    public static void runWhenLogIsReady(@NotNull Project project, final @NotNull BiConsumer<? super VcsProjectLog, ? super VcsLogManager> action) {
        VcsProjectLog log;
        VcsLogManager manager;
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(11);
        }
        if (action == null) {
            VcsProjectLog.$$$reportNull$$$0(12);
        }
        if ((manager = (log = VcsProjectLog.getInstance(project)).getLogManager()) != null) {
            action.accept(log, manager);
        } else {
            final Future<VcsLogManager> futureLogManager = log.createLogInBackground(true);
            new Task.Backgroundable(project, VcsLogBundle.message((String)"vcs.log.creating.process", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        futureLogManager.get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    catch (TimeoutException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onSuccess() {
                    VcsLogManager manager = log.getLogManager();
                    if (manager != null) {
                        action.accept(log, manager);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/VcsProjectLog$2", "run"));
                }
            }.queue();
        }
    }

    @Nullable
    public static VcsLogManager getOrCreateLog(@NotNull Project project) {
        VcsProjectLog log;
        VcsLogManager manager;
        if (project == null) {
            VcsProjectLog.$$$reportNull$$$0(13);
        }
        if ((manager = (log = VcsProjectLog.getInstance(project)).getLogManager()) == null) {
            try {
                manager = log.createLogInBackground(true).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        return manager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogInBackground";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openLogTab";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "recreateOnError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLogProviders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runWhenLogIsReady";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProjectLogListener {
        public void logCreated(@NotNull VcsLogManager var1);

        default public void logDisposed(@NotNull VcsLogManager manager) {
            if (manager == null) {
                ProjectLogListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsProjectLog$ProjectLogListener", "logDisposed"));
        }
    }

    public static class InitLogStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                InitLogStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
            projectLog.subscribeToMappingsChanges();
            projectLog.createLogInBackground(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsProjectLog$InitLogStartupActivity", "runActivity"));
        }
    }

    private class LazyVcsLogManager {
        @Nullable
        private volatile VcsLogManager myValue;

        private LazyVcsLogManager() {
        }

        @NotNull
        public VcsLogManager getValue(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
            if (logProviders == null) {
                LazyVcsLogManager.$$$reportNull$$$0(0);
            }
            if (this.myValue == null) {
                VcsLogManager value;
                LOG.debug("Creating Vcs Log for " + VcsLogUtil.getProvidersMapText(logProviders));
                this.myValue = value = new VcsLogManager(VcsProjectLog.this.myProject, VcsProjectLog.this.myUiProperties, logProviders, false, (Consumer<? super Throwable>)((Consumer)x$0 -> VcsProjectLog.this.recreateOnError(x$0)));
                ApplicationManager.getApplication().invokeAndWait(() -> ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logCreated(value), VcsProjectLog.getModality());
            }
            VcsLogManager vcsLogManager = this.myValue;
            if (vcsLogManager == null) {
                LazyVcsLogManager.$$$reportNull$$$0(1);
            }
            return vcsLogManager;
        }

        @Nullable
        public VcsLogManager dropValue() {
            LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
            if (this.myValue != null) {
                VcsLogManager oldValue = this.myValue;
                LOG.debug("Disposing Vcs Log for " + VcsLogUtil.getProvidersMapText(oldValue.getDataManager().getLogProviders()));
                ((ProjectLogListener)VcsProjectLog.this.myMessageBus.syncPublisher(VCS_PROJECT_LOG_CHANGED)).logDisposed(oldValue);
                this.myValue = null;
                return oldValue;
            }
            return null;
        }

        @Nullable
        public VcsLogManager getCached() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logProviders";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/VcsProjectLog$LazyVcsLogManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

