/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesDnDSupport
implements DnDDropHandler,
DnDTargetChecker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeListManagerImpl myChangeListManager;
    @NotNull
    private final Tree myTree;

    public static void install(@NotNull Project project, @NotNull Tree tree) {
        if (project == null) {
            ChangesDnDSupport.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            ChangesDnDSupport.$$$reportNull$$$0(1);
        }
        new ChangesDnDSupport(project, tree).install();
    }

    private ChangesDnDSupport(@NotNull Project project, @NotNull Tree tree) {
        if (project == null) {
            ChangesDnDSupport.$$$reportNull$$$0(2);
        }
        if (tree == null) {
            ChangesDnDSupport.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        this.myTree = tree;
    }

    private void install() {
        DnDSupport.createBuilder((JComponent)this.myTree).setTargetChecker((DnDTargetChecker)this).setDropHandler((DnDDropHandler)this).setImageProvider(this::createDraggedImage).setBeanProvider(this::createDragStartBean).setDisposableParent((Disposable)(this.myTree instanceof Disposable ? (Disposable)this.myTree : this.myProject)).install();
    }

    @NotNull
    private DnDImage createDraggedImage(@NotNull DnDActionInfo info) {
        if (info == null) {
            ChangesDnDSupport.$$$reportNull$$$0(4);
        }
        int count = this.getSelectionCount();
        String imageText = count + " " + StringUtil.pluralize((String)"file", (int)count);
        Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, (String)imageText, null).getFirst();
        return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
    }

    @Nullable
    private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            ChangesDnDSupport.$$$reportNull$$$0(5);
        }
        DnDDragStartBean result2 = null;
        if (info.isMove()) {
            Change[] changes = (Change[])ChangesListView.getChanges(this.myProject, this.myTree.getSelectionPaths()).toArray(Change[]::new);
            List<FilePath> unversionedFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG).collect(Collectors.toList());
            List<FilePath> ignoredFiles = ChangesListView.getFilePaths(this.myTree.getSelectionPaths(), ChangesBrowserNode.IGNORED_FILES_TAG).collect(Collectors.toList());
            if (changes.length > 0 || !unversionedFiles.isEmpty() || !ignoredFiles.isEmpty()) {
                result2 = new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)this.myTree, changes, unversionedFiles, ignoredFiles));
            }
        }
        return result2;
    }

    public boolean update(DnDEvent aEvent) {
        aEvent.hideHighlighter();
        aEvent.setDropPossible(false, "");
        Object attached = aEvent.getAttachedObject();
        ChangesBrowserNode<?> dropNode = ChangesDnDSupport.getDropRootNode(this.myTree, aEvent);
        if (attached instanceof ChangeListDragBean) {
            ChangeListDragBean dragBean = (ChangeListDragBean)attached;
            dragBean.setTargetNode(dropNode);
            if (dragBean.getSourceComponent() != this.myTree || dropNode == null || !dropNode.canAcceptDrop(dragBean)) {
                return true;
            }
        } else if (attached instanceof ShelvedChangeListDragBean) {
            if (dropNode != null && !(dropNode instanceof ChangesBrowserChangeListNode)) {
                return true;
            }
        } else {
            return true;
        }
        if (dropNode != null) {
            this.highlightDropNode(aEvent, dropNode);
        }
        aEvent.setDropPossible(true);
        return false;
    }

    private void highlightDropNode(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode<?> dropNode) {
        Rectangle tableCellRect;
        if (aEvent == null) {
            ChangesDnDSupport.$$$reportNull$$$0(6);
        }
        if (dropNode == null) {
            ChangesDnDSupport.$$$reportNull$$$0(7);
        }
        if ((tableCellRect = this.myTree.getPathBounds(new TreePath(dropNode.getPath()))) != null && this.fitsInBounds(tableCellRect)) {
            aEvent.setHighlighting(new RelativeRectangle((Component)this.myTree, tableCellRect), 1);
        }
    }

    @Nullable
    public static ChangesBrowserNode<?> getDropRootNode(@NotNull Tree tree, @NotNull DnDEvent event) {
        if (tree == null) {
            ChangesDnDSupport.$$$reportNull$$$0(8);
        }
        if (event == null) {
            ChangesDnDSupport.$$$reportNull$$$0(9);
        }
        RelativePoint dropPoint = event.getRelativePoint();
        Point onTree = dropPoint.getPoint((Component)tree);
        TreePath dropPath = tree.getPathForLocation(onTree.x, onTree.y);
        if (dropPath == null) {
            return null;
        }
        TreeNode dropNode = (ChangesBrowserNode)dropPath.getLastPathComponent();
        while (!((DefaultMutableTreeNode)dropNode.getParent()).isRoot()) {
            dropNode = dropNode.getParent();
        }
        return dropNode;
    }

    public void drop(DnDEvent aEvent) {
        ChangeListDragBean dragBean;
        ChangesBrowserNode changesBrowserNode;
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ShelvedChangeListDragBean) {
            ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attached, ChangesDnDSupport.getDropRootNode(this.myTree, aEvent), !ChangesDnDSupport.isCopyAction(aEvent));
        } else if (attached instanceof ChangeListDragBean && (changesBrowserNode = (dragBean = (ChangeListDragBean)attached).getTargetNode()) != null) {
            changesBrowserNode.acceptDrop(this.myChangeListManager, dragBean);
        }
    }

    public static boolean isCopyAction(@NotNull DnDEvent aEvent) {
        DnDAction eventAction;
        if (aEvent == null) {
            ChangesDnDSupport.$$$reportNull$$$0(10);
        }
        return (eventAction = aEvent.getAction()) != null && eventAction.getActionId() == 1;
    }

    private boolean fitsInBounds(Rectangle rect) {
        Container scrollPane;
        Container container = this.myTree.getParent();
        if (container instanceof JViewport && (scrollPane = container.getParent()) instanceof JScrollPane) {
            Rectangle rectangle = SwingUtilities.convertRectangle((Component)this.myTree, rect, scrollPane.getParent());
            return scrollPane.getBounds().contains(rectangle);
        }
        return true;
    }

    private int getSelectionCount() {
        TreePath[] paths = this.myTree.getSelectionModel().getSelectionPaths();
        int count = 0;
        ArrayList<ChangesBrowserNode> nodes = new ArrayList<ChangesBrowserNode>();
        for (TreePath path2 : paths) {
            ChangesBrowserNode node = (ChangesBrowserNode)path2.getLastPathComponent();
            if (node.isLeaf()) continue;
            nodes.add(node);
            count += node.getFileCount();
        }
        for (TreePath path2 : paths) {
            ChangesBrowserNode element = (ChangesBrowserNode)path2.getLastPathComponent();
            boolean child = false;
            for (ChangesBrowserNode node : nodes) {
                if (!node.isNodeChild(element)) continue;
                child = true;
                break;
            }
            if (!child) {
                if (!element.isLeaf()) continue;
                ++count;
                continue;
            }
            if (element.isLeaf()) continue;
            count -= element.getFileCount();
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aEvent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesDnDSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDraggedImage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragStartBean";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightDropNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropRootNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

