/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnversionedDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @Nullable
    private final Project myProject;
    @NotNull
    private final FilePath myPath;

    private UnversionedDiffRequestProducer(@Nullable Project project, @NotNull FilePath path2) {
        if (path2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPath = path2;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(1);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = FileStatus.UNKNOWN;
        if (fileStatus == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return fileStatus;
    }

    @Override
    @Nullable
    public Object getPopupTag() {
        return ChangesBrowserNode.UNVERSIONED_FILES_TAG;
    }

    @NotNull
    public String getName() {
        String string = this.myPath.getPresentableUrl();
        if (string == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        VirtualFile file;
        if (context == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(5);
        }
        if ((file = this.myPath.getVirtualFile()) == null) {
            throw new DiffRequestProducerException("Can't show diff - file not found");
        }
        return UnversionedDiffRequestProducer.createRequest(this.myProject, file);
    }

    @NotNull
    public static UnversionedDiffRequestProducer create(@Nullable Project project, @NotNull FilePath path2) {
        if (path2 == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(6);
        }
        return new UnversionedDiffRequestProducer(project, path2);
    }

    @NotNull
    private static DiffRequest createRequest(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(7);
        }
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        EmptyContent content1 = contentFactory.createEmpty();
        DiffContent content2 = contentFactory.create(project, file);
        SimpleDiffRequest request = new SimpleDiffRequest(DiffRequestFactory.getInstance().getTitle(file), (DiffContent)content1, content2, null, ChangeDiffRequestProducer.getYourVersion());
        DiffUtil.putDataKey((UserDataHolder)request, (DataKey)VcsDataKeys.CURRENT_UNVERSIONED, (Object)file);
        SimpleDiffRequest simpleDiffRequest = request;
        if (simpleDiffRequest == null) {
            UnversionedDiffRequestProducer.$$$reportNull$$$0(8);
        }
        return simpleDiffRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnversionedDiffRequestProducer producer = (UnversionedDiffRequestProducer)o;
        return Objects.equals(this.myPath, producer.myPath);
    }

    public int hashCode() {
        return this.myPath.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/UnversionedDiffRequestProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

