/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018J\u0006\u0010\u001b\u001a\u00020\u000fJ\u0006\u0010\u001c\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/DirtBuilder;", "", "builder", "(Lcom/intellij/openapi/vcs/changes/DirtBuilder;)V", "()V", "dirsForVcs", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeMap;", "getDirsForVcs", "()Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeMap;", "fileTypeManager", "Lcom/intellij/openapi/fileTypes/FileTypeManager;", "kotlin.jvm.PlatformType", "filesForVcs", "getFilesForVcs", "isEverythingDirty", "", "()Z", "setEverythingDirty", "(Z)V", "addDirtyDirRecursively", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "dir", "Lcom/intellij/openapi/vcs/FilePath;", "addDirtyFile", "file", "isEmpty", "reset", "intellij.platform.vcs.impl"})
public final class DirtBuilder {
    private final FileTypeManager fileTypeManager;
    @NotNull
    private final VcsDirtyScopeMap filesForVcs;
    @NotNull
    private final VcsDirtyScopeMap dirsForVcs;
    private boolean isEverythingDirty;

    @NotNull
    public final VcsDirtyScopeMap getFilesForVcs() {
        return this.filesForVcs;
    }

    @NotNull
    public final VcsDirtyScopeMap getDirsForVcs() {
        return this.dirsForVcs;
    }

    public final boolean isEverythingDirty() {
        return this.isEverythingDirty;
    }

    public final void setEverythingDirty(boolean bl) {
        this.isEverythingDirty = bl;
    }

    public final boolean isEmpty() {
        return this.filesForVcs.isEmpty() && this.dirsForVcs.isEmpty();
    }

    public final void reset() {
        this.filesForVcs.clear();
        this.dirsForVcs.clear();
        this.isEverythingDirty = false;
    }

    public final void addDirtyFile(@NotNull AbstractVcs vcs, @NotNull FilePath file) {
        Intrinsics.checkParameterIsNotNull((Object)vcs, (String)"vcs");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.fileTypeManager.isFileIgnored(file.getName())) {
            return;
        }
        this.filesForVcs.add(vcs, file);
    }

    public final void addDirtyDirRecursively(@NotNull AbstractVcs vcs, @NotNull FilePath dir) {
        Intrinsics.checkParameterIsNotNull((Object)vcs, (String)"vcs");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        if (this.fileTypeManager.isFileIgnored(dir.getName())) {
            return;
        }
        this.dirsForVcs.add(vcs, dir);
    }

    public DirtBuilder() {
        this.fileTypeManager = FileTypeManager.getInstance();
        this.filesForVcs = new VcsDirtyScopeMap();
        this.dirsForVcs = new VcsDirtyScopeMap();
    }

    public DirtBuilder(@NotNull DirtBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this();
        this.filesForVcs.addAll(builder.filesForVcs);
        this.dirsForVcs.addAll(builder.dirsForVcs);
        this.isEverythingDirty = builder.isEverythingDirty;
    }
}

