/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class SwitchAnnotationSourceAction
extends AnAction
implements DumbAware {
    private final AnnotationSourceSwitcher mySwitcher;
    private final List<Consumer<AnnotationSource>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShowMerged;

    SwitchAnnotationSourceAction(AnnotationSourceSwitcher switcher) {
        this.mySwitcher = switcher;
        this.myShowMerged = this.mySwitcher.getDefaultSource().showMerged();
    }

    public void addSourceSwitchListener(Consumer<AnnotationSource> listener2) {
        this.myListeners.add(listener2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchAnnotationSourceAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setText(this.myShowMerged ? SwitchAnnotationSourceAction.getHideMerged() : SwitchAnnotationSourceAction.getShowMerged());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SwitchAnnotationSourceAction.$$$reportNull$$$0(1);
        }
        this.myShowMerged = !this.myShowMerged;
        AnnotationSource newSource = AnnotationSource.getInstance((boolean)this.myShowMerged);
        this.mySwitcher.switchTo(newSource);
        for (Consumer<AnnotationSource> listener2 : this.myListeners) {
            listener2.consume((Object)newSource);
        }
        AnnotateActionGroup.revalidateMarkupInAllEditors();
    }

    private static String getShowMerged() {
        return VcsBundle.message((String)"annotation.switch.to.merged.text", (Object[])new Object[0]);
    }

    private static String getHideMerged() {
        return VcsBundle.message((String)"annotation.switch.to.original.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/actions/SwitchAnnotationSourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

