/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.TextMergeViewer;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.base.DiffViewerListener;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateDiffViewerAction {
    private static final Logger LOG = Logger.getInstance(AnnotateDiffViewerAction.class);

    @Nullable
    private static ViewerAnnotator getAnnotator(@NotNull DiffViewerBase viewer, @NotNull Editor editor) {
        if (viewer == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(1);
        }
        for (ViewerAnnotatorFactory annotator : Holder.ANNOTATORS) {
            if (!annotator.getViewerClass().isInstance(viewer)) continue;
            return annotator.createAnnotator(viewer, editor);
        }
        return null;
    }

    @Nullable
    private static EventData collectEventData(@NotNull AnActionEvent e) {
        DiffViewerBase viewer;
        if (e == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(2);
        }
        if ((viewer = AnnotateDiffViewerAction.getViewer(e)) == null) {
            return null;
        }
        if (viewer.getProject() == null) {
            return null;
        }
        if (viewer.isDisposed()) {
            return null;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        ViewerAnnotator annotator = AnnotateDiffViewerAction.getAnnotator(viewer, editor);
        if (annotator == null) {
            return null;
        }
        return new EventData(viewer, annotator);
    }

    @Nullable
    private static DiffViewerBase getViewer(@NotNull AnActionEvent e) {
        DiffViewerBase diffViewer;
        if (e == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(3);
        }
        if ((diffViewer = (DiffViewerBase)ObjectUtils.tryCast((Object)e.getData(DiffDataKeys.DIFF_VIEWER), DiffViewerBase.class)) != null) {
            return diffViewer;
        }
        TextMergeViewer mergeViewer = (TextMergeViewer)ObjectUtils.tryCast((Object)e.getData(DiffDataKeys.MERGE_VIEWER), TextMergeViewer.class);
        if (mergeViewer != null) {
            return mergeViewer.getViewer();
        }
        return null;
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        EventData data;
        if (e == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(4);
        }
        if ((data = AnnotateDiffViewerAction.collectEventData(e)) == null) {
            return false;
        }
        if (data.annotator.isAnnotationShown()) {
            return true;
        }
        return data.annotator.createAnnotationsLoader() != null;
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        EventData data;
        if (e == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(5);
        }
        return (data = AnnotateDiffViewerAction.collectEventData(e)) != null && data.annotator.getBackgroundableLock().isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(6);
        }
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        assert (data != null);
        return data.annotator.isAnnotationShown();
    }

    private static void perform(AnActionEvent e, boolean selected) {
        EventData data = AnnotateDiffViewerAction.collectEventData(e);
        assert (data != null);
        if (!selected) {
            data.annotator.hideAnnotation();
        } else {
            AnnotateDiffViewerAction.doAnnotate(data.annotator);
        }
    }

    private static void doAnnotate(@NotNull ViewerAnnotator annotator) {
        DiffViewerBase viewer;
        Project project;
        if (annotator == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(7);
        }
        if ((project = (viewer = annotator.getViewer()).getProject()) == null) {
            return;
        }
        FileAnnotationLoader loader = annotator.createAnnotationsLoader();
        if (loader == null) {
            return;
        }
        DiffContextEx diffContext = (DiffContextEx)ObjectUtils.tryCast((Object)viewer.getContext(), DiffContextEx.class);
        annotator.getBackgroundableLock().lock();
        if (diffContext != null) {
            diffContext.showProgressBar(true);
        }
        BackgroundTaskUtil.executeOnPooledThread((Disposable)viewer, () -> {
            try {
                loader.run();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (diffContext != null) {
                        diffContext.showProgressBar(false);
                    }
                    annotator.getBackgroundableLock().unlock();
                    VcsException exception = loader.getException();
                    if (exception != null) {
                        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification("Can't Load Annotations", exception.getMessage(), NotificationType.ERROR, null);
                        AnnotateDiffViewerAction.showNotification(viewer, notification);
                        LOG.warn((Throwable)exception);
                        return;
                    }
                    if (loader.getResult() == null) {
                        return;
                    }
                    if (viewer.isDisposed()) {
                        return;
                    }
                    annotator.showAnnotation(loader.getResult());
                }, ProgressManager.getGlobalProgressIndicator().getModalityState());
            }
        });
    }

    @Nullable
    private static FileAnnotationLoader createThreesideAnnotationsLoader(@NotNull Project project, @NotNull DiffRequest request, @NotNull ThreeSide side) {
        DiffContent content2;
        FileAnnotationLoader loader;
        ContentDiffRequest requestEx;
        if (project == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(8);
        }
        if (request == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(9);
        }
        if (side == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(10);
        }
        if (request instanceof ContentDiffRequest && (requestEx = (ContentDiffRequest)request).getContents().size() == 3 && (loader = AnnotateDiffViewerAction.createAnnotationsLoader(project, content2 = (DiffContent)side.select(requestEx.getContents()))) != null) {
            return loader;
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader createTwosideAnnotationsLoader(@NotNull Project project, @NotNull DiffRequest request, @NotNull Side side) {
        ContentDiffRequest requestEx;
        ContentRevision revision;
        Change change;
        if (project == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(11);
        }
        if (request == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(12);
        }
        if (side == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(13);
        }
        if ((change = (Change)request.getUserData(ChangeDiffRequestProducer.CHANGE_KEY)) != null && (revision = (ContentRevision)side.select((Object)change.getBeforeRevision(), (Object)change.getAfterRevision())) != null) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)project);
            if (revision instanceof CurrentContentRevision) {
                VirtualFile file = ((CurrentContentRevision)revision).getVirtualFile();
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project, vcs, file);
                if (loader != null) {
                    return loader;
                }
            } else {
                FileAnnotationLoader loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs, revision.getFile(), revision.getRevisionNumber());
                if (loader != null) {
                    return loader;
                }
            }
        }
        if (request instanceof ContentDiffRequest && (requestEx = (ContentDiffRequest)request).getContents().size() == 2) {
            DiffContent content2 = (DiffContent)side.select(requestEx.getContents());
            return AnnotateDiffViewerAction.createAnnotationsLoader(project, content2);
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader createAnnotationsLoader(@NotNull Project project, @NotNull DiffContent content2) {
        FilePath filePath;
        AbstractVcs vcs;
        FileAnnotationLoader loader;
        VirtualFile file;
        AbstractVcs vcs2;
        FileAnnotationLoader loader2;
        if (project == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(15);
        }
        if (content2 instanceof FileContent && (loader2 = AnnotateDiffViewerAction.doCreateAnnotationsLoader(project, vcs2 = VcsUtil.getVcsFor((Project)project, (VirtualFile)(file = ((FileContent)content2).getFile())), file)) != null) {
            return loader2;
        }
        Pair info = (Pair)content2.getUserData(DiffUserDataKeysEx.REVISION_INFO);
        if (info != null && (loader = AnnotateDiffViewerAction.doCreateAnnotationsLoader(vcs = VcsUtil.getVcsFor((Project)project, (FilePath)(filePath = (FilePath)info.first)), filePath, (VcsRevisionNumber)info.second)) != null) {
            return loader;
        }
        return null;
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@NotNull Project project, @Nullable AbstractVcs vcs, final @Nullable VirtualFile file) {
        if (project == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(16);
        }
        if (vcs == null || file == null) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return null;
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)project).getStatus(file);
        if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
            return null;
        }
        return new FileAnnotationLoader(vcs){

            @Override
            public FileAnnotation compute() throws VcsException {
                return annotationProvider.annotate(file);
            }
        };
    }

    @Nullable
    private static FileAnnotationLoader doCreateAnnotationsLoader(@Nullable AbstractVcs vcs, final @Nullable FilePath path2, final @Nullable VcsRevisionNumber revisionNumber) {
        if (vcs == null || path2 == null || revisionNumber == null) {
            return null;
        }
        if (revisionNumber instanceof TextRevisionNumber || revisionNumber == VcsRevisionNumber.NULL) {
            return null;
        }
        final AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (!(annotationProvider instanceof AnnotationProviderEx)) {
            return null;
        }
        if (!((AnnotationProviderEx)annotationProvider).isAnnotationValid(path2, revisionNumber)) {
            return null;
        }
        return new FileAnnotationLoader(vcs){

            @Override
            public FileAnnotation compute() throws VcsException {
                return ((AnnotationProviderEx)annotationProvider).annotate(path2, revisionNumber);
            }
        };
    }

    private static void showNotification(@NotNull DiffViewerBase viewer, @NotNull Notification notification) {
        JComponent component;
        Window window;
        if (viewer == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(17);
        }
        if (notification == null) {
            AnnotateDiffViewerAction.$$$reportNull$$$0(18);
        }
        if ((window = ComponentUtil.getWindow((Component)(component = viewer.getComponent()))) instanceof IdeFrame && NotificationsManagerImpl.findWindowForBalloon((Project)viewer.getProject()) == window) {
            notification.notify(viewer.getProject());
            return;
        }
        Balloon balloon = NotificationsManagerImpl.createBalloon((JComponent)component, (Notification)notification, (boolean)false, (boolean)true, (Ref)BalloonLayoutData.fullContent(), (Disposable)viewer);
        Dimension componentSize = component.getSize();
        Dimension balloonSize = balloon.getPreferredSize();
        int width = Math.min(balloonSize.width, componentSize.width);
        int height = Math.min(balloonSize.height, componentSize.height);
        RelativePoint point = new RelativePoint((Component)component, new Point(componentSize.width - 20 - width / 2, 20 + height / 2));
        balloon.show(point, Balloon.Position.above);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectEventData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuspended";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doAnnotate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createThreesideAnnotationsLoader";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createTwosideAnnotationsLoader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationsLoader";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateAnnotationsLoader";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateDiffViewerAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateDiffViewerAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateDiffViewerAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                Provider.$$$reportNull$$$0(1);
            }
            AnnotateDiffViewerAction.perform(e, selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuspended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EventData {
        @NotNull
        public final DiffViewerBase viewer;
        @NotNull
        public final ViewerAnnotator annotator;

        EventData(@NotNull DiffViewerBase viewer, @NotNull ViewerAnnotator annotator) {
            if (viewer == null) {
                EventData.$$$reportNull$$$0(0);
            }
            if (annotator == null) {
                EventData.$$$reportNull$$$0(1);
            }
            this.viewer = viewer;
            this.annotator = annotator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$EventData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FileAnnotation annotation;

        AnnotationData(@NotNull AbstractVcs vcs, @NotNull FileAnnotation annotation) {
            if (vcs == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (annotation == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            this.vcs = vcs;
            this.annotation = annotation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$AnnotationData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class FileAnnotationLoader {
        @NotNull
        private final AbstractVcs myVcs;
        @Nullable
        private VcsException myException;
        @Nullable
        private FileAnnotation myResult;

        FileAnnotationLoader(@NotNull AbstractVcs vcs) {
            if (vcs == null) {
                FileAnnotationLoader.$$$reportNull$$$0(0);
            }
            this.myVcs = vcs;
        }

        @Nullable
        public VcsException getException() {
            return this.myException;
        }

        @Nullable
        public AnnotationData getResult() {
            return this.myResult != null ? new AnnotationData(this.myVcs, this.myResult) : null;
        }

        public void run() {
            try {
                this.myResult = this.compute();
            }
            catch (VcsException e) {
                this.myException = e;
            }
        }

        protected abstract FileAnnotation compute() throws VcsException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$FileAnnotationLoader", "<init>"));
        }
    }

    private static abstract class ViewerAnnotator {
        private ViewerAnnotator() {
        }

        @NotNull
        public abstract DiffViewerBase getViewer();

        public abstract boolean isAnnotationShown();

        public abstract void showAnnotation(@NotNull AnnotationData var1);

        public abstract void hideAnnotation();

        @Nullable
        public abstract FileAnnotationLoader createAnnotationsLoader();

        @NotNull
        public abstract BackgroundableActionLock getBackgroundableLock();
    }

    private static abstract class ViewerAnnotatorFactory<T extends DiffViewerBase> {
        private ViewerAnnotatorFactory() {
        }

        @NotNull
        public abstract Class<? extends T> getViewerClass();

        @Nullable
        public abstract ViewerAnnotator createAnnotator(@NotNull T var1, @NotNull Editor var2);

        public abstract void showRememberedAnnotations(@NotNull T var1);

        public abstract void rememberShownAnnotations(@NotNull T var1);
    }

    private static abstract class ThreesideViewerAnnotatorFactory<T extends DiffViewerBase>
    extends ViewerAnnotatorFactory<T> {
        private ThreesideViewerAnnotatorFactory() {
        }

        @Nullable
        public abstract ThreeSide getCurrentSide(@NotNull T var1, @NotNull Editor var2);

        public abstract boolean isAnnotationShown(@NotNull T var1, @NotNull ThreeSide var2);

        public abstract void showAnnotation(@NotNull T var1, @NotNull ThreeSide var2, @NotNull AnnotationData var3);

        public abstract void hideAnnotation(@NotNull T var1, @NotNull ThreeSide var2);

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Editor editor) {
            ThreeSide side;
            if (viewer == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(1);
            }
            if ((side = this.getCurrentSide(viewer, editor)) == null) {
                return null;
            }
            return this.createAnnotator(viewer, side);
        }

        @Override
        public void showRememberedAnnotations(@NotNull T viewer) {
            ViewerAnnotator annotator;
            boolean[] annotationsShown;
            if (viewer == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if ((annotationsShown = (boolean[])viewer.getRequest().getUserData(Holder.ANNOTATIONS_SHOWN_KEY)) == null || annotationsShown.length != 3) {
                return;
            }
            if (annotationsShown[0] && (annotator = this.createAnnotator(viewer, ThreeSide.LEFT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[1] && (annotator = this.createAnnotator(viewer, ThreeSide.BASE)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[2] && (annotator = this.createAnnotator(viewer, ThreeSide.RIGHT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
        }

        @Override
        public void rememberShownAnnotations(@NotNull T viewer) {
            if (viewer == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(3);
            }
            boolean[] annotationsShown = new boolean[]{this.isAnnotationShown(viewer, ThreeSide.LEFT), this.isAnnotationShown(viewer, ThreeSide.BASE), this.isAnnotationShown(viewer, ThreeSide.RIGHT)};
            viewer.getRequest().putUserData(Holder.ANNOTATIONS_SHOWN_KEY, (Object)annotationsShown);
        }

        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                ThreesideViewerAnnotatorFactory.$$$reportNull$$$0(5);
            }
            ThreesideViewerAnnotatorFactory factory = this;
            Project project = viewer.getProject();
            assert (project != null);
            BackgroundableActionLock actionLock = BackgroundableActionLock.getLock(project, new Object[]{VcsBackgroundableActions.ANNOTATE, viewer, side});
            return new ViewerAnnotator((DiffViewerBase)viewer, factory, side, project, actionLock){
                final /* synthetic */ DiffViewerBase val$viewer;
                final /* synthetic */ ThreesideViewerAnnotatorFactory val$factory;
                final /* synthetic */ ThreeSide val$side;
                final /* synthetic */ Project val$project;
                final /* synthetic */ BackgroundableActionLock val$actionLock;
                {
                    this.val$viewer = diffViewerBase;
                    this.val$factory = threesideViewerAnnotatorFactory;
                    this.val$side = threeSide;
                    this.val$project = project;
                    this.val$actionLock = backgroundableActionLock;
                }

                @NotNull
                public T getViewer() {
                    DiffViewerBase diffViewerBase = this.val$viewer;
                    if (diffViewerBase == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return diffViewerBase;
                }

                @Override
                public boolean isAnnotationShown() {
                    return this.val$factory.isAnnotationShown(this.val$viewer, this.val$side);
                }

                @Override
                public void showAnnotation(@NotNull AnnotationData data) {
                    if (data == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.val$factory.showAnnotation(this.val$viewer, this.val$side, data);
                }

                @Override
                public void hideAnnotation() {
                    this.val$factory.hideAnnotation(this.val$viewer, this.val$side);
                }

                @Override
                @Nullable
                public FileAnnotationLoader createAnnotationsLoader() {
                    return AnnotateDiffViewerAction.createThreesideAnnotationsLoader(this.val$project, (DiffRequest)this.val$viewer.getRequest(), this.val$side);
                }

                @Override
                @NotNull
                public BackgroundableActionLock getBackgroundableLock() {
                    BackgroundableActionLock backgroundableActionLock = this.val$actionLock;
                    if (backgroundableActionLock == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return backgroundableActionLock;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getViewer";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getBackgroundableLock";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "showAnnotation";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideViewerAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAnnotator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showRememberedAnnotations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rememberShownAnnotations";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TwosideViewerAnnotatorFactory<T extends DiffViewerBase>
    extends ViewerAnnotatorFactory<T> {
        private TwosideViewerAnnotatorFactory() {
        }

        @Nullable
        public abstract Side getCurrentSide(@NotNull T var1, @NotNull Editor var2);

        public abstract boolean isAnnotationShown(@NotNull T var1, @NotNull Side var2);

        public abstract void showAnnotation(@NotNull T var1, @NotNull Side var2, @NotNull AnnotationData var3);

        public abstract void hideAnnotation(@NotNull T var1, @NotNull Side var2);

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Editor editor) {
            Side side;
            if (viewer == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(1);
            }
            if ((side = this.getCurrentSide(viewer, editor)) == null) {
                return null;
            }
            return this.createAnnotator(viewer, side);
        }

        @Override
        public void showRememberedAnnotations(@NotNull T viewer) {
            ViewerAnnotator annotator;
            boolean[] annotationsShown;
            if (viewer == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if ((annotationsShown = (boolean[])viewer.getRequest().getUserData(Holder.ANNOTATIONS_SHOWN_KEY)) == null || annotationsShown.length != 2) {
                return;
            }
            if (annotationsShown[0] && (annotator = this.createAnnotator(viewer, Side.LEFT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
            if (annotationsShown[1] && (annotator = this.createAnnotator(viewer, Side.RIGHT)) != null) {
                AnnotateDiffViewerAction.doAnnotate(annotator);
            }
        }

        @Override
        public void rememberShownAnnotations(@NotNull T viewer) {
            if (viewer == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(3);
            }
            boolean[] annotationsShown = new boolean[]{this.isAnnotationShown(viewer, Side.LEFT), this.isAnnotationShown(viewer, Side.RIGHT)};
            viewer.getRequest().putUserData(Holder.ANNOTATIONS_SHOWN_KEY, (Object)annotationsShown);
        }

        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull T viewer, @NotNull Side side) {
            if (viewer == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                TwosideViewerAnnotatorFactory.$$$reportNull$$$0(5);
            }
            TwosideViewerAnnotatorFactory factory = this;
            Project project = viewer.getProject();
            assert (project != null);
            return new ViewerAnnotator((DiffViewerBase)viewer, factory, side, project){
                final /* synthetic */ DiffViewerBase val$viewer;
                final /* synthetic */ TwosideViewerAnnotatorFactory val$factory;
                final /* synthetic */ Side val$side;
                final /* synthetic */ Project val$project;
                {
                    this.val$viewer = diffViewerBase;
                    this.val$factory = twosideViewerAnnotatorFactory;
                    this.val$side = side;
                    this.val$project = project;
                }

                @NotNull
                public T getViewer() {
                    DiffViewerBase diffViewerBase = this.val$viewer;
                    if (diffViewerBase == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return diffViewerBase;
                }

                @Override
                public boolean isAnnotationShown() {
                    return this.val$factory.isAnnotationShown(this.val$viewer, this.val$side);
                }

                @Override
                public void showAnnotation(@NotNull AnnotationData data) {
                    if (data == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.val$factory.showAnnotation(this.val$viewer, this.val$side, data);
                }

                @Override
                public void hideAnnotation() {
                    this.val$factory.hideAnnotation(this.val$viewer, this.val$side);
                }

                @Override
                @Nullable
                public FileAnnotationLoader createAnnotationsLoader() {
                    return AnnotateDiffViewerAction.createTwosideAnnotationsLoader(this.val$project, (DiffRequest)this.val$viewer.getRequest(), this.val$side);
                }

                @Override
                @NotNull
                public BackgroundableActionLock getBackgroundableLock() {
                    BackgroundableActionLock backgroundableActionLock = BackgroundableActionLock.getLock(this.val$viewer.getProject(), new Object[]{VcsBackgroundableActions.ANNOTATE, this.val$viewer, this.val$side});
                    if (backgroundableActionLock == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return backgroundableActionLock;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getViewer";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getBackgroundableLock";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "showAnnotation";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideViewerAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAnnotator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showRememberedAnnotations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rememberShownAnnotations";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextMergeAnnotatorFactory
    extends ThreesideAnnotatorFactory {
        private TextMergeAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<? extends ThreesideTextDiffViewerEx> getViewerClass() {
            return TextMergeViewer.MyThreesideViewer.class;
        }

        @Override
        @Nullable
        public ViewerAnnotator createAnnotator(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                TextMergeAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (side == null) {
                TextMergeAnnotatorFactory.$$$reportNull$$$0(1);
            }
            if (side == ThreeSide.BASE) {
                return null;
            }
            return super.createAnnotator(viewer, side);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "side";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TextMergeAnnotatorFactory";
            objectArray[2] = "createAnnotator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThreesideAnnotatorFactory
    extends ThreesideViewerAnnotatorFactory<ThreesideTextDiffViewerEx> {
        private ThreesideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<? extends ThreesideTextDiffViewerEx> getViewerClass() {
            return SimpleThreesideDiffViewer.class;
        }

        @Override
        @Nullable
        public ThreeSide getCurrentSide(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull Editor editor) {
            if (viewer == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(1);
            }
            ThreeSide side = null;
            if (viewer.getEditor(ThreeSide.LEFT) == editor) {
                side = ThreeSide.LEFT;
            }
            if (viewer.getEditor(ThreeSide.BASE) == editor) {
                side = ThreeSide.BASE;
            }
            if (viewer.getEditor(ThreeSide.RIGHT) == editor) {
                side = ThreeSide.RIGHT;
            }
            return side;
        }

        @Override
        public boolean isAnnotationShown(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if (side == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(3);
            }
            return AnnotateToggleAction.hasVcsAnnotations((Editor)viewer.getEditor(side));
        }

        @Override
        public void showAnnotation(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side, @NotNull AnnotationData data) {
            if (viewer == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(5);
            }
            if (data == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(6);
            }
            Project project = Objects.requireNonNull(viewer.getProject());
            AnnotateToggleAction.doAnnotate((Editor)viewer.getEditor(side), project, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull ThreesideTextDiffViewerEx viewer, @NotNull ThreeSide side) {
            if (viewer == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(7);
            }
            if (side == null) {
                ThreesideAnnotatorFactory.$$$reportNull$$$0(8);
            }
            AnnotateToggleAction.closeVcsAnnotations((Editor)viewer.getEditor(side));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$ThreesideAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentSide";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotationShown";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAnnotation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hideAnnotation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnifiedUpToDateLineNumberProvider
    implements UpToDateLineNumberProvider {
        @NotNull
        private final UnifiedDiffViewer myViewer;
        @NotNull
        private final Side mySide;
        @NotNull
        private final UpToDateLineNumberProvider myLocalChangesProvider;

        UnifiedUpToDateLineNumberProvider(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                UnifiedUpToDateLineNumberProvider.$$$reportNull$$$0(0);
            }
            if (side == null) {
                UnifiedUpToDateLineNumberProvider.$$$reportNull$$$0(1);
            }
            this.myViewer = viewer;
            this.mySide = side;
            this.myLocalChangesProvider = new UpToDateLineNumberProviderImpl(this.myViewer.getDocument(this.mySide), viewer.getProject());
        }

        public int getLineNumber(int currentNumber) {
            int number = this.myViewer.transferLineFromOnesideStrict(this.mySide, currentNumber);
            return number != -1 ? this.myLocalChangesProvider.getLineNumber(number) : -2;
        }

        public boolean isLineChanged(int currentNumber) {
            return this.getLineNumber(currentNumber) == -1;
        }

        public boolean isRangeChanged(int start2, int end) {
            int line1 = this.myViewer.transferLineFromOnesideStrict(this.mySide, start2);
            int line2 = this.myViewer.transferLineFromOnesideStrict(this.mySide, end);
            if (line2 - line1 != end - start2) {
                return true;
            }
            for (int i = start2; i <= end; ++i) {
                if (!this.isLineChanged(i)) continue;
                return true;
            }
            return this.myLocalChangesProvider.isRangeChanged(line1, line2);
        }

        public int getLineCount() {
            return this.myLocalChangesProvider.getLineCount();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "side";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedUpToDateLineNumberProvider";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnifiedAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<UnifiedDiffViewer> {
        private UnifiedAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<UnifiedDiffViewer> getViewerClass() {
            return UnifiedDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull UnifiedDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(1);
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getMasterSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if (side == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(3);
            }
            if (side != viewer.getMasterSide()) {
                return false;
            }
            return AnnotateToggleAction.hasVcsAnnotations((Editor)viewer.getEditor());
        }

        @Override
        public void showAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(5);
            }
            if (data == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(6);
            }
            if (side != viewer.getMasterSide()) {
                return;
            }
            Project project = Objects.requireNonNull(viewer.getProject());
            UnifiedUpToDateLineNumberProvider lineNumberProvider = new UnifiedUpToDateLineNumberProvider(viewer, side);
            AnnotateToggleAction.doAnnotate((Editor)viewer.getEditor(), project, data.annotation, data.vcs, lineNumberProvider);
        }

        @Override
        public void hideAnnotation(@NotNull UnifiedDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(7);
            }
            if (side == null) {
                UnifiedAnnotatorFactory.$$$reportNull$$$0(8);
            }
            AnnotateToggleAction.closeVcsAnnotations((Editor)viewer.getEditor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$UnifiedAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentSide";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotationShown";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAnnotation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hideAnnotation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OnesideAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<OnesideTextDiffViewer> {
        private OnesideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<OnesideTextDiffViewer> getViewerClass() {
            return OnesideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull OnesideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(1);
            }
            if (viewer.getEditor() != editor) {
                return null;
            }
            return viewer.getSide();
        }

        @Override
        public boolean isAnnotationShown(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if (side == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(3);
            }
            if (side != viewer.getSide()) {
                return false;
            }
            return AnnotateToggleAction.hasVcsAnnotations((Editor)viewer.getEditor());
        }

        @Override
        public void showAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(5);
            }
            if (data == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(6);
            }
            if (side != viewer.getSide()) {
                return;
            }
            Project project = Objects.requireNonNull(viewer.getProject());
            AnnotateToggleAction.doAnnotate((Editor)viewer.getEditor(), project, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull OnesideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(7);
            }
            if (side == null) {
                OnesideAnnotatorFactory.$$$reportNull$$$0(8);
            }
            AnnotateToggleAction.closeVcsAnnotations((Editor)viewer.getEditor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$OnesideAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentSide";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotationShown";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAnnotation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hideAnnotation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TwosideAnnotatorFactory
    extends TwosideViewerAnnotatorFactory<TwosideTextDiffViewer> {
        private TwosideAnnotatorFactory() {
        }

        @Override
        @NotNull
        public Class<TwosideTextDiffViewer> getViewerClass() {
            return TwosideTextDiffViewer.class;
        }

        @Override
        @Nullable
        public Side getCurrentSide(@NotNull TwosideTextDiffViewer viewer, @NotNull Editor editor) {
            if (viewer == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(1);
            }
            Side side = null;
            if (viewer.getEditor(Side.LEFT) == editor) {
                side = Side.LEFT;
            }
            if (viewer.getEditor(Side.RIGHT) == editor) {
                side = Side.RIGHT;
            }
            return side;
        }

        @Override
        public boolean isAnnotationShown(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(2);
            }
            if (side == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(3);
            }
            return AnnotateToggleAction.hasVcsAnnotations((Editor)viewer.getEditor(side));
        }

        @Override
        public void showAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side, @NotNull AnnotationData data) {
            if (viewer == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(4);
            }
            if (side == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(5);
            }
            if (data == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(6);
            }
            Project project = Objects.requireNonNull(viewer.getProject());
            AnnotateToggleAction.doAnnotate((Editor)viewer.getEditor(side), project, data.annotation, data.vcs);
        }

        @Override
        public void hideAnnotation(@NotNull TwosideTextDiffViewer viewer, @NotNull Side side) {
            if (viewer == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(7);
            }
            if (side == null) {
                TwosideAnnotatorFactory.$$$reportNull$$$0(8);
            }
            AnnotateToggleAction.closeVcsAnnotations((Editor)viewer.getEditor(side));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$TwosideAnnotatorFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCurrentSide";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAnnotationShown";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAnnotation";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hideAnnotation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDiffViewerListener
    extends DiffViewerListener {
        @NotNull
        private final DiffViewerBase myViewer;

        MyDiffViewerListener(@NotNull DiffViewerBase viewer) {
            if (viewer == null) {
                MyDiffViewerListener.$$$reportNull$$$0(0);
            }
            this.myViewer = viewer;
        }

        public void onInit() {
            if (this.myViewer.getProject() == null) {
                return;
            }
            for (ViewerAnnotatorFactory annotator : Holder.ANNOTATORS) {
                if (!annotator.getViewerClass().isInstance(this.myViewer)) continue;
                annotator.showRememberedAnnotations(this.myViewer);
            }
        }

        public void onDispose() {
            if (this.myViewer.getProject() == null) {
                return;
            }
            for (ViewerAnnotatorFactory annotator : Holder.ANNOTATORS) {
                if (!annotator.getViewerClass().isInstance(this.myViewer)) continue;
                annotator.rememberShownAnnotations(this.myViewer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffViewerListener", "<init>"));
        }
    }

    public static class MyDiffExtension
    extends DiffExtension {
        public void onViewerCreated(@NotNull FrameDiffTool.DiffViewer diffViewer, @NotNull DiffContext context, @NotNull DiffRequest request) {
            if (diffViewer == null) {
                MyDiffExtension.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MyDiffExtension.$$$reportNull$$$0(1);
            }
            if (request == null) {
                MyDiffExtension.$$$reportNull$$$0(2);
            }
            if (diffViewer instanceof DiffViewerBase) {
                DiffViewerBase viewer = (DiffViewerBase)diffViewer;
                viewer.addListener((DiffViewerListener)new MyDiffViewerListener(viewer));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "diffViewer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateDiffViewerAction$MyDiffExtension";
            objectArray[2] = "onViewerCreated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final Key<boolean[]> ANNOTATIONS_SHOWN_KEY = Key.create((String)"Diff.AnnotateAction.AnnotationShown");
        private static final ViewerAnnotatorFactory[] ANNOTATORS = new ViewerAnnotatorFactory[]{new TwosideAnnotatorFactory(), new OnesideAnnotatorFactory(), new UnifiedAnnotatorFactory(), new ThreesideAnnotatorFactory(), new TextMergeAnnotatorFactory()};

        private Holder() {
        }
    }
}

