/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = new TodoItem[0];
    private final Project myProject;
    private final String myTitle;
    private final MultiMap<PsiFile, TodoItem> myMap;
    private final Set<PsiFile> myIncludedFiles;
    private PsiTodoSearchHelper myPsiTodoSearchHelper;
    private final ChangeListManager myChangeListManager;

    public CustomChangelistTodosTreeBuilder(JTree tree, Project project, String title2, Collection<? extends TodoItem> todoItems) {
        super(tree, project);
        this.myProject = project;
        this.myTitle = title2;
        this.myMap = new MultiMap();
        this.myIncludedFiles = new HashSet<PsiFile>();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.initMap(todoItems);
        this.initHelper();
    }

    private void initMap(Collection<? extends TodoItem> todoItems) {
        this.buildMap(todoItems);
        this.myIncludedFiles.addAll(this.myMap.keySet());
    }

    private void buildMap(Collection<? extends TodoItem> todoItems) {
        this.myMap.clear();
        for (TodoItem todoItem : todoItems) {
            this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
        }
    }

    private void initHelper() {
        this.myPsiTodoSearchHelper = new PsiTodoSearchHelper(){

            public PsiFile @NotNull [] findFilesWithTodoItems() {
                ArrayList<Change> changes = new ArrayList<Change>();
                List changeLists = CustomChangelistTodosTreeBuilder.this.myChangeListManager.getChangeLists();
                HashMap<VirtualFile, Change> allChanges = new HashMap<VirtualFile, Change>();
                for (LocalChangeList changeList : changeLists) {
                    Collection currChanges = changeList.getChanges();
                    for (Change currChange : currChanges) {
                        if (currChange.getAfterRevision() == null || currChange.getAfterRevision().getFile().getVirtualFile() == null) continue;
                        allChanges.put(currChange.getAfterRevision().getFile().getVirtualFile(), currChange);
                    }
                }
                for (PsiFile next : CustomChangelistTodosTreeBuilder.this.myIncludedFiles) {
                    Change change = (Change)allChanges.get(next.getVirtualFile());
                    if (change == null) continue;
                    changes.add(change);
                }
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(CustomChangelistTodosTreeBuilder.this.myProject, changes, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                worker.execute();
                CustomChangelistTodosTreeBuilder.this.buildMap(worker.inOneList());
                Set files = CustomChangelistTodosTreeBuilder.this.myMap.keySet();
                PsiFile[] psiFileArray = files.toArray(PsiFile.EMPTY_ARRAY);
                if (psiFileArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiFileArray;
            }

            public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                TodoItem[] todoItemArray = CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return todoItemArray;
            }

            public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                TodoItem[] todoItemArray = this.findTodoItems(file);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return todoItemArray;
            }

            public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file, int startOffset, int endOffset) {
                if (file == null) {
                    1.$$$reportNull$$$0(5);
                }
                TodoItem[] todoItemArray = this.findTodoItems(file, startOffset, endOffset);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(6);
                }
                return todoItemArray;
            }

            public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
                TodoItem[] todoItems;
                if (file == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((todoItems = this.findTodoItems(file)).length == 0) {
                    if (todoItems == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return todoItems;
                }
                TextRange textRange = new TextRange(startOffset, endOffset);
                ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
                for (TodoItem todoItem : todoItems) {
                    if (!todoItem.getTextRange().contains(textRange)) continue;
                    result2.add(todoItem);
                }
                TodoItem[] todoItemArray = result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(new TodoItem[0]);
                if (todoItemArray == null) {
                    1.$$$reportNull$$$0(9);
                }
                return todoItemArray;
            }

            public int getTodoItemsCount(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(10);
                }
                return this.findTodoItems(file).length;
            }

            public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
                if (file == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (pattern == null) {
                    1.$$$reportNull$$$0(12);
                }
                TodoFilter filter = new TodoFilter();
                filter.addTodoPattern(pattern);
                return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file, filter).length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findFilesWithTodoItems";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$1";
                        break;
                    }
                    case 2: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findTodoItems";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findTodoItemsLight";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "findTodoItems";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "findTodoItemsLight";
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getTodoItemsCount";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private TodoItem[] findPatternedTodoItems(PsiFile file, TodoFilter todoFilter) {
        Collection todoItems;
        if (!this.myIncludedFiles.contains(file)) {
            return EMPTY_ITEMS;
        }
        if (this.myDirtyFileSet.contains(file.getVirtualFile())) {
            this.myMap.remove((Object)file);
            Change change = this.myChangeListManager.getChange(file.getVirtualFile());
            if (change != null) {
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, Collections.singletonList(change), todoFilter);
                worker.execute();
                Set<TodoItem> todoItems2 = worker.inOneList();
                if (todoItems2 != null && !todoItems2.isEmpty()) {
                    for (TodoItem todoItem : todoItems2) {
                        this.myMap.putValue((Object)file, (Object)todoItem);
                    }
                }
            }
        }
        return (todoItems = this.myMap.get((Object)file)).isEmpty() ? EMPTY_ITEMS : todoItems.toArray(new TodoItem[0]);
    }

    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        return new CustomChangelistTodoTreeStructure(this.myProject, this.myPsiTodoSearchHelper);
    }

    void rebuildCache() {
        PsiFile[] psiFiles;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (PsiFile psiFile : psiFiles = this.myPsiTodoSearchHelper.findFilesWithTodoItems()) {
            if (this.myPsiTodoSearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            files.add(psiFile.getVirtualFile());
        }
        super.rebuildCache(files);
    }
}

