/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class NewBranchAction<T extends Repository>
extends DumbAwareAction {
    public static final Icon icon = AllIcons.General.Add;
    protected final List<T> myRepositories;
    protected final Project myProject;

    public NewBranchAction(@NotNull Project project, @NotNull List<T> repositories) {
        if (project == null) {
            NewBranchAction.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            NewBranchAction.$$$reportNull$$$0(1);
        }
        super(DvcsBundle.messagePointer("new.branch.action.text", new Object[0]), DvcsBundle.messagePointer("new.branch.action.description", new Object[0]), icon);
        this.myRepositories = repositories;
        this.myProject = project;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NewBranchAction.$$$reportNull$$$0(2);
        }
        NewBranchAction.checkIfAnyRepositoryIsFresh(e, this.myRepositories);
    }

    public static <T extends Repository> void checkIfAnyRepositoryIsFresh(@NotNull AnActionEvent e, @NotNull List<T> repositories) {
        if (e == null) {
            NewBranchAction.$$$reportNull$$$0(3);
        }
        if (repositories == null) {
            NewBranchAction.$$$reportNull$$$0(4);
        }
        if (DvcsUtil.anyRepositoryIsFresh(repositories)) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(DvcsBundle.messagePointer("action.presentation.NewBranchAction.description", new Object[0]));
        }
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/NewBranchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfAnyRepositoryIsFresh";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

