/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShRunFileAction
extends DumbAwareAction {
    static final String ID = "runShellFileAction";

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file;
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(0);
        }
        if (!((file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) instanceof ShFile)) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        RunnerAndConfigurationSettings configurationSettings = RunManager.getInstance((Project)project).createConfiguration(file.getName(), ShConfigurationType.class);
        ShRunConfiguration runConfiguration = (ShRunConfiguration)configurationSettings.getConfiguration();
        runConfiguration.setScriptPath(virtualFile.getPath());
        runConfiguration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
        String defaultShell = (String)ObjectUtils.notNull((Object)EnvironmentUtil.getValue((String)"SHELL"), (Object)"/bin/sh");
        runConfiguration.setInterpreterPath((String)ObjectUtils.notNull((Object)ShShebangParserUtil.getShebangExecutable((ShFile)file), (Object)defaultShell));
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)runConfiguration);
        if (builder != null) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(ShRunFileAction.isEnabled(e));
    }

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ShRunFileAction.$$$reportNull$$$0(2);
        }
        return e.getProject() != null && e.getData(CommonDataKeys.PSI_FILE) instanceof ShFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/sh/run/ShRunFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

