/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.codeStyle;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import com.intellij.sh.formatter.ShShfmtFormatterUtil;
import com.intellij.sh.settings.ShSettings;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myPanel;
    private JPanel myRightPanel;
    private JPanel myWarningPanel;
    private JCheckBox myTabCharacter;
    private IntegerField myIndentField;
    private IntegerField myTabField;
    private JLabel myWarningLabel;
    private JLabel myErrorLabel;
    private JCheckBox myBinaryOpsStartLine;
    private JCheckBox mySwitchCasesIndented;
    private JCheckBox myRedirectFollowedBySpace;
    private JCheckBox myKeepColumnAlignmentPadding;
    private JCheckBox myMinifyProgram;
    private ActionLink myShfmtDownloadLink;
    private TextFieldWithBrowseButton myShfmtPathSelector;
    @NonNls
    private static final String GENERAL_CODE_SAMPLE = "#!/usr/bin/env sh\n\nfunction foo() {\n  if [ -x $file ]; then\n    myArray=(item1 item2 item3)\n  elif [ $file1 -nt $file2 ]; then\n    unset myArray\n  else\n    echo \"Usage: $0 file ...\"\n  fi\n}\n\nfor (( i = 0; i < 5; i++ )); do\n  read -p r\n  print -n $r\n  wait $!\ndone\n";

    ShCodeStylePanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super(ShLanguage.INSTANCE, currentSettings, settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myRightPanel);
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        this.myShfmtPathSelector.addBrowseFolderListener(ShBundle.message("sh.code.style.choose.path", new Object[0]), "", project, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myShfmtPathSelector.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShCodeStylePanel.this.myWarningPanel.setVisible(!ShShfmtFormatterUtil.isValidPath(ShCodeStylePanel.this.myShfmtPathSelector.getText()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentEvent", "com/intellij/sh/codeStyle/ShCodeStylePanel$1", "textChanged"));
            }
        });
        this.myWarningLabel.setIcon(AllIcons.General.Warning);
        this.myErrorLabel.setForeground((Color)JBColor.RED);
        this.myBinaryOpsStartLine.setText(ShBundle.message("sh.code.style.binary.ops.like.and.may.start.a.line", new Object[0]));
        this.mySwitchCasesIndented.setText(ShBundle.message("sh.code.style.switch.cases.will.be.indented", new Object[0]));
        this.myRedirectFollowedBySpace.setText(ShBundle.message("sh.code.style.redirect.operators.will.be.followed.by.a.space", new Object[0]));
        this.myKeepColumnAlignmentPadding.setText(ShBundle.message("sh.code.style.keep.column.alignment.padding", new Object[0]));
        this.myMinifyProgram.setText(ShBundle.message("sh.code.style.minify.program.to.reduce.its.size", new Object[0]));
        this.addPanelToWatch(this.myPanel);
    }

    private void createUIComponents() {
        this.myIndentField = new IntegerField(null, 0, 32);
        this.myTabField = new IntegerField(null, 1, 16);
        this.myShfmtDownloadLink = new ActionLink(ShBundle.message("sh.code.style.download.link", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CodeStyleSettings settings = ShCodeStylePanel.this.getSettings();
                ShShfmtFormatterUtil.download(event.getProject(), settings, () -> ShCodeStylePanel.this.myShfmtPathSelector.setText(ShSettings.getShfmtPath()), () -> ShCodeStylePanel.this.myErrorLabel.setVisible(true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/codeStyle/ShCodeStylePanel$2", "actionPerformed"));
            }
        });
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ShLanguage.INSTANCE, null, null);
        return HighlighterFactory.createHighlighter((SyntaxHighlighter)highlighter, (EditorColorsScheme)scheme);
    }

    @NotNull
    protected FileType getFileType() {
        ShFileType shFileType = ShFileType.INSTANCE;
        if (shFileType == null) {
            ShCodeStylePanel.$$$reportNull$$$0(0);
        }
        return shFileType;
    }

    @Nullable
    protected String getPreviewText() {
        return GENERAL_CODE_SAMPLE;
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getLanguageIndentOptions(ShLanguage.INSTANCE);
        indentOptions.INDENT_SIZE = this.myIndentField.getValue();
        indentOptions.TAB_SIZE = this.myTabField.getValue();
        indentOptions.USE_TAB_CHARACTER = this.myTabCharacter.isSelected();
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        shSettings.BINARY_OPS_START_LINE = this.myBinaryOpsStartLine.isSelected();
        shSettings.SWITCH_CASES_INDENTED = this.mySwitchCasesIndented.isSelected();
        shSettings.REDIRECT_FOLLOWED_BY_SPACE = this.myRedirectFollowedBySpace.isSelected();
        shSettings.KEEP_COLUMN_ALIGNMENT_PADDING = this.myKeepColumnAlignmentPadding.isSelected();
        shSettings.MINIFY_PROGRAM = this.myMinifyProgram.isSelected();
        ShSettings.setShfmtPath(this.myShfmtPathSelector.getText());
        this.myWarningPanel.setVisible(!ShShfmtFormatterUtil.isValidPath(this.myShfmtPathSelector.getText()));
        this.myErrorLabel.setVisible(false);
    }

    public boolean isModified(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getLanguageIndentOptions(ShLanguage.INSTANCE);
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        return ShCodeStylePanel.isFieldModified(this.myBinaryOpsStartLine, shSettings.BINARY_OPS_START_LINE) || ShCodeStylePanel.isFieldModified(this.mySwitchCasesIndented, shSettings.SWITCH_CASES_INDENTED) || ShCodeStylePanel.isFieldModified(this.myRedirectFollowedBySpace, shSettings.REDIRECT_FOLLOWED_BY_SPACE) || ShCodeStylePanel.isFieldModified(this.myKeepColumnAlignmentPadding, shSettings.KEEP_COLUMN_ALIGNMENT_PADDING) || ShCodeStylePanel.isFieldModified(this.myMinifyProgram, shSettings.MINIFY_PROGRAM) || ShCodeStylePanel.isFieldModified(this.myTabCharacter, indentOptions.USE_TAB_CHARACTER) || ShCodeStylePanel.isFieldModified(this.myIndentField, indentOptions.INDENT_SIZE) || ShCodeStylePanel.isFieldModified(this.myTabField, indentOptions.TAB_SIZE) || ShCodeStylePanel.isFieldModified(this.myShfmtPathSelector, ShSettings.getShfmtPath());
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getLanguageIndentOptions(ShLanguage.INSTANCE);
        this.myIndentField.setValue(Integer.valueOf(indentOptions.INDENT_SIZE));
        this.myTabField.setValue(Integer.valueOf(indentOptions.TAB_SIZE));
        this.myTabCharacter.setSelected(indentOptions.USE_TAB_CHARACTER);
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        this.myBinaryOpsStartLine.setSelected(shSettings.BINARY_OPS_START_LINE);
        this.mySwitchCasesIndented.setSelected(shSettings.SWITCH_CASES_INDENTED);
        this.myRedirectFollowedBySpace.setSelected(shSettings.REDIRECT_FOLLOWED_BY_SPACE);
        this.myKeepColumnAlignmentPadding.setSelected(shSettings.KEEP_COLUMN_ALIGNMENT_PADDING);
        this.myMinifyProgram.setSelected(shSettings.MINIFY_PROGRAM);
        this.myShfmtPathSelector.setText(ShSettings.getShfmtPath());
        this.myWarningPanel.setVisible(!ShShfmtFormatterUtil.isValidPath(ShSettings.getShfmtPath()));
        this.myErrorLabel.setVisible(false);
    }

    private static boolean isFieldModified(@NotNull JCheckBox checkBox, boolean value) {
        if (checkBox == null) {
            ShCodeStylePanel.$$$reportNull$$$0(1);
        }
        return checkBox.isSelected() != value;
    }

    private static boolean isFieldModified(@NotNull IntegerField textField, int value) {
        if (textField == null) {
            ShCodeStylePanel.$$$reportNull$$$0(2);
        }
        return textField.getValue() != value;
    }

    private static boolean isFieldModified(@NotNull TextFieldWithBrowseButton browseButton, String value) {
        if (browseButton == null) {
            ShCodeStylePanel.$$$reportNull$$$0(3);
        }
        return !browseButton.getText().equals(value);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 10, 0, 10), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.fmt.formatter"));
        jPanel4.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel6);
        this.myBinaryOpsStartLine = jCheckBox6 = new JCheckBox();
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.mySwitchCasesIndented = jCheckBox5 = new JCheckBox();
        jPanel6.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myRedirectFollowedBySpace = jCheckBox4 = new JCheckBox();
        jPanel6.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myKeepColumnAlignmentPadding = jCheckBox3 = new JCheckBox();
        jPanel6.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myMinifyProgram = jCheckBox2 = new JCheckBox();
        jPanel6.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 100), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(10, 0, 0, 0), 30, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ShCodeStylePanel.class).getString("editbox.indent.indent"));
        jPanel7.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField = this.myIndentField;
        jPanel7.add((Component)integerField, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myTabCharacter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ShCodeStylePanel.class).getString("checkbox.indent.use.tab.character"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 9, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.fmt.indent.label"));
        jPanel7.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ShCodeStylePanel.class).getString("editbox.indent.tab.size"));
        jPanel7.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField2 = this.myTabField;
        jPanel7.add((Component)integerField2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myRightPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, new Dimension(-1, 0), null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jBScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 10, 0, 10), 30, -1, false, false));
        jBScrollPane2.setViewportView(jPanel8);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.path.label"));
        jPanel8.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShfmtPathSelector = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myWarningPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        ((Component)jPanel).setEnabled(true);
        ((Component)jPanel).setVisible(false);
        jPanel8.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.invalid.path"));
        Component component = jPanel.add(jLabel);
        ActionLink actionLink = this.myShfmtDownloadLink;
        actionLink.setHorizontalTextPosition(0);
        this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.download"));
        Component component2 = jPanel.add((Component)actionLink);
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.fmt.missing.formatter"));
        Component component3 = jPanel.add(jLabel5);
        JBLabel jBLabel = new JBLabel();
        this.myErrorLabel = jBLabel;
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ShBundle", ShCodeStylePanel.class).getString("sh.fmt.cannot.download"));
        jBLabel.setVisible(false);
        jPanel8.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/codeStyle/ShCodeStylePanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browseButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/codeStyle/ShCodeStylePanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFieldModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

